package redis

import "time"

type Config struct {
	Address      string
	Expiration   time.Duration
	DialTimeout  time.Duration
	ReadTimeout  time.Duration
	WriteTimeout time.Duration
}

const (
	defaultAddress      = "localhost:6379"
	defaultExpirtation  = time.Duration(7200) * time.Second
	defaultDialTimeout  = 30 * time.Second
	defaultReadTimeout  = 30 * time.Second
	defaultWriteTimeout = 30 * time.Second
)

func (c *Config) address() string {
	if c.Address == "" {
		return defaultAddress
	}
	return c.Address
}

func (c *Config) dialTimeout() time.Duration {
	if c.DialTimeout == 0 {
		return defaultDialTimeout
	}
	return c.DialTimeout
}

func (c *Config) expiration() time.Duration {
	if c.Expiration == 0 {
		return defaultExpirtation
	}
	return c.Expiration
}

func (c *Config) readTimeout() time.Duration {
	if c.ReadTimeout == 0 {
		return defaultReadTimeout
	}
	return c.ReadTimeout
}

func (c *Config) writeTimeout() time.Duration {
	if c.WriteTimeout == 0 {
		return defaultWriteTimeout
	}
	return c.WriteTimeout
}
