package redis

import (
	"context"
	"fmt"

	"code.justin.tv/chat/rediczar"
	"github.com/go-redis/redis/v7"

	log "github.com/sirupsen/logrus"
)

//go:generate mockery -name RedisClient
type RedisClient interface {
	Get(context.Context, string) (string, bool)
	Set(context.Context, string, string) error
}

type redisClient struct {
	Client *rediczar.Client
	Config *Config
}

func NewRedisClient(c *Config) (RedisClient, error) {
	client := redis.NewClient(&redis.Options{
		Addr: c.address(),
	})

	r := rediczar.Client{
		Commands: &rediczar.PrefixedCommands{
			Redis: client,
		},
	}
	return &redisClient{Client: &r, Config: c}, nil
}

func (c *redisClient) Get(ctx context.Context, key string) (string, bool) {
	val, err := c.Client.Get(ctx, key)
	if err == redis.Nil {
		return val, false
	} else if err != nil {
		log.Error(ctx, fmt.Sprintf("Couldn't get value from redis: %v", err))
		return val, false
	}
	return val, true
}

func (c *redisClient) Set(ctx context.Context, key string, prop string) error {
	if _, err := c.Client.Set(ctx, key, prop, c.Config.expiration()); err != nil {
		log.Error(ctx, fmt.Sprintf("Couldn't set value in redis: %v", err))
	}
	return nil
}
