// Code generated by rediczar gen tool. DO NOT EDIT

package rediczar

import (
	"context"
	"time"

	"github.com/go-redis/redis/v7"
)

// Commands defines context-aware Redis commands
type Commands interface {
	// Pipeline can send batches of commands and get a reply in a single step. See https://redis.io/topics/pipelining
	// Exec() on the Pipeliner executes the batch. Close() the pipeliner after using it
	Pipeline(ctx context.Context) redis.Pipeliner

	// Pipelined is like Pipeline. The commands are automatically executed at the end of fn
	Pipelined(ctx context.Context, fn func(redis.Pipeliner) error) ([]redis.Cmder, error)

	// TxPipeline is like Pipeline, but executes in a transaction using MULTI and EXEC. See https://redis.io/topics/transactions
	// Exec() on the Pipeliner executes the transaction. Close() the pipeliner after using it
	TxPipeline(ctx context.Context) redis.Pipeliner

	// TxPipelined is like TxPipeline. The commands are automatically executed at the end of fn
	TxPipelined(ctx context.Context, fn func(redis.Pipeliner) error) ([]redis.Cmder, error)

	// Append executes the Append command
	Append(ctx context.Context, key string, value string) (int64, error)

	// BLPop executes the BLPop command
	BLPop(ctx context.Context, timeout time.Duration, keys ...string) ([]string, error)

	// BRPop executes the BRPop command
	BRPop(ctx context.Context, timeout time.Duration, keys ...string) ([]string, error)

	// BRPopLPush executes the BRPopLPush command
	BRPopLPush(ctx context.Context, source string, destination string, timeout time.Duration) (string, error)

	// BZPopMax executes the BZPopMax command
	BZPopMax(ctx context.Context, timeout time.Duration, keys ...string) (*redis.ZWithKey, error)

	// BZPopMin executes the BZPopMin command
	BZPopMin(ctx context.Context, timeout time.Duration, keys ...string) (*redis.ZWithKey, error)

	// BgRewriteAOF executes the BgRewriteAOF command
	BgRewriteAOF(ctx context.Context) (string, error)

	// BgSave executes the BgSave command
	BgSave(ctx context.Context) (string, error)

	// BitCount executes the BitCount command
	BitCount(ctx context.Context, key string, bitCount *redis.BitCount) (int64, error)

	// BitField executes the BitField command
	BitField(ctx context.Context, key string, args ...interface{}) ([]int64, error)

	// BitOpAnd executes the BitOpAnd command
	BitOpAnd(ctx context.Context, destKey string, keys ...string) (int64, error)

	// BitOpNot executes the BitOpNot command
	BitOpNot(ctx context.Context, destKey string, key string) (int64, error)

	// BitOpOr executes the BitOpOr command
	BitOpOr(ctx context.Context, destKey string, keys ...string) (int64, error)

	// BitOpXor executes the BitOpXor command
	BitOpXor(ctx context.Context, destKey string, keys ...string) (int64, error)

	// BitPos executes the BitPos command
	BitPos(ctx context.Context, key string, bit int64, pos ...int64) (int64, error)

	// ClientGetName executes the ClientGetName command
	ClientGetName(ctx context.Context) (string, error)

	// ClientID executes the ClientID command
	ClientID(ctx context.Context) (int64, error)

	// ClientKill executes the ClientKill command
	ClientKill(ctx context.Context, ipPort string) (string, error)

	// ClientKillByFilter executes the ClientKillByFilter command
	ClientKillByFilter(ctx context.Context, keys ...string) (int64, error)

	// ClientList executes the ClientList command
	ClientList(ctx context.Context) (string, error)

	// ClientPause executes the ClientPause command
	ClientPause(ctx context.Context, dur time.Duration) (bool, error)

	// ClusterAddSlots executes the ClusterAddSlots command
	ClusterAddSlots(ctx context.Context, slots ...int) (string, error)

	// ClusterAddSlotsRange executes the ClusterAddSlotsRange command
	ClusterAddSlotsRange(ctx context.Context, min int, max int) (string, error)

	// ClusterCountFailureReports executes the ClusterCountFailureReports command
	ClusterCountFailureReports(ctx context.Context, nodeID string) (int64, error)

	// ClusterCountKeysInSlot executes the ClusterCountKeysInSlot command
	ClusterCountKeysInSlot(ctx context.Context, slot int) (int64, error)

	// ClusterDelSlots executes the ClusterDelSlots command
	ClusterDelSlots(ctx context.Context, slots ...int) (string, error)

	// ClusterDelSlotsRange executes the ClusterDelSlotsRange command
	ClusterDelSlotsRange(ctx context.Context, min int, max int) (string, error)

	// ClusterFailover executes the ClusterFailover command
	ClusterFailover(ctx context.Context) (string, error)

	// ClusterForget executes the ClusterForget command
	ClusterForget(ctx context.Context, nodeID string) (string, error)

	// ClusterGetKeysInSlot executes the ClusterGetKeysInSlot command
	ClusterGetKeysInSlot(ctx context.Context, slot int, count int) ([]string, error)

	// ClusterInfo executes the ClusterInfo command
	ClusterInfo(ctx context.Context) (string, error)

	// ClusterKeySlot executes the ClusterKeySlot command
	ClusterKeySlot(ctx context.Context, key string) (int64, error)

	// ClusterMeet executes the ClusterMeet command
	ClusterMeet(ctx context.Context, host string, port string) (string, error)

	// ClusterNodes executes the ClusterNodes command
	ClusterNodes(ctx context.Context) (string, error)

	// ClusterReplicate executes the ClusterReplicate command
	ClusterReplicate(ctx context.Context, nodeID string) (string, error)

	// ClusterResetHard executes the ClusterResetHard command
	ClusterResetHard(ctx context.Context) (string, error)

	// ClusterResetSoft executes the ClusterResetSoft command
	ClusterResetSoft(ctx context.Context) (string, error)

	// ClusterSaveConfig executes the ClusterSaveConfig command
	ClusterSaveConfig(ctx context.Context) (string, error)

	// ClusterSlaves executes the ClusterSlaves command
	ClusterSlaves(ctx context.Context, nodeID string) ([]string, error)

	// ClusterSlots executes the ClusterSlots command
	ClusterSlots(ctx context.Context) ([]redis.ClusterSlot, error)

	// Command executes the Command command
	Command(ctx context.Context) (map[string]*redis.CommandInfo, error)

	// ConfigGet executes the ConfigGet command
	ConfigGet(ctx context.Context, parameter string) ([]interface{}, error)

	// ConfigResetStat executes the ConfigResetStat command
	ConfigResetStat(ctx context.Context) (string, error)

	// ConfigRewrite executes the ConfigRewrite command
	ConfigRewrite(ctx context.Context) (string, error)

	// ConfigSet executes the ConfigSet command
	ConfigSet(ctx context.Context, parameter string, value string) (string, error)

	// DBSize executes the DBSize command
	DBSize(ctx context.Context) (int64, error)

	// DebugObject executes the DebugObject command
	DebugObject(ctx context.Context, key string) (string, error)

	// Decr executes the Decr command
	Decr(ctx context.Context, key string) (int64, error)

	// DecrBy executes the DecrBy command
	DecrBy(ctx context.Context, key string, decrement int64) (int64, error)

	// Del executes the Del command
	Del(ctx context.Context, keys ...string) (int64, error)

	// Dump executes the Dump command
	Dump(ctx context.Context, key string) (string, error)

	// Echo executes the Echo command
	Echo(ctx context.Context, message interface{}) (string, error)

	// Eval executes the Eval command
	Eval(ctx context.Context, script string, keys []string, args ...interface{}) (interface{}, error)

	// EvalSha executes the EvalSha command
	EvalSha(ctx context.Context, sha1 string, keys []string, args ...interface{}) (interface{}, error)

	// Exists executes the Exists command
	Exists(ctx context.Context, keys ...string) (int64, error)

	// Expire executes the Expire command
	Expire(ctx context.Context, key string, expiration time.Duration) (bool, error)

	// ExpireAt executes the ExpireAt command
	ExpireAt(ctx context.Context, key string, tm time.Time) (bool, error)

	// FlushAll executes the FlushAll command
	FlushAll(ctx context.Context) (string, error)

	// FlushAllAsync executes the FlushAllAsync command
	FlushAllAsync(ctx context.Context) (string, error)

	// FlushDB executes the FlushDB command
	FlushDB(ctx context.Context) (string, error)

	// FlushDBAsync executes the FlushDBAsync command
	FlushDBAsync(ctx context.Context) (string, error)

	// GeoAdd executes the GeoAdd command
	GeoAdd(ctx context.Context, key string, geoLocation ...*redis.GeoLocation) (int64, error)

	// GeoDist executes the GeoDist command
	GeoDist(ctx context.Context, key string, member1 string, member2 string, unit string) (float64, error)

	// GeoHash executes the GeoHash command
	GeoHash(ctx context.Context, key string, members ...string) ([]string, error)

	// GeoPos executes the GeoPos command
	GeoPos(ctx context.Context, key string, members ...string) ([]*redis.GeoPos, error)

	// GeoRadius executes the GeoRadius command
	GeoRadius(ctx context.Context, key string, longitude float64, latitude float64, query *redis.GeoRadiusQuery) ([]redis.GeoLocation, error)

	// GeoRadiusByMember executes the GeoRadiusByMember command
	GeoRadiusByMember(ctx context.Context, key string, member string, query *redis.GeoRadiusQuery) ([]redis.GeoLocation, error)

	// GeoRadiusByMemberStore executes the GeoRadiusByMemberStore command
	GeoRadiusByMemberStore(ctx context.Context, key string, member string, query *redis.GeoRadiusQuery) (int64, error)

	// GeoRadiusStore executes the GeoRadiusStore command
	GeoRadiusStore(ctx context.Context, key string, longitude float64, latitude float64, query *redis.GeoRadiusQuery) (int64, error)

	// Get executes the Get command
	Get(ctx context.Context, key string) (string, error)

	// GetBit executes the GetBit command
	GetBit(ctx context.Context, key string, offset int64) (int64, error)

	// GetRange executes the GetRange command
	GetRange(ctx context.Context, key string, start int64, end int64) (string, error)

	// GetSet executes the GetSet command
	GetSet(ctx context.Context, key string, value interface{}) (string, error)

	// HDel executes the HDel command
	HDel(ctx context.Context, key string, fields ...string) (int64, error)

	// HExists executes the HExists command
	HExists(ctx context.Context, key string, field string) (bool, error)

	// HGet executes the HGet command
	HGet(ctx context.Context, key string, field string) (string, error)

	// HGetAll executes the HGetAll command
	HGetAll(ctx context.Context, key string) (map[string]string, error)

	// HIncrBy executes the HIncrBy command
	HIncrBy(ctx context.Context, key string, field string, incr int64) (int64, error)

	// HIncrByFloat executes the HIncrByFloat command
	HIncrByFloat(ctx context.Context, key string, field string, incr float64) (float64, error)

	// HKeys executes the HKeys command
	HKeys(ctx context.Context, key string) ([]string, error)

	// HLen executes the HLen command
	HLen(ctx context.Context, key string) (int64, error)

	// HMGet executes the HMGet command
	HMGet(ctx context.Context, key string, fields ...string) ([]interface{}, error)

	// HMSet executes the HMSet command
	HMSet(ctx context.Context, key string, fields map[string]interface{}) (string, error)

	// HScan executes the HScan command
	HScan(ctx context.Context, key string, cursor uint64, match string, count int64) ([]string, uint64, error)

	// HSet executes the HSet command
	HSet(ctx context.Context, key string, field string, value interface{}) (bool, error)

	// HSetNX executes the HSetNX command
	HSetNX(ctx context.Context, key string, field string, value interface{}) (bool, error)

	// HVals executes the HVals command
	HVals(ctx context.Context, key string) ([]string, error)

	// Incr executes the Incr command
	Incr(ctx context.Context, key string) (int64, error)

	// IncrBy executes the IncrBy command
	IncrBy(ctx context.Context, key string, value int64) (int64, error)

	// IncrByFloat executes the IncrByFloat command
	IncrByFloat(ctx context.Context, key string, value float64) (float64, error)

	// Info executes the Info command
	Info(ctx context.Context, section ...string) (string, error)

	// Keys executes the Keys command
	Keys(ctx context.Context, pattern string) ([]string, error)

	// LIndex executes the LIndex command
	LIndex(ctx context.Context, key string, index int64) (string, error)

	// LInsert executes the LInsert command
	LInsert(ctx context.Context, key string, op string, pivot interface{}, value interface{}) (int64, error)

	// LInsertAfter executes the LInsertAfter command
	LInsertAfter(ctx context.Context, key string, pivot interface{}, value interface{}) (int64, error)

	// LInsertBefore executes the LInsertBefore command
	LInsertBefore(ctx context.Context, key string, pivot interface{}, value interface{}) (int64, error)

	// LLen executes the LLen command
	LLen(ctx context.Context, key string) (int64, error)

	// LPop executes the LPop command
	LPop(ctx context.Context, key string) (string, error)

	// LPush executes the LPush command
	LPush(ctx context.Context, key string, values ...interface{}) (int64, error)

	// LPushX executes the LPushX command
	LPushX(ctx context.Context, key string, values ...interface{}) (int64, error)

	// LRange executes the LRange command
	LRange(ctx context.Context, key string, start int64, stop int64) ([]string, error)

	// LRem executes the LRem command
	LRem(ctx context.Context, key string, count int64, value interface{}) (int64, error)

	// LSet executes the LSet command
	LSet(ctx context.Context, key string, index int64, value interface{}) (string, error)

	// LTrim executes the LTrim command
	LTrim(ctx context.Context, key string, start int64, stop int64) (string, error)

	// LastSave executes the LastSave command
	LastSave(ctx context.Context) (int64, error)

	// MGet executes the MGet command
	MGet(ctx context.Context, keys ...string) ([]interface{}, error)

	// MSet executes the MSet command
	MSet(ctx context.Context, pairs ...interface{}) (string, error)

	// MSetNX executes the MSetNX command
	MSetNX(ctx context.Context, pairs ...interface{}) (bool, error)

	// MemoryUsage executes the MemoryUsage command
	MemoryUsage(ctx context.Context, key string, samples ...int) (int64, error)

	// Migrate executes the Migrate command
	Migrate(ctx context.Context, host string, port string, key string, db int, timeout time.Duration) (string, error)

	// Move executes the Move command
	Move(ctx context.Context, key string, db int) (bool, error)

	// ObjectEncoding executes the ObjectEncoding command
	ObjectEncoding(ctx context.Context, key string) (string, error)

	// ObjectIdleTime executes the ObjectIdleTime command
	ObjectIdleTime(ctx context.Context, key string) (time.Duration, error)

	// ObjectRefCount executes the ObjectRefCount command
	ObjectRefCount(ctx context.Context, key string) (int64, error)

	// PExpire executes the PExpire command
	PExpire(ctx context.Context, key string, expiration time.Duration) (bool, error)

	// PExpireAt executes the PExpireAt command
	PExpireAt(ctx context.Context, key string, tm time.Time) (bool, error)

	// PFAdd executes the PFAdd command
	PFAdd(ctx context.Context, key string, els ...interface{}) (int64, error)

	// PFCount executes the PFCount command
	PFCount(ctx context.Context, keys ...string) (int64, error)

	// PFMerge executes the PFMerge command
	PFMerge(ctx context.Context, dest string, keys ...string) (string, error)

	// PTTL executes the PTTL command
	PTTL(ctx context.Context, key string) (time.Duration, error)

	// Persist executes the Persist command
	Persist(ctx context.Context, key string) (bool, error)

	// Ping executes the Ping command
	Ping(ctx context.Context) (string, error)

	// PubSubChannels executes the PubSubChannels command
	PubSubChannels(ctx context.Context, pattern string) ([]string, error)

	// PubSubNumPat executes the PubSubNumPat command
	PubSubNumPat(ctx context.Context) (int64, error)

	// PubSubNumSub executes the PubSubNumSub command
	PubSubNumSub(ctx context.Context, channels ...string) (map[string]int64, error)

	// Publish executes the Publish command
	Publish(ctx context.Context, channel string, message interface{}) (int64, error)

	// Quit executes the Quit command
	Quit(ctx context.Context) (string, error)

	// RPop executes the RPop command
	RPop(ctx context.Context, key string) (string, error)

	// RPopLPush executes the RPopLPush command
	RPopLPush(ctx context.Context, source string, destination string) (string, error)

	// RPush executes the RPush command
	RPush(ctx context.Context, key string, values ...interface{}) (int64, error)

	// RPushX executes the RPushX command
	RPushX(ctx context.Context, key string, values ...interface{}) (int64, error)

	// RandomKey executes the RandomKey command
	RandomKey(ctx context.Context) (string, error)

	// ReadOnly executes the ReadOnly command
	ReadOnly(ctx context.Context) (string, error)

	// ReadWrite executes the ReadWrite command
	ReadWrite(ctx context.Context) (string, error)

	// Rename executes the Rename command
	Rename(ctx context.Context, key string, newkey string) (string, error)

	// RenameNX executes the RenameNX command
	RenameNX(ctx context.Context, key string, newkey string) (bool, error)

	// Restore executes the Restore command
	Restore(ctx context.Context, key string, ttl time.Duration, value string) (string, error)

	// RestoreReplace executes the RestoreReplace command
	RestoreReplace(ctx context.Context, key string, ttl time.Duration, value string) (string, error)

	// SAdd executes the SAdd command
	SAdd(ctx context.Context, key string, members ...interface{}) (int64, error)

	// SCard executes the SCard command
	SCard(ctx context.Context, key string) (int64, error)

	// SDiff executes the SDiff command
	SDiff(ctx context.Context, keys ...string) ([]string, error)

	// SDiffStore executes the SDiffStore command
	SDiffStore(ctx context.Context, destination string, keys ...string) (int64, error)

	// SInter executes the SInter command
	SInter(ctx context.Context, keys ...string) ([]string, error)

	// SInterStore executes the SInterStore command
	SInterStore(ctx context.Context, destination string, keys ...string) (int64, error)

	// SIsMember executes the SIsMember command
	SIsMember(ctx context.Context, key string, member interface{}) (bool, error)

	// SMembers executes the SMembers command
	SMembers(ctx context.Context, key string) ([]string, error)

	// SMembersMap executes the SMembersMap command
	SMembersMap(ctx context.Context, key string) (map[string]struct{}, error)

	// SMove executes the SMove command
	SMove(ctx context.Context, source string, destination string, member interface{}) (bool, error)

	// SPop executes the SPop command
	SPop(ctx context.Context, key string) (string, error)

	// SPopN executes the SPopN command
	SPopN(ctx context.Context, key string, count int64) ([]string, error)

	// SRandMember executes the SRandMember command
	SRandMember(ctx context.Context, key string) (string, error)

	// SRandMemberN executes the SRandMemberN command
	SRandMemberN(ctx context.Context, key string, count int64) ([]string, error)

	// SRem executes the SRem command
	SRem(ctx context.Context, key string, members ...interface{}) (int64, error)

	// SScan executes the SScan command
	SScan(ctx context.Context, key string, cursor uint64, match string, count int64) ([]string, uint64, error)

	// SUnion executes the SUnion command
	SUnion(ctx context.Context, keys ...string) ([]string, error)

	// SUnionStore executes the SUnionStore command
	SUnionStore(ctx context.Context, destination string, keys ...string) (int64, error)

	// Save executes the Save command
	Save(ctx context.Context) (string, error)

	// Scan executes the Scan command
	Scan(ctx context.Context, cursor uint64, match string, count int64) ([]string, uint64, error)

	// ScriptExists executes the ScriptExists command
	ScriptExists(ctx context.Context, hashes ...string) ([]bool, error)

	// ScriptFlush executes the ScriptFlush command
	ScriptFlush(ctx context.Context) (string, error)

	// ScriptKill executes the ScriptKill command
	ScriptKill(ctx context.Context) (string, error)

	// ScriptLoad executes the ScriptLoad command
	ScriptLoad(ctx context.Context, script string) (string, error)

	// Set executes the Set command
	Set(ctx context.Context, key string, value interface{}, expiration time.Duration) (string, error)

	// SetBit executes the SetBit command
	SetBit(ctx context.Context, key string, offset int64, value int) (int64, error)

	// SetNX executes the SetNX command
	SetNX(ctx context.Context, key string, value interface{}, expiration time.Duration) (bool, error)

	// SetRange executes the SetRange command
	SetRange(ctx context.Context, key string, offset int64, value string) (int64, error)

	// SetXX executes the SetXX command
	SetXX(ctx context.Context, key string, value interface{}, expiration time.Duration) (bool, error)

	// Shutdown executes the Shutdown command
	Shutdown(ctx context.Context) (string, error)

	// ShutdownNoSave executes the ShutdownNoSave command
	ShutdownNoSave(ctx context.Context) (string, error)

	// ShutdownSave executes the ShutdownSave command
	ShutdownSave(ctx context.Context) (string, error)

	// SlaveOf executes the SlaveOf command
	SlaveOf(ctx context.Context, host string, port string) (string, error)

	// Sort executes the Sort command
	Sort(ctx context.Context, key string, sort *redis.Sort) ([]string, error)

	// SortInterfaces executes the SortInterfaces command
	SortInterfaces(ctx context.Context, key string, sort *redis.Sort) ([]interface{}, error)

	// SortStore executes the SortStore command
	SortStore(ctx context.Context, key string, store string, sort *redis.Sort) (int64, error)

	// StrLen executes the StrLen command
	StrLen(ctx context.Context, key string) (int64, error)

	// TTL executes the TTL command
	TTL(ctx context.Context, key string) (time.Duration, error)

	// Time executes the Time command
	Time(ctx context.Context) (time.Time, error)

	// Touch executes the Touch command
	Touch(ctx context.Context, keys ...string) (int64, error)

	// Type executes the Type command
	Type(ctx context.Context, key string) (string, error)

	// Unlink executes the Unlink command
	Unlink(ctx context.Context, keys ...string) (int64, error)

	// XAck executes the XAck command
	XAck(ctx context.Context, stream string, group string, ids ...string) (int64, error)

	// XAdd executes the XAdd command
	XAdd(ctx context.Context, a *redis.XAddArgs) (string, error)

	// XClaim executes the XClaim command
	XClaim(ctx context.Context, a *redis.XClaimArgs) ([]redis.XMessage, error)

	// XClaimJustID executes the XClaimJustID command
	XClaimJustID(ctx context.Context, a *redis.XClaimArgs) ([]string, error)

	// XDel executes the XDel command
	XDel(ctx context.Context, stream string, ids ...string) (int64, error)

	// XGroupCreate executes the XGroupCreate command
	XGroupCreate(ctx context.Context, stream string, group string, start string) (string, error)

	// XGroupCreateMkStream executes the XGroupCreateMkStream command
	XGroupCreateMkStream(ctx context.Context, stream string, group string, start string) (string, error)

	// XGroupDelConsumer executes the XGroupDelConsumer command
	XGroupDelConsumer(ctx context.Context, stream string, group string, consumer string) (int64, error)

	// XGroupDestroy executes the XGroupDestroy command
	XGroupDestroy(ctx context.Context, stream string, group string) (int64, error)

	// XGroupSetID executes the XGroupSetID command
	XGroupSetID(ctx context.Context, stream string, group string, start string) (string, error)

	// XLen executes the XLen command
	XLen(ctx context.Context, stream string) (int64, error)

	// XPending executes the XPending command
	XPending(ctx context.Context, stream string, group string) (*redis.XPending, error)

	// XPendingExt executes the XPendingExt command
	XPendingExt(ctx context.Context, a *redis.XPendingExtArgs) ([]redis.XPendingExt, error)

	// XRange executes the XRange command
	XRange(ctx context.Context, stream string, start string, stop string) ([]redis.XMessage, error)

	// XRangeN executes the XRangeN command
	XRangeN(ctx context.Context, stream string, start string, stop string, count int64) ([]redis.XMessage, error)

	// XRead executes the XRead command
	XRead(ctx context.Context, a *redis.XReadArgs) ([]redis.XStream, error)

	// XReadGroup executes the XReadGroup command
	XReadGroup(ctx context.Context, a *redis.XReadGroupArgs) ([]redis.XStream, error)

	// XReadStreams executes the XReadStreams command
	XReadStreams(ctx context.Context, streams ...string) ([]redis.XStream, error)

	// XRevRange executes the XRevRange command
	XRevRange(ctx context.Context, stream string, start string, stop string) ([]redis.XMessage, error)

	// XRevRangeN executes the XRevRangeN command
	XRevRangeN(ctx context.Context, stream string, start string, stop string, count int64) ([]redis.XMessage, error)

	// XTrim executes the XTrim command
	XTrim(ctx context.Context, key string, maxLen int64) (int64, error)

	// XTrimApprox executes the XTrimApprox command
	XTrimApprox(ctx context.Context, key string, maxLen int64) (int64, error)

	// ZAdd executes the ZAdd command
	ZAdd(ctx context.Context, key string, members ...*redis.Z) (int64, error)

	// ZAddCh executes the ZAddCh command
	ZAddCh(ctx context.Context, key string, members ...*redis.Z) (int64, error)

	// ZAddNX executes the ZAddNX command
	ZAddNX(ctx context.Context, key string, members ...*redis.Z) (int64, error)

	// ZAddNXCh executes the ZAddNXCh command
	ZAddNXCh(ctx context.Context, key string, members ...*redis.Z) (int64, error)

	// ZAddXX executes the ZAddXX command
	ZAddXX(ctx context.Context, key string, members ...*redis.Z) (int64, error)

	// ZAddXXCh executes the ZAddXXCh command
	ZAddXXCh(ctx context.Context, key string, members ...*redis.Z) (int64, error)

	// ZCard executes the ZCard command
	ZCard(ctx context.Context, key string) (int64, error)

	// ZCount executes the ZCount command
	ZCount(ctx context.Context, key string, min string, max string) (int64, error)

	// ZIncr executes the ZIncr command
	ZIncr(ctx context.Context, key string, member *redis.Z) (float64, error)

	// ZIncrBy executes the ZIncrBy command
	ZIncrBy(ctx context.Context, key string, increment float64, member string) (float64, error)

	// ZIncrNX executes the ZIncrNX command
	ZIncrNX(ctx context.Context, key string, member *redis.Z) (float64, error)

	// ZIncrXX executes the ZIncrXX command
	ZIncrXX(ctx context.Context, key string, member *redis.Z) (float64, error)

	// ZInterStore executes the ZInterStore command
	ZInterStore(ctx context.Context, destination string, store *redis.ZStore) (int64, error)

	// ZLexCount executes the ZLexCount command
	ZLexCount(ctx context.Context, key string, min string, max string) (int64, error)

	// ZPopMax executes the ZPopMax command
	ZPopMax(ctx context.Context, key string, count ...int64) ([]redis.Z, error)

	// ZPopMin executes the ZPopMin command
	ZPopMin(ctx context.Context, key string, count ...int64) ([]redis.Z, error)

	// ZRange executes the ZRange command
	ZRange(ctx context.Context, key string, start int64, stop int64) ([]string, error)

	// ZRangeByLex executes the ZRangeByLex command
	ZRangeByLex(ctx context.Context, key string, opt *redis.ZRangeBy) ([]string, error)

	// ZRangeByScore executes the ZRangeByScore command
	ZRangeByScore(ctx context.Context, key string, opt *redis.ZRangeBy) ([]string, error)

	// ZRangeByScoreWithScores executes the ZRangeByScoreWithScores command
	ZRangeByScoreWithScores(ctx context.Context, key string, opt *redis.ZRangeBy) ([]redis.Z, error)

	// ZRangeWithScores executes the ZRangeWithScores command
	ZRangeWithScores(ctx context.Context, key string, start int64, stop int64) ([]redis.Z, error)

	// ZRank executes the ZRank command
	ZRank(ctx context.Context, key string, member string) (int64, error)

	// ZRem executes the ZRem command
	ZRem(ctx context.Context, key string, members ...interface{}) (int64, error)

	// ZRemRangeByLex executes the ZRemRangeByLex command
	ZRemRangeByLex(ctx context.Context, key string, min string, max string) (int64, error)

	// ZRemRangeByRank executes the ZRemRangeByRank command
	ZRemRangeByRank(ctx context.Context, key string, start int64, stop int64) (int64, error)

	// ZRemRangeByScore executes the ZRemRangeByScore command
	ZRemRangeByScore(ctx context.Context, key string, min string, max string) (int64, error)

	// ZRevRange executes the ZRevRange command
	ZRevRange(ctx context.Context, key string, start int64, stop int64) ([]string, error)

	// ZRevRangeByLex executes the ZRevRangeByLex command
	ZRevRangeByLex(ctx context.Context, key string, opt *redis.ZRangeBy) ([]string, error)

	// ZRevRangeByScore executes the ZRevRangeByScore command
	ZRevRangeByScore(ctx context.Context, key string, opt *redis.ZRangeBy) ([]string, error)

	// ZRevRangeByScoreWithScores executes the ZRevRangeByScoreWithScores command
	ZRevRangeByScoreWithScores(ctx context.Context, key string, opt *redis.ZRangeBy) ([]redis.Z, error)

	// ZRevRangeWithScores executes the ZRevRangeWithScores command
	ZRevRangeWithScores(ctx context.Context, key string, start int64, stop int64) ([]redis.Z, error)

	// ZRevRank executes the ZRevRank command
	ZRevRank(ctx context.Context, key string, member string) (int64, error)

	// ZScan executes the ZScan command
	ZScan(ctx context.Context, key string, cursor uint64, match string, count int64) ([]string, uint64, error)

	// ZScore executes the ZScore command
	ZScore(ctx context.Context, key string, member string) (float64, error)

	// ZUnionStore executes the ZUnionStore command
	ZUnionStore(ctx context.Context, dest string, store *redis.ZStore) (int64, error)
}

// PrefixedCommands is a context-aware Redis command client with key prefixing support
type PrefixedCommands struct {
	// Redis is the go-redis client
	Redis redis.Cmdable
	// KeyPrefix (if non-blank) is prepended to all keys with ":" as the delimiter
	KeyPrefix string
}

// Append executes the Append command
func (c *PrefixedCommands) Append(ctx context.Context, key string, value string) (int64, error) {
	ctxCmdable := cmdableWithContext(ctx, c.Redis)

	pfxCmdable := prefixerCmdable{
		cmdable:   ctxCmdable,
		keyPrefix: c.KeyPrefix,
	}

	return pfxCmdable.Append(key, value).Result()
}

// BLPop executes the BLPop command
func (c *PrefixedCommands) BLPop(ctx context.Context, timeout time.Duration, keys ...string) ([]string, error) {
	ctxCmdable := cmdableWithContext(ctx, c.Redis)

	pfxCmdable := prefixerCmdable{
		cmdable:   ctxCmdable,
		keyPrefix: c.KeyPrefix,
	}

	return pfxCmdable.BLPop(timeout, keys...).Result()
}

// BRPop executes the BRPop command
func (c *PrefixedCommands) BRPop(ctx context.Context, timeout time.Duration, keys ...string) ([]string, error) {
	ctxCmdable := cmdableWithContext(ctx, c.Redis)

	pfxCmdable := prefixerCmdable{
		cmdable:   ctxCmdable,
		keyPrefix: c.KeyPrefix,
	}

	return pfxCmdable.BRPop(timeout, keys...).Result()
}

// BRPopLPush executes the BRPopLPush command
func (c *PrefixedCommands) BRPopLPush(ctx context.Context, source string, destination string, timeout time.Duration) (string, error) {
	ctxCmdable := cmdableWithContext(ctx, c.Redis)

	pfxCmdable := prefixerCmdable{
		cmdable:   ctxCmdable,
		keyPrefix: c.KeyPrefix,
	}

	return pfxCmdable.BRPopLPush(source, destination, timeout).Result()
}

// BZPopMax executes the BZPopMax command
func (c *PrefixedCommands) BZPopMax(ctx context.Context, timeout time.Duration, keys ...string) (*redis.ZWithKey, error) {
	ctxCmdable := cmdableWithContext(ctx, c.Redis)

	pfxCmdable := prefixerCmdable{
		cmdable:   ctxCmdable,
		keyPrefix: c.KeyPrefix,
	}

	return pfxCmdable.BZPopMax(timeout, keys...).Result()
}

// BZPopMin executes the BZPopMin command
func (c *PrefixedCommands) BZPopMin(ctx context.Context, timeout time.Duration, keys ...string) (*redis.ZWithKey, error) {
	ctxCmdable := cmdableWithContext(ctx, c.Redis)

	pfxCmdable := prefixerCmdable{
		cmdable:   ctxCmdable,
		keyPrefix: c.KeyPrefix,
	}

	return pfxCmdable.BZPopMin(timeout, keys...).Result()
}

// BgRewriteAOF executes the BgRewriteAOF command
func (c *PrefixedCommands) BgRewriteAOF(ctx context.Context) (string, error) {
	ctxCmdable := cmdableWithContext(ctx, c.Redis)

	pfxCmdable := prefixerCmdable{
		cmdable:   ctxCmdable,
		keyPrefix: c.KeyPrefix,
	}

	return pfxCmdable.BgRewriteAOF().Result()
}

// BgSave executes the BgSave command
func (c *PrefixedCommands) BgSave(ctx context.Context) (string, error) {
	ctxCmdable := cmdableWithContext(ctx, c.Redis)

	pfxCmdable := prefixerCmdable{
		cmdable:   ctxCmdable,
		keyPrefix: c.KeyPrefix,
	}

	return pfxCmdable.BgSave().Result()
}

// BitCount executes the BitCount command
func (c *PrefixedCommands) BitCount(ctx context.Context, key string, bitCount *redis.BitCount) (int64, error) {
	ctxCmdable := cmdableWithContext(ctx, c.Redis)

	pfxCmdable := prefixerCmdable{
		cmdable:   ctxCmdable,
		keyPrefix: c.KeyPrefix,
	}

	return pfxCmdable.BitCount(key, bitCount).Result()
}

// BitField executes the BitField command
func (c *PrefixedCommands) BitField(ctx context.Context, key string, args ...interface{}) ([]int64, error) {
	ctxCmdable := cmdableWithContext(ctx, c.Redis)

	pfxCmdable := prefixerCmdable{
		cmdable:   ctxCmdable,
		keyPrefix: c.KeyPrefix,
	}

	return pfxCmdable.BitField(key, args...).Result()
}

// BitOpAnd executes the BitOpAnd command
func (c *PrefixedCommands) BitOpAnd(ctx context.Context, destKey string, keys ...string) (int64, error) {
	ctxCmdable := cmdableWithContext(ctx, c.Redis)

	pfxCmdable := prefixerCmdable{
		cmdable:   ctxCmdable,
		keyPrefix: c.KeyPrefix,
	}

	return pfxCmdable.BitOpAnd(destKey, keys...).Result()
}

// BitOpNot executes the BitOpNot command
func (c *PrefixedCommands) BitOpNot(ctx context.Context, destKey string, key string) (int64, error) {
	ctxCmdable := cmdableWithContext(ctx, c.Redis)

	pfxCmdable := prefixerCmdable{
		cmdable:   ctxCmdable,
		keyPrefix: c.KeyPrefix,
	}

	return pfxCmdable.BitOpNot(destKey, key).Result()
}

// BitOpOr executes the BitOpOr command
func (c *PrefixedCommands) BitOpOr(ctx context.Context, destKey string, keys ...string) (int64, error) {
	ctxCmdable := cmdableWithContext(ctx, c.Redis)

	pfxCmdable := prefixerCmdable{
		cmdable:   ctxCmdable,
		keyPrefix: c.KeyPrefix,
	}

	return pfxCmdable.BitOpOr(destKey, keys...).Result()
}

// BitOpXor executes the BitOpXor command
func (c *PrefixedCommands) BitOpXor(ctx context.Context, destKey string, keys ...string) (int64, error) {
	ctxCmdable := cmdableWithContext(ctx, c.Redis)

	pfxCmdable := prefixerCmdable{
		cmdable:   ctxCmdable,
		keyPrefix: c.KeyPrefix,
	}

	return pfxCmdable.BitOpXor(destKey, keys...).Result()
}

// BitPos executes the BitPos command
func (c *PrefixedCommands) BitPos(ctx context.Context, key string, bit int64, pos ...int64) (int64, error) {
	ctxCmdable := cmdableWithContext(ctx, c.Redis)

	pfxCmdable := prefixerCmdable{
		cmdable:   ctxCmdable,
		keyPrefix: c.KeyPrefix,
	}

	return pfxCmdable.BitPos(key, bit, pos...).Result()
}

// ClientGetName executes the ClientGetName command
func (c *PrefixedCommands) ClientGetName(ctx context.Context) (string, error) {
	ctxCmdable := cmdableWithContext(ctx, c.Redis)

	pfxCmdable := prefixerCmdable{
		cmdable:   ctxCmdable,
		keyPrefix: c.KeyPrefix,
	}

	return pfxCmdable.ClientGetName().Result()
}

// ClientID executes the ClientID command
func (c *PrefixedCommands) ClientID(ctx context.Context) (int64, error) {
	ctxCmdable := cmdableWithContext(ctx, c.Redis)

	pfxCmdable := prefixerCmdable{
		cmdable:   ctxCmdable,
		keyPrefix: c.KeyPrefix,
	}

	return pfxCmdable.ClientID().Result()
}

// ClientKill executes the ClientKill command
func (c *PrefixedCommands) ClientKill(ctx context.Context, ipPort string) (string, error) {
	ctxCmdable := cmdableWithContext(ctx, c.Redis)

	pfxCmdable := prefixerCmdable{
		cmdable:   ctxCmdable,
		keyPrefix: c.KeyPrefix,
	}

	return pfxCmdable.ClientKill(ipPort).Result()
}

// ClientKillByFilter executes the ClientKillByFilter command
func (c *PrefixedCommands) ClientKillByFilter(ctx context.Context, keys ...string) (int64, error) {
	ctxCmdable := cmdableWithContext(ctx, c.Redis)

	pfxCmdable := prefixerCmdable{
		cmdable:   ctxCmdable,
		keyPrefix: c.KeyPrefix,
	}

	return pfxCmdable.ClientKillByFilter(keys...).Result()
}

// ClientList executes the ClientList command
func (c *PrefixedCommands) ClientList(ctx context.Context) (string, error) {
	ctxCmdable := cmdableWithContext(ctx, c.Redis)

	pfxCmdable := prefixerCmdable{
		cmdable:   ctxCmdable,
		keyPrefix: c.KeyPrefix,
	}

	return pfxCmdable.ClientList().Result()
}

// ClientPause executes the ClientPause command
func (c *PrefixedCommands) ClientPause(ctx context.Context, dur time.Duration) (bool, error) {
	ctxCmdable := cmdableWithContext(ctx, c.Redis)

	pfxCmdable := prefixerCmdable{
		cmdable:   ctxCmdable,
		keyPrefix: c.KeyPrefix,
	}

	return pfxCmdable.ClientPause(dur).Result()
}

// ClusterAddSlots executes the ClusterAddSlots command
func (c *PrefixedCommands) ClusterAddSlots(ctx context.Context, slots ...int) (string, error) {
	ctxCmdable := cmdableWithContext(ctx, c.Redis)

	pfxCmdable := prefixerCmdable{
		cmdable:   ctxCmdable,
		keyPrefix: c.KeyPrefix,
	}

	return pfxCmdable.ClusterAddSlots(slots...).Result()
}

// ClusterAddSlotsRange executes the ClusterAddSlotsRange command
func (c *PrefixedCommands) ClusterAddSlotsRange(ctx context.Context, min int, max int) (string, error) {
	ctxCmdable := cmdableWithContext(ctx, c.Redis)

	pfxCmdable := prefixerCmdable{
		cmdable:   ctxCmdable,
		keyPrefix: c.KeyPrefix,
	}

	return pfxCmdable.ClusterAddSlotsRange(min, max).Result()
}

// ClusterCountFailureReports executes the ClusterCountFailureReports command
func (c *PrefixedCommands) ClusterCountFailureReports(ctx context.Context, nodeID string) (int64, error) {
	ctxCmdable := cmdableWithContext(ctx, c.Redis)

	pfxCmdable := prefixerCmdable{
		cmdable:   ctxCmdable,
		keyPrefix: c.KeyPrefix,
	}

	return pfxCmdable.ClusterCountFailureReports(nodeID).Result()
}

// ClusterCountKeysInSlot executes the ClusterCountKeysInSlot command
func (c *PrefixedCommands) ClusterCountKeysInSlot(ctx context.Context, slot int) (int64, error) {
	ctxCmdable := cmdableWithContext(ctx, c.Redis)

	pfxCmdable := prefixerCmdable{
		cmdable:   ctxCmdable,
		keyPrefix: c.KeyPrefix,
	}

	return pfxCmdable.ClusterCountKeysInSlot(slot).Result()
}

// ClusterDelSlots executes the ClusterDelSlots command
func (c *PrefixedCommands) ClusterDelSlots(ctx context.Context, slots ...int) (string, error) {
	ctxCmdable := cmdableWithContext(ctx, c.Redis)

	pfxCmdable := prefixerCmdable{
		cmdable:   ctxCmdable,
		keyPrefix: c.KeyPrefix,
	}

	return pfxCmdable.ClusterDelSlots(slots...).Result()
}

// ClusterDelSlotsRange executes the ClusterDelSlotsRange command
func (c *PrefixedCommands) ClusterDelSlotsRange(ctx context.Context, min int, max int) (string, error) {
	ctxCmdable := cmdableWithContext(ctx, c.Redis)

	pfxCmdable := prefixerCmdable{
		cmdable:   ctxCmdable,
		keyPrefix: c.KeyPrefix,
	}

	return pfxCmdable.ClusterDelSlotsRange(min, max).Result()
}

// ClusterFailover executes the ClusterFailover command
func (c *PrefixedCommands) ClusterFailover(ctx context.Context) (string, error) {
	ctxCmdable := cmdableWithContext(ctx, c.Redis)

	pfxCmdable := prefixerCmdable{
		cmdable:   ctxCmdable,
		keyPrefix: c.KeyPrefix,
	}

	return pfxCmdable.ClusterFailover().Result()
}

// ClusterForget executes the ClusterForget command
func (c *PrefixedCommands) ClusterForget(ctx context.Context, nodeID string) (string, error) {
	ctxCmdable := cmdableWithContext(ctx, c.Redis)

	pfxCmdable := prefixerCmdable{
		cmdable:   ctxCmdable,
		keyPrefix: c.KeyPrefix,
	}

	return pfxCmdable.ClusterForget(nodeID).Result()
}

// ClusterGetKeysInSlot executes the ClusterGetKeysInSlot command
func (c *PrefixedCommands) ClusterGetKeysInSlot(ctx context.Context, slot int, count int) ([]string, error) {
	ctxCmdable := cmdableWithContext(ctx, c.Redis)

	pfxCmdable := prefixerCmdable{
		cmdable:   ctxCmdable,
		keyPrefix: c.KeyPrefix,
	}

	return pfxCmdable.ClusterGetKeysInSlot(slot, count).Result()
}

// ClusterInfo executes the ClusterInfo command
func (c *PrefixedCommands) ClusterInfo(ctx context.Context) (string, error) {
	ctxCmdable := cmdableWithContext(ctx, c.Redis)

	pfxCmdable := prefixerCmdable{
		cmdable:   ctxCmdable,
		keyPrefix: c.KeyPrefix,
	}

	return pfxCmdable.ClusterInfo().Result()
}

// ClusterKeySlot executes the ClusterKeySlot command
func (c *PrefixedCommands) ClusterKeySlot(ctx context.Context, key string) (int64, error) {
	ctxCmdable := cmdableWithContext(ctx, c.Redis)

	pfxCmdable := prefixerCmdable{
		cmdable:   ctxCmdable,
		keyPrefix: c.KeyPrefix,
	}

	return pfxCmdable.ClusterKeySlot(key).Result()
}

// ClusterMeet executes the ClusterMeet command
func (c *PrefixedCommands) ClusterMeet(ctx context.Context, host string, port string) (string, error) {
	ctxCmdable := cmdableWithContext(ctx, c.Redis)

	pfxCmdable := prefixerCmdable{
		cmdable:   ctxCmdable,
		keyPrefix: c.KeyPrefix,
	}

	return pfxCmdable.ClusterMeet(host, port).Result()
}

// ClusterNodes executes the ClusterNodes command
func (c *PrefixedCommands) ClusterNodes(ctx context.Context) (string, error) {
	ctxCmdable := cmdableWithContext(ctx, c.Redis)

	pfxCmdable := prefixerCmdable{
		cmdable:   ctxCmdable,
		keyPrefix: c.KeyPrefix,
	}

	return pfxCmdable.ClusterNodes().Result()
}

// ClusterReplicate executes the ClusterReplicate command
func (c *PrefixedCommands) ClusterReplicate(ctx context.Context, nodeID string) (string, error) {
	ctxCmdable := cmdableWithContext(ctx, c.Redis)

	pfxCmdable := prefixerCmdable{
		cmdable:   ctxCmdable,
		keyPrefix: c.KeyPrefix,
	}

	return pfxCmdable.ClusterReplicate(nodeID).Result()
}

// ClusterResetHard executes the ClusterResetHard command
func (c *PrefixedCommands) ClusterResetHard(ctx context.Context) (string, error) {
	ctxCmdable := cmdableWithContext(ctx, c.Redis)

	pfxCmdable := prefixerCmdable{
		cmdable:   ctxCmdable,
		keyPrefix: c.KeyPrefix,
	}

	return pfxCmdable.ClusterResetHard().Result()
}

// ClusterResetSoft executes the ClusterResetSoft command
func (c *PrefixedCommands) ClusterResetSoft(ctx context.Context) (string, error) {
	ctxCmdable := cmdableWithContext(ctx, c.Redis)

	pfxCmdable := prefixerCmdable{
		cmdable:   ctxCmdable,
		keyPrefix: c.KeyPrefix,
	}

	return pfxCmdable.ClusterResetSoft().Result()
}

// ClusterSaveConfig executes the ClusterSaveConfig command
func (c *PrefixedCommands) ClusterSaveConfig(ctx context.Context) (string, error) {
	ctxCmdable := cmdableWithContext(ctx, c.Redis)

	pfxCmdable := prefixerCmdable{
		cmdable:   ctxCmdable,
		keyPrefix: c.KeyPrefix,
	}

	return pfxCmdable.ClusterSaveConfig().Result()
}

// ClusterSlaves executes the ClusterSlaves command
func (c *PrefixedCommands) ClusterSlaves(ctx context.Context, nodeID string) ([]string, error) {
	ctxCmdable := cmdableWithContext(ctx, c.Redis)

	pfxCmdable := prefixerCmdable{
		cmdable:   ctxCmdable,
		keyPrefix: c.KeyPrefix,
	}

	return pfxCmdable.ClusterSlaves(nodeID).Result()
}

// ClusterSlots executes the ClusterSlots command
func (c *PrefixedCommands) ClusterSlots(ctx context.Context) ([]redis.ClusterSlot, error) {
	ctxCmdable := cmdableWithContext(ctx, c.Redis)

	pfxCmdable := prefixerCmdable{
		cmdable:   ctxCmdable,
		keyPrefix: c.KeyPrefix,
	}

	return pfxCmdable.ClusterSlots().Result()
}

// Command executes the Command command
func (c *PrefixedCommands) Command(ctx context.Context) (map[string]*redis.CommandInfo, error) {
	ctxCmdable := cmdableWithContext(ctx, c.Redis)

	pfxCmdable := prefixerCmdable{
		cmdable:   ctxCmdable,
		keyPrefix: c.KeyPrefix,
	}

	return pfxCmdable.Command().Result()
}

// ConfigGet executes the ConfigGet command
func (c *PrefixedCommands) ConfigGet(ctx context.Context, parameter string) ([]interface{}, error) {
	ctxCmdable := cmdableWithContext(ctx, c.Redis)

	pfxCmdable := prefixerCmdable{
		cmdable:   ctxCmdable,
		keyPrefix: c.KeyPrefix,
	}

	return pfxCmdable.ConfigGet(parameter).Result()
}

// ConfigResetStat executes the ConfigResetStat command
func (c *PrefixedCommands) ConfigResetStat(ctx context.Context) (string, error) {
	ctxCmdable := cmdableWithContext(ctx, c.Redis)

	pfxCmdable := prefixerCmdable{
		cmdable:   ctxCmdable,
		keyPrefix: c.KeyPrefix,
	}

	return pfxCmdable.ConfigResetStat().Result()
}

// ConfigRewrite executes the ConfigRewrite command
func (c *PrefixedCommands) ConfigRewrite(ctx context.Context) (string, error) {
	ctxCmdable := cmdableWithContext(ctx, c.Redis)

	pfxCmdable := prefixerCmdable{
		cmdable:   ctxCmdable,
		keyPrefix: c.KeyPrefix,
	}

	return pfxCmdable.ConfigRewrite().Result()
}

// ConfigSet executes the ConfigSet command
func (c *PrefixedCommands) ConfigSet(ctx context.Context, parameter string, value string) (string, error) {
	ctxCmdable := cmdableWithContext(ctx, c.Redis)

	pfxCmdable := prefixerCmdable{
		cmdable:   ctxCmdable,
		keyPrefix: c.KeyPrefix,
	}

	return pfxCmdable.ConfigSet(parameter, value).Result()
}

// DBSize executes the DBSize command
func (c *PrefixedCommands) DBSize(ctx context.Context) (int64, error) {
	ctxCmdable := cmdableWithContext(ctx, c.Redis)

	pfxCmdable := prefixerCmdable{
		cmdable:   ctxCmdable,
		keyPrefix: c.KeyPrefix,
	}

	return pfxCmdable.DBSize().Result()
}

// DebugObject executes the DebugObject command
func (c *PrefixedCommands) DebugObject(ctx context.Context, key string) (string, error) {
	ctxCmdable := cmdableWithContext(ctx, c.Redis)

	pfxCmdable := prefixerCmdable{
		cmdable:   ctxCmdable,
		keyPrefix: c.KeyPrefix,
	}

	return pfxCmdable.DebugObject(key).Result()
}

// Decr executes the Decr command
func (c *PrefixedCommands) Decr(ctx context.Context, key string) (int64, error) {
	ctxCmdable := cmdableWithContext(ctx, c.Redis)

	pfxCmdable := prefixerCmdable{
		cmdable:   ctxCmdable,
		keyPrefix: c.KeyPrefix,
	}

	return pfxCmdable.Decr(key).Result()
}

// DecrBy executes the DecrBy command
func (c *PrefixedCommands) DecrBy(ctx context.Context, key string, decrement int64) (int64, error) {
	ctxCmdable := cmdableWithContext(ctx, c.Redis)

	pfxCmdable := prefixerCmdable{
		cmdable:   ctxCmdable,
		keyPrefix: c.KeyPrefix,
	}

	return pfxCmdable.DecrBy(key, decrement).Result()
}

// Del executes the Del command
func (c *PrefixedCommands) Del(ctx context.Context, keys ...string) (int64, error) {
	ctxCmdable := cmdableWithContext(ctx, c.Redis)

	pfxCmdable := prefixerCmdable{
		cmdable:   ctxCmdable,
		keyPrefix: c.KeyPrefix,
	}

	return pfxCmdable.Del(keys...).Result()
}

// Dump executes the Dump command
func (c *PrefixedCommands) Dump(ctx context.Context, key string) (string, error) {
	ctxCmdable := cmdableWithContext(ctx, c.Redis)

	pfxCmdable := prefixerCmdable{
		cmdable:   ctxCmdable,
		keyPrefix: c.KeyPrefix,
	}

	return pfxCmdable.Dump(key).Result()
}

// Echo executes the Echo command
func (c *PrefixedCommands) Echo(ctx context.Context, message interface{}) (string, error) {
	ctxCmdable := cmdableWithContext(ctx, c.Redis)

	pfxCmdable := prefixerCmdable{
		cmdable:   ctxCmdable,
		keyPrefix: c.KeyPrefix,
	}

	return pfxCmdable.Echo(message).Result()
}

// Eval executes the Eval command
func (c *PrefixedCommands) Eval(ctx context.Context, script string, keys []string, args ...interface{}) (interface{}, error) {
	ctxCmdable := cmdableWithContext(ctx, c.Redis)

	args = flattenArgs(args)

	pfxCmdable := prefixerCmdable{
		cmdable:   ctxCmdable,
		keyPrefix: c.KeyPrefix,
	}

	return pfxCmdable.Eval(script, keys, args...).Result()
}

// EvalSha executes the EvalSha command
func (c *PrefixedCommands) EvalSha(ctx context.Context, sha1 string, keys []string, args ...interface{}) (interface{}, error) {
	ctxCmdable := cmdableWithContext(ctx, c.Redis)

	args = flattenArgs(args)

	pfxCmdable := prefixerCmdable{
		cmdable:   ctxCmdable,
		keyPrefix: c.KeyPrefix,
	}

	return pfxCmdable.EvalSha(sha1, keys, args...).Result()
}

// Exists executes the Exists command
func (c *PrefixedCommands) Exists(ctx context.Context, keys ...string) (int64, error) {
	ctxCmdable := cmdableWithContext(ctx, c.Redis)

	pfxCmdable := prefixerCmdable{
		cmdable:   ctxCmdable,
		keyPrefix: c.KeyPrefix,
	}

	return pfxCmdable.Exists(keys...).Result()
}

// Expire executes the Expire command
func (c *PrefixedCommands) Expire(ctx context.Context, key string, expiration time.Duration) (bool, error) {
	ctxCmdable := cmdableWithContext(ctx, c.Redis)

	pfxCmdable := prefixerCmdable{
		cmdable:   ctxCmdable,
		keyPrefix: c.KeyPrefix,
	}

	return pfxCmdable.Expire(key, expiration).Result()
}

// ExpireAt executes the ExpireAt command
func (c *PrefixedCommands) ExpireAt(ctx context.Context, key string, tm time.Time) (bool, error) {
	ctxCmdable := cmdableWithContext(ctx, c.Redis)

	pfxCmdable := prefixerCmdable{
		cmdable:   ctxCmdable,
		keyPrefix: c.KeyPrefix,
	}

	return pfxCmdable.ExpireAt(key, tm).Result()
}

// FlushAll executes the FlushAll command
func (c *PrefixedCommands) FlushAll(ctx context.Context) (string, error) {
	ctxCmdable := cmdableWithContext(ctx, c.Redis)

	pfxCmdable := prefixerCmdable{
		cmdable:   ctxCmdable,
		keyPrefix: c.KeyPrefix,
	}

	return pfxCmdable.FlushAll().Result()
}

// FlushAllAsync executes the FlushAllAsync command
func (c *PrefixedCommands) FlushAllAsync(ctx context.Context) (string, error) {
	ctxCmdable := cmdableWithContext(ctx, c.Redis)

	pfxCmdable := prefixerCmdable{
		cmdable:   ctxCmdable,
		keyPrefix: c.KeyPrefix,
	}

	return pfxCmdable.FlushAllAsync().Result()
}

// FlushDB executes the FlushDB command
func (c *PrefixedCommands) FlushDB(ctx context.Context) (string, error) {
	ctxCmdable := cmdableWithContext(ctx, c.Redis)

	pfxCmdable := prefixerCmdable{
		cmdable:   ctxCmdable,
		keyPrefix: c.KeyPrefix,
	}

	return pfxCmdable.FlushDB().Result()
}

// FlushDBAsync executes the FlushDBAsync command
func (c *PrefixedCommands) FlushDBAsync(ctx context.Context) (string, error) {
	ctxCmdable := cmdableWithContext(ctx, c.Redis)

	pfxCmdable := prefixerCmdable{
		cmdable:   ctxCmdable,
		keyPrefix: c.KeyPrefix,
	}

	return pfxCmdable.FlushDBAsync().Result()
}

// GeoAdd executes the GeoAdd command
func (c *PrefixedCommands) GeoAdd(ctx context.Context, key string, geoLocation ...*redis.GeoLocation) (int64, error) {
	ctxCmdable := cmdableWithContext(ctx, c.Redis)

	pfxCmdable := prefixerCmdable{
		cmdable:   ctxCmdable,
		keyPrefix: c.KeyPrefix,
	}

	return pfxCmdable.GeoAdd(key, geoLocation...).Result()
}

// GeoDist executes the GeoDist command
func (c *PrefixedCommands) GeoDist(ctx context.Context, key string, member1 string, member2 string, unit string) (float64, error) {
	ctxCmdable := cmdableWithContext(ctx, c.Redis)

	pfxCmdable := prefixerCmdable{
		cmdable:   ctxCmdable,
		keyPrefix: c.KeyPrefix,
	}

	return pfxCmdable.GeoDist(key, member1, member2, unit).Result()
}

// GeoHash executes the GeoHash command
func (c *PrefixedCommands) GeoHash(ctx context.Context, key string, members ...string) ([]string, error) {
	ctxCmdable := cmdableWithContext(ctx, c.Redis)

	pfxCmdable := prefixerCmdable{
		cmdable:   ctxCmdable,
		keyPrefix: c.KeyPrefix,
	}

	return pfxCmdable.GeoHash(key, members...).Result()
}

// GeoPos executes the GeoPos command
func (c *PrefixedCommands) GeoPos(ctx context.Context, key string, members ...string) ([]*redis.GeoPos, error) {
	ctxCmdable := cmdableWithContext(ctx, c.Redis)

	pfxCmdable := prefixerCmdable{
		cmdable:   ctxCmdable,
		keyPrefix: c.KeyPrefix,
	}

	return pfxCmdable.GeoPos(key, members...).Result()
}

// GeoRadius executes the GeoRadius command
func (c *PrefixedCommands) GeoRadius(ctx context.Context, key string, longitude float64, latitude float64, query *redis.GeoRadiusQuery) ([]redis.GeoLocation, error) {
	ctxCmdable := cmdableWithContext(ctx, c.Redis)

	pfxCmdable := prefixerCmdable{
		cmdable:   ctxCmdable,
		keyPrefix: c.KeyPrefix,
	}

	return pfxCmdable.GeoRadius(key, longitude, latitude, query).Result()
}

// GeoRadiusByMember executes the GeoRadiusByMember command
func (c *PrefixedCommands) GeoRadiusByMember(ctx context.Context, key string, member string, query *redis.GeoRadiusQuery) ([]redis.GeoLocation, error) {
	ctxCmdable := cmdableWithContext(ctx, c.Redis)

	pfxCmdable := prefixerCmdable{
		cmdable:   ctxCmdable,
		keyPrefix: c.KeyPrefix,
	}

	return pfxCmdable.GeoRadiusByMember(key, member, query).Result()
}

// GeoRadiusByMemberStore executes the GeoRadiusByMemberStore command
func (c *PrefixedCommands) GeoRadiusByMemberStore(ctx context.Context, key string, member string, query *redis.GeoRadiusQuery) (int64, error) {
	ctxCmdable := cmdableWithContext(ctx, c.Redis)

	pfxCmdable := prefixerCmdable{
		cmdable:   ctxCmdable,
		keyPrefix: c.KeyPrefix,
	}

	return pfxCmdable.GeoRadiusByMemberStore(key, member, query).Result()
}

// GeoRadiusStore executes the GeoRadiusStore command
func (c *PrefixedCommands) GeoRadiusStore(ctx context.Context, key string, longitude float64, latitude float64, query *redis.GeoRadiusQuery) (int64, error) {
	ctxCmdable := cmdableWithContext(ctx, c.Redis)

	pfxCmdable := prefixerCmdable{
		cmdable:   ctxCmdable,
		keyPrefix: c.KeyPrefix,
	}

	return pfxCmdable.GeoRadiusStore(key, longitude, latitude, query).Result()
}

// Get executes the Get command
func (c *PrefixedCommands) Get(ctx context.Context, key string) (string, error) {
	ctxCmdable := cmdableWithContext(ctx, c.Redis)

	pfxCmdable := prefixerCmdable{
		cmdable:   ctxCmdable,
		keyPrefix: c.KeyPrefix,
	}

	return pfxCmdable.Get(key).Result()
}

// GetBit executes the GetBit command
func (c *PrefixedCommands) GetBit(ctx context.Context, key string, offset int64) (int64, error) {
	ctxCmdable := cmdableWithContext(ctx, c.Redis)

	pfxCmdable := prefixerCmdable{
		cmdable:   ctxCmdable,
		keyPrefix: c.KeyPrefix,
	}

	return pfxCmdable.GetBit(key, offset).Result()
}

// GetRange executes the GetRange command
func (c *PrefixedCommands) GetRange(ctx context.Context, key string, start int64, end int64) (string, error) {
	ctxCmdable := cmdableWithContext(ctx, c.Redis)

	pfxCmdable := prefixerCmdable{
		cmdable:   ctxCmdable,
		keyPrefix: c.KeyPrefix,
	}

	return pfxCmdable.GetRange(key, start, end).Result()
}

// GetSet executes the GetSet command
func (c *PrefixedCommands) GetSet(ctx context.Context, key string, value interface{}) (string, error) {
	ctxCmdable := cmdableWithContext(ctx, c.Redis)

	pfxCmdable := prefixerCmdable{
		cmdable:   ctxCmdable,
		keyPrefix: c.KeyPrefix,
	}

	return pfxCmdable.GetSet(key, value).Result()
}

// HDel executes the HDel command
func (c *PrefixedCommands) HDel(ctx context.Context, key string, fields ...string) (int64, error) {
	ctxCmdable := cmdableWithContext(ctx, c.Redis)

	pfxCmdable := prefixerCmdable{
		cmdable:   ctxCmdable,
		keyPrefix: c.KeyPrefix,
	}

	return pfxCmdable.HDel(key, fields...).Result()
}

// HExists executes the HExists command
func (c *PrefixedCommands) HExists(ctx context.Context, key string, field string) (bool, error) {
	ctxCmdable := cmdableWithContext(ctx, c.Redis)

	pfxCmdable := prefixerCmdable{
		cmdable:   ctxCmdable,
		keyPrefix: c.KeyPrefix,
	}

	return pfxCmdable.HExists(key, field).Result()
}

// HGet executes the HGet command
func (c *PrefixedCommands) HGet(ctx context.Context, key string, field string) (string, error) {
	ctxCmdable := cmdableWithContext(ctx, c.Redis)

	pfxCmdable := prefixerCmdable{
		cmdable:   ctxCmdable,
		keyPrefix: c.KeyPrefix,
	}

	return pfxCmdable.HGet(key, field).Result()
}

// HGetAll executes the HGetAll command
func (c *PrefixedCommands) HGetAll(ctx context.Context, key string) (map[string]string, error) {
	ctxCmdable := cmdableWithContext(ctx, c.Redis)

	pfxCmdable := prefixerCmdable{
		cmdable:   ctxCmdable,
		keyPrefix: c.KeyPrefix,
	}

	return pfxCmdable.HGetAll(key).Result()
}

// HIncrBy executes the HIncrBy command
func (c *PrefixedCommands) HIncrBy(ctx context.Context, key string, field string, incr int64) (int64, error) {
	ctxCmdable := cmdableWithContext(ctx, c.Redis)

	pfxCmdable := prefixerCmdable{
		cmdable:   ctxCmdable,
		keyPrefix: c.KeyPrefix,
	}

	return pfxCmdable.HIncrBy(key, field, incr).Result()
}

// HIncrByFloat executes the HIncrByFloat command
func (c *PrefixedCommands) HIncrByFloat(ctx context.Context, key string, field string, incr float64) (float64, error) {
	ctxCmdable := cmdableWithContext(ctx, c.Redis)

	pfxCmdable := prefixerCmdable{
		cmdable:   ctxCmdable,
		keyPrefix: c.KeyPrefix,
	}

	return pfxCmdable.HIncrByFloat(key, field, incr).Result()
}

// HKeys executes the HKeys command
func (c *PrefixedCommands) HKeys(ctx context.Context, key string) ([]string, error) {
	ctxCmdable := cmdableWithContext(ctx, c.Redis)

	pfxCmdable := prefixerCmdable{
		cmdable:   ctxCmdable,
		keyPrefix: c.KeyPrefix,
	}

	return pfxCmdable.HKeys(key).Result()
}

// HLen executes the HLen command
func (c *PrefixedCommands) HLen(ctx context.Context, key string) (int64, error) {
	ctxCmdable := cmdableWithContext(ctx, c.Redis)

	pfxCmdable := prefixerCmdable{
		cmdable:   ctxCmdable,
		keyPrefix: c.KeyPrefix,
	}

	return pfxCmdable.HLen(key).Result()
}

// HMGet executes the HMGet command
func (c *PrefixedCommands) HMGet(ctx context.Context, key string, fields ...string) ([]interface{}, error) {
	ctxCmdable := cmdableWithContext(ctx, c.Redis)

	pfxCmdable := prefixerCmdable{
		cmdable:   ctxCmdable,
		keyPrefix: c.KeyPrefix,
	}

	return pfxCmdable.HMGet(key, fields...).Result()
}

// HMSet executes the HMSet command
func (c *PrefixedCommands) HMSet(ctx context.Context, key string, fields map[string]interface{}) (string, error) {
	ctxCmdable := cmdableWithContext(ctx, c.Redis)

	pfxCmdable := prefixerCmdable{
		cmdable:   ctxCmdable,
		keyPrefix: c.KeyPrefix,
	}

	return pfxCmdable.HMSet(key, fields).Result()
}

// HScan executes the HScan command
func (c *PrefixedCommands) HScan(ctx context.Context, key string, cursor uint64, match string, count int64) ([]string, uint64, error) {
	ctxCmdable := cmdableWithContext(ctx, c.Redis)

	pfxCmdable := prefixerCmdable{
		cmdable:   ctxCmdable,
		keyPrefix: c.KeyPrefix,
	}

	return pfxCmdable.HScan(key, cursor, match, count).Result()
}

// HSet executes the HSet command
func (c *PrefixedCommands) HSet(ctx context.Context, key string, field string, value interface{}) (bool, error) {
	ctxCmdable := cmdableWithContext(ctx, c.Redis)

	pfxCmdable := prefixerCmdable{
		cmdable:   ctxCmdable,
		keyPrefix: c.KeyPrefix,
	}

	return pfxCmdable.HSet(key, field, value).Result()
}

// HSetNX executes the HSetNX command
func (c *PrefixedCommands) HSetNX(ctx context.Context, key string, field string, value interface{}) (bool, error) {
	ctxCmdable := cmdableWithContext(ctx, c.Redis)

	pfxCmdable := prefixerCmdable{
		cmdable:   ctxCmdable,
		keyPrefix: c.KeyPrefix,
	}

	return pfxCmdable.HSetNX(key, field, value).Result()
}

// HVals executes the HVals command
func (c *PrefixedCommands) HVals(ctx context.Context, key string) ([]string, error) {
	ctxCmdable := cmdableWithContext(ctx, c.Redis)

	pfxCmdable := prefixerCmdable{
		cmdable:   ctxCmdable,
		keyPrefix: c.KeyPrefix,
	}

	return pfxCmdable.HVals(key).Result()
}

// Incr executes the Incr command
func (c *PrefixedCommands) Incr(ctx context.Context, key string) (int64, error) {
	ctxCmdable := cmdableWithContext(ctx, c.Redis)

	pfxCmdable := prefixerCmdable{
		cmdable:   ctxCmdable,
		keyPrefix: c.KeyPrefix,
	}

	return pfxCmdable.Incr(key).Result()
}

// IncrBy executes the IncrBy command
func (c *PrefixedCommands) IncrBy(ctx context.Context, key string, value int64) (int64, error) {
	ctxCmdable := cmdableWithContext(ctx, c.Redis)

	pfxCmdable := prefixerCmdable{
		cmdable:   ctxCmdable,
		keyPrefix: c.KeyPrefix,
	}

	return pfxCmdable.IncrBy(key, value).Result()
}

// IncrByFloat executes the IncrByFloat command
func (c *PrefixedCommands) IncrByFloat(ctx context.Context, key string, value float64) (float64, error) {
	ctxCmdable := cmdableWithContext(ctx, c.Redis)

	pfxCmdable := prefixerCmdable{
		cmdable:   ctxCmdable,
		keyPrefix: c.KeyPrefix,
	}

	return pfxCmdable.IncrByFloat(key, value).Result()
}

// Info executes the Info command
func (c *PrefixedCommands) Info(ctx context.Context, section ...string) (string, error) {
	ctxCmdable := cmdableWithContext(ctx, c.Redis)

	pfxCmdable := prefixerCmdable{
		cmdable:   ctxCmdable,
		keyPrefix: c.KeyPrefix,
	}

	return pfxCmdable.Info(section...).Result()
}

// Keys executes the Keys command
func (c *PrefixedCommands) Keys(ctx context.Context, pattern string) ([]string, error) {
	ctxCmdable := cmdableWithContext(ctx, c.Redis)

	pfxCmdable := prefixerCmdable{
		cmdable:   ctxCmdable,
		keyPrefix: c.KeyPrefix,
	}

	return pfxCmdable.Keys(pattern).Result()
}

// LIndex executes the LIndex command
func (c *PrefixedCommands) LIndex(ctx context.Context, key string, index int64) (string, error) {
	ctxCmdable := cmdableWithContext(ctx, c.Redis)

	pfxCmdable := prefixerCmdable{
		cmdable:   ctxCmdable,
		keyPrefix: c.KeyPrefix,
	}

	return pfxCmdable.LIndex(key, index).Result()
}

// LInsert executes the LInsert command
func (c *PrefixedCommands) LInsert(ctx context.Context, key string, op string, pivot interface{}, value interface{}) (int64, error) {
	ctxCmdable := cmdableWithContext(ctx, c.Redis)

	pfxCmdable := prefixerCmdable{
		cmdable:   ctxCmdable,
		keyPrefix: c.KeyPrefix,
	}

	return pfxCmdable.LInsert(key, op, pivot, value).Result()
}

// LInsertAfter executes the LInsertAfter command
func (c *PrefixedCommands) LInsertAfter(ctx context.Context, key string, pivot interface{}, value interface{}) (int64, error) {
	ctxCmdable := cmdableWithContext(ctx, c.Redis)

	pfxCmdable := prefixerCmdable{
		cmdable:   ctxCmdable,
		keyPrefix: c.KeyPrefix,
	}

	return pfxCmdable.LInsertAfter(key, pivot, value).Result()
}

// LInsertBefore executes the LInsertBefore command
func (c *PrefixedCommands) LInsertBefore(ctx context.Context, key string, pivot interface{}, value interface{}) (int64, error) {
	ctxCmdable := cmdableWithContext(ctx, c.Redis)

	pfxCmdable := prefixerCmdable{
		cmdable:   ctxCmdable,
		keyPrefix: c.KeyPrefix,
	}

	return pfxCmdable.LInsertBefore(key, pivot, value).Result()
}

// LLen executes the LLen command
func (c *PrefixedCommands) LLen(ctx context.Context, key string) (int64, error) {
	ctxCmdable := cmdableWithContext(ctx, c.Redis)

	pfxCmdable := prefixerCmdable{
		cmdable:   ctxCmdable,
		keyPrefix: c.KeyPrefix,
	}

	return pfxCmdable.LLen(key).Result()
}

// LPop executes the LPop command
func (c *PrefixedCommands) LPop(ctx context.Context, key string) (string, error) {
	ctxCmdable := cmdableWithContext(ctx, c.Redis)

	pfxCmdable := prefixerCmdable{
		cmdable:   ctxCmdable,
		keyPrefix: c.KeyPrefix,
	}

	return pfxCmdable.LPop(key).Result()
}

// LPush executes the LPush command
func (c *PrefixedCommands) LPush(ctx context.Context, key string, values ...interface{}) (int64, error) {
	ctxCmdable := cmdableWithContext(ctx, c.Redis)

	pfxCmdable := prefixerCmdable{
		cmdable:   ctxCmdable,
		keyPrefix: c.KeyPrefix,
	}

	return pfxCmdable.LPush(key, values...).Result()
}

// LPushX executes the LPushX command
func (c *PrefixedCommands) LPushX(ctx context.Context, key string, values ...interface{}) (int64, error) {
	ctxCmdable := cmdableWithContext(ctx, c.Redis)

	pfxCmdable := prefixerCmdable{
		cmdable:   ctxCmdable,
		keyPrefix: c.KeyPrefix,
	}

	return pfxCmdable.LPushX(key, values...).Result()
}

// LRange executes the LRange command
func (c *PrefixedCommands) LRange(ctx context.Context, key string, start int64, stop int64) ([]string, error) {
	ctxCmdable := cmdableWithContext(ctx, c.Redis)

	pfxCmdable := prefixerCmdable{
		cmdable:   ctxCmdable,
		keyPrefix: c.KeyPrefix,
	}

	return pfxCmdable.LRange(key, start, stop).Result()
}

// LRem executes the LRem command
func (c *PrefixedCommands) LRem(ctx context.Context, key string, count int64, value interface{}) (int64, error) {
	ctxCmdable := cmdableWithContext(ctx, c.Redis)

	pfxCmdable := prefixerCmdable{
		cmdable:   ctxCmdable,
		keyPrefix: c.KeyPrefix,
	}

	return pfxCmdable.LRem(key, count, value).Result()
}

// LSet executes the LSet command
func (c *PrefixedCommands) LSet(ctx context.Context, key string, index int64, value interface{}) (string, error) {
	ctxCmdable := cmdableWithContext(ctx, c.Redis)

	pfxCmdable := prefixerCmdable{
		cmdable:   ctxCmdable,
		keyPrefix: c.KeyPrefix,
	}

	return pfxCmdable.LSet(key, index, value).Result()
}

// LTrim executes the LTrim command
func (c *PrefixedCommands) LTrim(ctx context.Context, key string, start int64, stop int64) (string, error) {
	ctxCmdable := cmdableWithContext(ctx, c.Redis)

	pfxCmdable := prefixerCmdable{
		cmdable:   ctxCmdable,
		keyPrefix: c.KeyPrefix,
	}

	return pfxCmdable.LTrim(key, start, stop).Result()
}

// LastSave executes the LastSave command
func (c *PrefixedCommands) LastSave(ctx context.Context) (int64, error) {
	ctxCmdable := cmdableWithContext(ctx, c.Redis)

	pfxCmdable := prefixerCmdable{
		cmdable:   ctxCmdable,
		keyPrefix: c.KeyPrefix,
	}

	return pfxCmdable.LastSave().Result()
}

// MGet executes the MGet command
func (c *PrefixedCommands) MGet(ctx context.Context, keys ...string) ([]interface{}, error) {
	ctxCmdable := cmdableWithContext(ctx, c.Redis)

	pfxCmdable := prefixerCmdable{
		cmdable:   ctxCmdable,
		keyPrefix: c.KeyPrefix,
	}

	return pfxCmdable.MGet(keys...).Result()
}

// MSet executes the MSet command
func (c *PrefixedCommands) MSet(ctx context.Context, pairs ...interface{}) (string, error) {
	ctxCmdable := cmdableWithContext(ctx, c.Redis)

	pfxCmdable := prefixerCmdable{
		cmdable:   ctxCmdable,
		keyPrefix: c.KeyPrefix,
	}

	return pfxCmdable.MSet(pairs...).Result()
}

// MSetNX executes the MSetNX command
func (c *PrefixedCommands) MSetNX(ctx context.Context, pairs ...interface{}) (bool, error) {
	ctxCmdable := cmdableWithContext(ctx, c.Redis)

	pfxCmdable := prefixerCmdable{
		cmdable:   ctxCmdable,
		keyPrefix: c.KeyPrefix,
	}

	return pfxCmdable.MSetNX(pairs...).Result()
}

// MemoryUsage executes the MemoryUsage command
func (c *PrefixedCommands) MemoryUsage(ctx context.Context, key string, samples ...int) (int64, error) {
	ctxCmdable := cmdableWithContext(ctx, c.Redis)

	pfxCmdable := prefixerCmdable{
		cmdable:   ctxCmdable,
		keyPrefix: c.KeyPrefix,
	}

	return pfxCmdable.MemoryUsage(key, samples...).Result()
}

// Migrate executes the Migrate command
func (c *PrefixedCommands) Migrate(ctx context.Context, host string, port string, key string, db int, timeout time.Duration) (string, error) {
	ctxCmdable := cmdableWithContext(ctx, c.Redis)

	pfxCmdable := prefixerCmdable{
		cmdable:   ctxCmdable,
		keyPrefix: c.KeyPrefix,
	}

	return pfxCmdable.Migrate(host, port, key, db, timeout).Result()
}

// Move executes the Move command
func (c *PrefixedCommands) Move(ctx context.Context, key string, db int) (bool, error) {
	ctxCmdable := cmdableWithContext(ctx, c.Redis)

	pfxCmdable := prefixerCmdable{
		cmdable:   ctxCmdable,
		keyPrefix: c.KeyPrefix,
	}

	return pfxCmdable.Move(key, db).Result()
}

// ObjectEncoding executes the ObjectEncoding command
func (c *PrefixedCommands) ObjectEncoding(ctx context.Context, key string) (string, error) {
	ctxCmdable := cmdableWithContext(ctx, c.Redis)

	pfxCmdable := prefixerCmdable{
		cmdable:   ctxCmdable,
		keyPrefix: c.KeyPrefix,
	}

	return pfxCmdable.ObjectEncoding(key).Result()
}

// ObjectIdleTime executes the ObjectIdleTime command
func (c *PrefixedCommands) ObjectIdleTime(ctx context.Context, key string) (time.Duration, error) {
	ctxCmdable := cmdableWithContext(ctx, c.Redis)

	pfxCmdable := prefixerCmdable{
		cmdable:   ctxCmdable,
		keyPrefix: c.KeyPrefix,
	}

	return pfxCmdable.ObjectIdleTime(key).Result()
}

// ObjectRefCount executes the ObjectRefCount command
func (c *PrefixedCommands) ObjectRefCount(ctx context.Context, key string) (int64, error) {
	ctxCmdable := cmdableWithContext(ctx, c.Redis)

	pfxCmdable := prefixerCmdable{
		cmdable:   ctxCmdable,
		keyPrefix: c.KeyPrefix,
	}

	return pfxCmdable.ObjectRefCount(key).Result()
}

// PExpire executes the PExpire command
func (c *PrefixedCommands) PExpire(ctx context.Context, key string, expiration time.Duration) (bool, error) {
	ctxCmdable := cmdableWithContext(ctx, c.Redis)

	pfxCmdable := prefixerCmdable{
		cmdable:   ctxCmdable,
		keyPrefix: c.KeyPrefix,
	}

	return pfxCmdable.PExpire(key, expiration).Result()
}

// PExpireAt executes the PExpireAt command
func (c *PrefixedCommands) PExpireAt(ctx context.Context, key string, tm time.Time) (bool, error) {
	ctxCmdable := cmdableWithContext(ctx, c.Redis)

	pfxCmdable := prefixerCmdable{
		cmdable:   ctxCmdable,
		keyPrefix: c.KeyPrefix,
	}

	return pfxCmdable.PExpireAt(key, tm).Result()
}

// PFAdd executes the PFAdd command
func (c *PrefixedCommands) PFAdd(ctx context.Context, key string, els ...interface{}) (int64, error) {
	ctxCmdable := cmdableWithContext(ctx, c.Redis)

	pfxCmdable := prefixerCmdable{
		cmdable:   ctxCmdable,
		keyPrefix: c.KeyPrefix,
	}

	return pfxCmdable.PFAdd(key, els...).Result()
}

// PFCount executes the PFCount command
func (c *PrefixedCommands) PFCount(ctx context.Context, keys ...string) (int64, error) {
	ctxCmdable := cmdableWithContext(ctx, c.Redis)

	pfxCmdable := prefixerCmdable{
		cmdable:   ctxCmdable,
		keyPrefix: c.KeyPrefix,
	}

	return pfxCmdable.PFCount(keys...).Result()
}

// PFMerge executes the PFMerge command
func (c *PrefixedCommands) PFMerge(ctx context.Context, dest string, keys ...string) (string, error) {
	ctxCmdable := cmdableWithContext(ctx, c.Redis)

	pfxCmdable := prefixerCmdable{
		cmdable:   ctxCmdable,
		keyPrefix: c.KeyPrefix,
	}

	return pfxCmdable.PFMerge(dest, keys...).Result()
}

// PTTL executes the PTTL command
func (c *PrefixedCommands) PTTL(ctx context.Context, key string) (time.Duration, error) {
	ctxCmdable := cmdableWithContext(ctx, c.Redis)

	pfxCmdable := prefixerCmdable{
		cmdable:   ctxCmdable,
		keyPrefix: c.KeyPrefix,
	}

	return pfxCmdable.PTTL(key).Result()
}

// Persist executes the Persist command
func (c *PrefixedCommands) Persist(ctx context.Context, key string) (bool, error) {
	ctxCmdable := cmdableWithContext(ctx, c.Redis)

	pfxCmdable := prefixerCmdable{
		cmdable:   ctxCmdable,
		keyPrefix: c.KeyPrefix,
	}

	return pfxCmdable.Persist(key).Result()
}

// Ping executes the Ping command
func (c *PrefixedCommands) Ping(ctx context.Context) (string, error) {
	ctxCmdable := cmdableWithContext(ctx, c.Redis)

	pfxCmdable := prefixerCmdable{
		cmdable:   ctxCmdable,
		keyPrefix: c.KeyPrefix,
	}

	return pfxCmdable.Ping().Result()
}

// PubSubChannels executes the PubSubChannels command
func (c *PrefixedCommands) PubSubChannels(ctx context.Context, pattern string) ([]string, error) {
	ctxCmdable := cmdableWithContext(ctx, c.Redis)

	pfxCmdable := prefixerCmdable{
		cmdable:   ctxCmdable,
		keyPrefix: c.KeyPrefix,
	}

	return pfxCmdable.PubSubChannels(pattern).Result()
}

// PubSubNumPat executes the PubSubNumPat command
func (c *PrefixedCommands) PubSubNumPat(ctx context.Context) (int64, error) {
	ctxCmdable := cmdableWithContext(ctx, c.Redis)

	pfxCmdable := prefixerCmdable{
		cmdable:   ctxCmdable,
		keyPrefix: c.KeyPrefix,
	}

	return pfxCmdable.PubSubNumPat().Result()
}

// PubSubNumSub executes the PubSubNumSub command
func (c *PrefixedCommands) PubSubNumSub(ctx context.Context, channels ...string) (map[string]int64, error) {
	ctxCmdable := cmdableWithContext(ctx, c.Redis)

	pfxCmdable := prefixerCmdable{
		cmdable:   ctxCmdable,
		keyPrefix: c.KeyPrefix,
	}

	return pfxCmdable.PubSubNumSub(channels...).Result()
}

// Publish executes the Publish command
func (c *PrefixedCommands) Publish(ctx context.Context, channel string, message interface{}) (int64, error) {
	ctxCmdable := cmdableWithContext(ctx, c.Redis)

	pfxCmdable := prefixerCmdable{
		cmdable:   ctxCmdable,
		keyPrefix: c.KeyPrefix,
	}

	return pfxCmdable.Publish(channel, message).Result()
}

// Quit executes the Quit command
func (c *PrefixedCommands) Quit(ctx context.Context) (string, error) {
	ctxCmdable := cmdableWithContext(ctx, c.Redis)

	pfxCmdable := prefixerCmdable{
		cmdable:   ctxCmdable,
		keyPrefix: c.KeyPrefix,
	}

	return pfxCmdable.Quit().Result()
}

// RPop executes the RPop command
func (c *PrefixedCommands) RPop(ctx context.Context, key string) (string, error) {
	ctxCmdable := cmdableWithContext(ctx, c.Redis)

	pfxCmdable := prefixerCmdable{
		cmdable:   ctxCmdable,
		keyPrefix: c.KeyPrefix,
	}

	return pfxCmdable.RPop(key).Result()
}

// RPopLPush executes the RPopLPush command
func (c *PrefixedCommands) RPopLPush(ctx context.Context, source string, destination string) (string, error) {
	ctxCmdable := cmdableWithContext(ctx, c.Redis)

	pfxCmdable := prefixerCmdable{
		cmdable:   ctxCmdable,
		keyPrefix: c.KeyPrefix,
	}

	return pfxCmdable.RPopLPush(source, destination).Result()
}

// RPush executes the RPush command
func (c *PrefixedCommands) RPush(ctx context.Context, key string, values ...interface{}) (int64, error) {
	ctxCmdable := cmdableWithContext(ctx, c.Redis)

	pfxCmdable := prefixerCmdable{
		cmdable:   ctxCmdable,
		keyPrefix: c.KeyPrefix,
	}

	return pfxCmdable.RPush(key, values...).Result()
}

// RPushX executes the RPushX command
func (c *PrefixedCommands) RPushX(ctx context.Context, key string, values ...interface{}) (int64, error) {
	ctxCmdable := cmdableWithContext(ctx, c.Redis)

	pfxCmdable := prefixerCmdable{
		cmdable:   ctxCmdable,
		keyPrefix: c.KeyPrefix,
	}

	return pfxCmdable.RPushX(key, values...).Result()
}

// RandomKey executes the RandomKey command
func (c *PrefixedCommands) RandomKey(ctx context.Context) (string, error) {
	ctxCmdable := cmdableWithContext(ctx, c.Redis)

	pfxCmdable := prefixerCmdable{
		cmdable:   ctxCmdable,
		keyPrefix: c.KeyPrefix,
	}

	return pfxCmdable.RandomKey().Result()
}

// ReadOnly executes the ReadOnly command
func (c *PrefixedCommands) ReadOnly(ctx context.Context) (string, error) {
	ctxCmdable := cmdableWithContext(ctx, c.Redis)

	pfxCmdable := prefixerCmdable{
		cmdable:   ctxCmdable,
		keyPrefix: c.KeyPrefix,
	}

	return pfxCmdable.ReadOnly().Result()
}

// ReadWrite executes the ReadWrite command
func (c *PrefixedCommands) ReadWrite(ctx context.Context) (string, error) {
	ctxCmdable := cmdableWithContext(ctx, c.Redis)

	pfxCmdable := prefixerCmdable{
		cmdable:   ctxCmdable,
		keyPrefix: c.KeyPrefix,
	}

	return pfxCmdable.ReadWrite().Result()
}

// Rename executes the Rename command
func (c *PrefixedCommands) Rename(ctx context.Context, key string, newkey string) (string, error) {
	ctxCmdable := cmdableWithContext(ctx, c.Redis)

	pfxCmdable := prefixerCmdable{
		cmdable:   ctxCmdable,
		keyPrefix: c.KeyPrefix,
	}

	return pfxCmdable.Rename(key, newkey).Result()
}

// RenameNX executes the RenameNX command
func (c *PrefixedCommands) RenameNX(ctx context.Context, key string, newkey string) (bool, error) {
	ctxCmdable := cmdableWithContext(ctx, c.Redis)

	pfxCmdable := prefixerCmdable{
		cmdable:   ctxCmdable,
		keyPrefix: c.KeyPrefix,
	}

	return pfxCmdable.RenameNX(key, newkey).Result()
}

// Restore executes the Restore command
func (c *PrefixedCommands) Restore(ctx context.Context, key string, ttl time.Duration, value string) (string, error) {
	ctxCmdable := cmdableWithContext(ctx, c.Redis)

	pfxCmdable := prefixerCmdable{
		cmdable:   ctxCmdable,
		keyPrefix: c.KeyPrefix,
	}

	return pfxCmdable.Restore(key, ttl, value).Result()
}

// RestoreReplace executes the RestoreReplace command
func (c *PrefixedCommands) RestoreReplace(ctx context.Context, key string, ttl time.Duration, value string) (string, error) {
	ctxCmdable := cmdableWithContext(ctx, c.Redis)

	pfxCmdable := prefixerCmdable{
		cmdable:   ctxCmdable,
		keyPrefix: c.KeyPrefix,
	}

	return pfxCmdable.RestoreReplace(key, ttl, value).Result()
}

// SAdd executes the SAdd command
func (c *PrefixedCommands) SAdd(ctx context.Context, key string, members ...interface{}) (int64, error) {
	ctxCmdable := cmdableWithContext(ctx, c.Redis)

	pfxCmdable := prefixerCmdable{
		cmdable:   ctxCmdable,
		keyPrefix: c.KeyPrefix,
	}

	return pfxCmdable.SAdd(key, members...).Result()
}

// SCard executes the SCard command
func (c *PrefixedCommands) SCard(ctx context.Context, key string) (int64, error) {
	ctxCmdable := cmdableWithContext(ctx, c.Redis)

	pfxCmdable := prefixerCmdable{
		cmdable:   ctxCmdable,
		keyPrefix: c.KeyPrefix,
	}

	return pfxCmdable.SCard(key).Result()
}

// SDiff executes the SDiff command
func (c *PrefixedCommands) SDiff(ctx context.Context, keys ...string) ([]string, error) {
	ctxCmdable := cmdableWithContext(ctx, c.Redis)

	pfxCmdable := prefixerCmdable{
		cmdable:   ctxCmdable,
		keyPrefix: c.KeyPrefix,
	}

	return pfxCmdable.SDiff(keys...).Result()
}

// SDiffStore executes the SDiffStore command
func (c *PrefixedCommands) SDiffStore(ctx context.Context, destination string, keys ...string) (int64, error) {
	ctxCmdable := cmdableWithContext(ctx, c.Redis)

	pfxCmdable := prefixerCmdable{
		cmdable:   ctxCmdable,
		keyPrefix: c.KeyPrefix,
	}

	return pfxCmdable.SDiffStore(destination, keys...).Result()
}

// SInter executes the SInter command
func (c *PrefixedCommands) SInter(ctx context.Context, keys ...string) ([]string, error) {
	ctxCmdable := cmdableWithContext(ctx, c.Redis)

	pfxCmdable := prefixerCmdable{
		cmdable:   ctxCmdable,
		keyPrefix: c.KeyPrefix,
	}

	return pfxCmdable.SInter(keys...).Result()
}

// SInterStore executes the SInterStore command
func (c *PrefixedCommands) SInterStore(ctx context.Context, destination string, keys ...string) (int64, error) {
	ctxCmdable := cmdableWithContext(ctx, c.Redis)

	pfxCmdable := prefixerCmdable{
		cmdable:   ctxCmdable,
		keyPrefix: c.KeyPrefix,
	}

	return pfxCmdable.SInterStore(destination, keys...).Result()
}

// SIsMember executes the SIsMember command
func (c *PrefixedCommands) SIsMember(ctx context.Context, key string, member interface{}) (bool, error) {
	ctxCmdable := cmdableWithContext(ctx, c.Redis)

	pfxCmdable := prefixerCmdable{
		cmdable:   ctxCmdable,
		keyPrefix: c.KeyPrefix,
	}

	return pfxCmdable.SIsMember(key, member).Result()
}

// SMembers executes the SMembers command
func (c *PrefixedCommands) SMembers(ctx context.Context, key string) ([]string, error) {
	ctxCmdable := cmdableWithContext(ctx, c.Redis)

	pfxCmdable := prefixerCmdable{
		cmdable:   ctxCmdable,
		keyPrefix: c.KeyPrefix,
	}

	return pfxCmdable.SMembers(key).Result()
}

// SMembersMap executes the SMembersMap command
func (c *PrefixedCommands) SMembersMap(ctx context.Context, key string) (map[string]struct{}, error) {
	ctxCmdable := cmdableWithContext(ctx, c.Redis)

	pfxCmdable := prefixerCmdable{
		cmdable:   ctxCmdable,
		keyPrefix: c.KeyPrefix,
	}

	return pfxCmdable.SMembersMap(key).Result()
}

// SMove executes the SMove command
func (c *PrefixedCommands) SMove(ctx context.Context, source string, destination string, member interface{}) (bool, error) {
	ctxCmdable := cmdableWithContext(ctx, c.Redis)

	pfxCmdable := prefixerCmdable{
		cmdable:   ctxCmdable,
		keyPrefix: c.KeyPrefix,
	}

	return pfxCmdable.SMove(source, destination, member).Result()
}

// SPop executes the SPop command
func (c *PrefixedCommands) SPop(ctx context.Context, key string) (string, error) {
	ctxCmdable := cmdableWithContext(ctx, c.Redis)

	pfxCmdable := prefixerCmdable{
		cmdable:   ctxCmdable,
		keyPrefix: c.KeyPrefix,
	}

	return pfxCmdable.SPop(key).Result()
}

// SPopN executes the SPopN command
func (c *PrefixedCommands) SPopN(ctx context.Context, key string, count int64) ([]string, error) {
	ctxCmdable := cmdableWithContext(ctx, c.Redis)

	pfxCmdable := prefixerCmdable{
		cmdable:   ctxCmdable,
		keyPrefix: c.KeyPrefix,
	}

	return pfxCmdable.SPopN(key, count).Result()
}

// SRandMember executes the SRandMember command
func (c *PrefixedCommands) SRandMember(ctx context.Context, key string) (string, error) {
	ctxCmdable := cmdableWithContext(ctx, c.Redis)

	pfxCmdable := prefixerCmdable{
		cmdable:   ctxCmdable,
		keyPrefix: c.KeyPrefix,
	}

	return pfxCmdable.SRandMember(key).Result()
}

// SRandMemberN executes the SRandMemberN command
func (c *PrefixedCommands) SRandMemberN(ctx context.Context, key string, count int64) ([]string, error) {
	ctxCmdable := cmdableWithContext(ctx, c.Redis)

	pfxCmdable := prefixerCmdable{
		cmdable:   ctxCmdable,
		keyPrefix: c.KeyPrefix,
	}

	return pfxCmdable.SRandMemberN(key, count).Result()
}

// SRem executes the SRem command
func (c *PrefixedCommands) SRem(ctx context.Context, key string, members ...interface{}) (int64, error) {
	ctxCmdable := cmdableWithContext(ctx, c.Redis)

	pfxCmdable := prefixerCmdable{
		cmdable:   ctxCmdable,
		keyPrefix: c.KeyPrefix,
	}

	return pfxCmdable.SRem(key, members...).Result()
}

// SScan executes the SScan command
func (c *PrefixedCommands) SScan(ctx context.Context, key string, cursor uint64, match string, count int64) ([]string, uint64, error) {
	ctxCmdable := cmdableWithContext(ctx, c.Redis)

	pfxCmdable := prefixerCmdable{
		cmdable:   ctxCmdable,
		keyPrefix: c.KeyPrefix,
	}

	return pfxCmdable.SScan(key, cursor, match, count).Result()
}

// SUnion executes the SUnion command
func (c *PrefixedCommands) SUnion(ctx context.Context, keys ...string) ([]string, error) {
	ctxCmdable := cmdableWithContext(ctx, c.Redis)

	pfxCmdable := prefixerCmdable{
		cmdable:   ctxCmdable,
		keyPrefix: c.KeyPrefix,
	}

	return pfxCmdable.SUnion(keys...).Result()
}

// SUnionStore executes the SUnionStore command
func (c *PrefixedCommands) SUnionStore(ctx context.Context, destination string, keys ...string) (int64, error) {
	ctxCmdable := cmdableWithContext(ctx, c.Redis)

	pfxCmdable := prefixerCmdable{
		cmdable:   ctxCmdable,
		keyPrefix: c.KeyPrefix,
	}

	return pfxCmdable.SUnionStore(destination, keys...).Result()
}

// Save executes the Save command
func (c *PrefixedCommands) Save(ctx context.Context) (string, error) {
	ctxCmdable := cmdableWithContext(ctx, c.Redis)

	pfxCmdable := prefixerCmdable{
		cmdable:   ctxCmdable,
		keyPrefix: c.KeyPrefix,
	}

	return pfxCmdable.Save().Result()
}

// Scan executes the Scan command
func (c *PrefixedCommands) Scan(ctx context.Context, cursor uint64, match string, count int64) ([]string, uint64, error) {
	ctxCmdable := cmdableWithContext(ctx, c.Redis)

	pfxCmdable := prefixerCmdable{
		cmdable:   ctxCmdable,
		keyPrefix: c.KeyPrefix,
	}

	return pfxCmdable.Scan(cursor, match, count).Result()
}

// ScriptExists executes the ScriptExists command
func (c *PrefixedCommands) ScriptExists(ctx context.Context, hashes ...string) ([]bool, error) {
	ctxCmdable := cmdableWithContext(ctx, c.Redis)

	pfxCmdable := prefixerCmdable{
		cmdable:   ctxCmdable,
		keyPrefix: c.KeyPrefix,
	}

	return pfxCmdable.ScriptExists(hashes...).Result()
}

// ScriptFlush executes the ScriptFlush command
func (c *PrefixedCommands) ScriptFlush(ctx context.Context) (string, error) {
	ctxCmdable := cmdableWithContext(ctx, c.Redis)

	pfxCmdable := prefixerCmdable{
		cmdable:   ctxCmdable,
		keyPrefix: c.KeyPrefix,
	}

	return pfxCmdable.ScriptFlush().Result()
}

// ScriptKill executes the ScriptKill command
func (c *PrefixedCommands) ScriptKill(ctx context.Context) (string, error) {
	ctxCmdable := cmdableWithContext(ctx, c.Redis)

	pfxCmdable := prefixerCmdable{
		cmdable:   ctxCmdable,
		keyPrefix: c.KeyPrefix,
	}

	return pfxCmdable.ScriptKill().Result()
}

// ScriptLoad executes the ScriptLoad command
func (c *PrefixedCommands) ScriptLoad(ctx context.Context, script string) (string, error) {
	ctxCmdable := cmdableWithContext(ctx, c.Redis)

	pfxCmdable := prefixerCmdable{
		cmdable:   ctxCmdable,
		keyPrefix: c.KeyPrefix,
	}

	return pfxCmdable.ScriptLoad(script).Result()
}

// Set executes the Set command
func (c *PrefixedCommands) Set(ctx context.Context, key string, value interface{}, expiration time.Duration) (string, error) {
	ctxCmdable := cmdableWithContext(ctx, c.Redis)

	pfxCmdable := prefixerCmdable{
		cmdable:   ctxCmdable,
		keyPrefix: c.KeyPrefix,
	}

	return pfxCmdable.Set(key, value, expiration).Result()
}

// SetBit executes the SetBit command
func (c *PrefixedCommands) SetBit(ctx context.Context, key string, offset int64, value int) (int64, error) {
	ctxCmdable := cmdableWithContext(ctx, c.Redis)

	pfxCmdable := prefixerCmdable{
		cmdable:   ctxCmdable,
		keyPrefix: c.KeyPrefix,
	}

	return pfxCmdable.SetBit(key, offset, value).Result()
}

// SetNX executes the SetNX command
func (c *PrefixedCommands) SetNX(ctx context.Context, key string, value interface{}, expiration time.Duration) (bool, error) {
	ctxCmdable := cmdableWithContext(ctx, c.Redis)

	pfxCmdable := prefixerCmdable{
		cmdable:   ctxCmdable,
		keyPrefix: c.KeyPrefix,
	}

	return pfxCmdable.SetNX(key, value, expiration).Result()
}

// SetRange executes the SetRange command
func (c *PrefixedCommands) SetRange(ctx context.Context, key string, offset int64, value string) (int64, error) {
	ctxCmdable := cmdableWithContext(ctx, c.Redis)

	pfxCmdable := prefixerCmdable{
		cmdable:   ctxCmdable,
		keyPrefix: c.KeyPrefix,
	}

	return pfxCmdable.SetRange(key, offset, value).Result()
}

// SetXX executes the SetXX command
func (c *PrefixedCommands) SetXX(ctx context.Context, key string, value interface{}, expiration time.Duration) (bool, error) {
	ctxCmdable := cmdableWithContext(ctx, c.Redis)

	pfxCmdable := prefixerCmdable{
		cmdable:   ctxCmdable,
		keyPrefix: c.KeyPrefix,
	}

	return pfxCmdable.SetXX(key, value, expiration).Result()
}

// Shutdown executes the Shutdown command
func (c *PrefixedCommands) Shutdown(ctx context.Context) (string, error) {
	ctxCmdable := cmdableWithContext(ctx, c.Redis)

	pfxCmdable := prefixerCmdable{
		cmdable:   ctxCmdable,
		keyPrefix: c.KeyPrefix,
	}

	return pfxCmdable.Shutdown().Result()
}

// ShutdownNoSave executes the ShutdownNoSave command
func (c *PrefixedCommands) ShutdownNoSave(ctx context.Context) (string, error) {
	ctxCmdable := cmdableWithContext(ctx, c.Redis)

	pfxCmdable := prefixerCmdable{
		cmdable:   ctxCmdable,
		keyPrefix: c.KeyPrefix,
	}

	return pfxCmdable.ShutdownNoSave().Result()
}

// ShutdownSave executes the ShutdownSave command
func (c *PrefixedCommands) ShutdownSave(ctx context.Context) (string, error) {
	ctxCmdable := cmdableWithContext(ctx, c.Redis)

	pfxCmdable := prefixerCmdable{
		cmdable:   ctxCmdable,
		keyPrefix: c.KeyPrefix,
	}

	return pfxCmdable.ShutdownSave().Result()
}

// SlaveOf executes the SlaveOf command
func (c *PrefixedCommands) SlaveOf(ctx context.Context, host string, port string) (string, error) {
	ctxCmdable := cmdableWithContext(ctx, c.Redis)

	pfxCmdable := prefixerCmdable{
		cmdable:   ctxCmdable,
		keyPrefix: c.KeyPrefix,
	}

	return pfxCmdable.SlaveOf(host, port).Result()
}

// Sort executes the Sort command
func (c *PrefixedCommands) Sort(ctx context.Context, key string, sort *redis.Sort) ([]string, error) {
	ctxCmdable := cmdableWithContext(ctx, c.Redis)

	pfxCmdable := prefixerCmdable{
		cmdable:   ctxCmdable,
		keyPrefix: c.KeyPrefix,
	}

	return pfxCmdable.Sort(key, sort).Result()
}

// SortInterfaces executes the SortInterfaces command
func (c *PrefixedCommands) SortInterfaces(ctx context.Context, key string, sort *redis.Sort) ([]interface{}, error) {
	ctxCmdable := cmdableWithContext(ctx, c.Redis)

	pfxCmdable := prefixerCmdable{
		cmdable:   ctxCmdable,
		keyPrefix: c.KeyPrefix,
	}

	return pfxCmdable.SortInterfaces(key, sort).Result()
}

// SortStore executes the SortStore command
func (c *PrefixedCommands) SortStore(ctx context.Context, key string, store string, sort *redis.Sort) (int64, error) {
	ctxCmdable := cmdableWithContext(ctx, c.Redis)

	pfxCmdable := prefixerCmdable{
		cmdable:   ctxCmdable,
		keyPrefix: c.KeyPrefix,
	}

	return pfxCmdable.SortStore(key, store, sort).Result()
}

// StrLen executes the StrLen command
func (c *PrefixedCommands) StrLen(ctx context.Context, key string) (int64, error) {
	ctxCmdable := cmdableWithContext(ctx, c.Redis)

	pfxCmdable := prefixerCmdable{
		cmdable:   ctxCmdable,
		keyPrefix: c.KeyPrefix,
	}

	return pfxCmdable.StrLen(key).Result()
}

// TTL executes the TTL command
func (c *PrefixedCommands) TTL(ctx context.Context, key string) (time.Duration, error) {
	ctxCmdable := cmdableWithContext(ctx, c.Redis)

	pfxCmdable := prefixerCmdable{
		cmdable:   ctxCmdable,
		keyPrefix: c.KeyPrefix,
	}

	return pfxCmdable.TTL(key).Result()
}

// Time executes the Time command
func (c *PrefixedCommands) Time(ctx context.Context) (time.Time, error) {
	ctxCmdable := cmdableWithContext(ctx, c.Redis)

	pfxCmdable := prefixerCmdable{
		cmdable:   ctxCmdable,
		keyPrefix: c.KeyPrefix,
	}

	return pfxCmdable.Time().Result()
}

// Touch executes the Touch command
func (c *PrefixedCommands) Touch(ctx context.Context, keys ...string) (int64, error) {
	ctxCmdable := cmdableWithContext(ctx, c.Redis)

	pfxCmdable := prefixerCmdable{
		cmdable:   ctxCmdable,
		keyPrefix: c.KeyPrefix,
	}

	return pfxCmdable.Touch(keys...).Result()
}

// Type executes the Type command
func (c *PrefixedCommands) Type(ctx context.Context, key string) (string, error) {
	ctxCmdable := cmdableWithContext(ctx, c.Redis)

	pfxCmdable := prefixerCmdable{
		cmdable:   ctxCmdable,
		keyPrefix: c.KeyPrefix,
	}

	return pfxCmdable.Type(key).Result()
}

// Unlink executes the Unlink command
func (c *PrefixedCommands) Unlink(ctx context.Context, keys ...string) (int64, error) {
	ctxCmdable := cmdableWithContext(ctx, c.Redis)

	pfxCmdable := prefixerCmdable{
		cmdable:   ctxCmdable,
		keyPrefix: c.KeyPrefix,
	}

	return pfxCmdable.Unlink(keys...).Result()
}

// XAck executes the XAck command
func (c *PrefixedCommands) XAck(ctx context.Context, stream string, group string, ids ...string) (int64, error) {
	ctxCmdable := cmdableWithContext(ctx, c.Redis)

	pfxCmdable := prefixerCmdable{
		cmdable:   ctxCmdable,
		keyPrefix: c.KeyPrefix,
	}

	return pfxCmdable.XAck(stream, group, ids...).Result()
}

// XAdd executes the XAdd command
func (c *PrefixedCommands) XAdd(ctx context.Context, a *redis.XAddArgs) (string, error) {
	ctxCmdable := cmdableWithContext(ctx, c.Redis)

	pfxCmdable := prefixerCmdable{
		cmdable:   ctxCmdable,
		keyPrefix: c.KeyPrefix,
	}

	return pfxCmdable.XAdd(a).Result()
}

// XClaim executes the XClaim command
func (c *PrefixedCommands) XClaim(ctx context.Context, a *redis.XClaimArgs) ([]redis.XMessage, error) {
	ctxCmdable := cmdableWithContext(ctx, c.Redis)

	pfxCmdable := prefixerCmdable{
		cmdable:   ctxCmdable,
		keyPrefix: c.KeyPrefix,
	}

	return pfxCmdable.XClaim(a).Result()
}

// XClaimJustID executes the XClaimJustID command
func (c *PrefixedCommands) XClaimJustID(ctx context.Context, a *redis.XClaimArgs) ([]string, error) {
	ctxCmdable := cmdableWithContext(ctx, c.Redis)

	pfxCmdable := prefixerCmdable{
		cmdable:   ctxCmdable,
		keyPrefix: c.KeyPrefix,
	}

	return pfxCmdable.XClaimJustID(a).Result()
}

// XDel executes the XDel command
func (c *PrefixedCommands) XDel(ctx context.Context, stream string, ids ...string) (int64, error) {
	ctxCmdable := cmdableWithContext(ctx, c.Redis)

	pfxCmdable := prefixerCmdable{
		cmdable:   ctxCmdable,
		keyPrefix: c.KeyPrefix,
	}

	return pfxCmdable.XDel(stream, ids...).Result()
}

// XGroupCreate executes the XGroupCreate command
func (c *PrefixedCommands) XGroupCreate(ctx context.Context, stream string, group string, start string) (string, error) {
	ctxCmdable := cmdableWithContext(ctx, c.Redis)

	pfxCmdable := prefixerCmdable{
		cmdable:   ctxCmdable,
		keyPrefix: c.KeyPrefix,
	}

	return pfxCmdable.XGroupCreate(stream, group, start).Result()
}

// XGroupCreateMkStream executes the XGroupCreateMkStream command
func (c *PrefixedCommands) XGroupCreateMkStream(ctx context.Context, stream string, group string, start string) (string, error) {
	ctxCmdable := cmdableWithContext(ctx, c.Redis)

	pfxCmdable := prefixerCmdable{
		cmdable:   ctxCmdable,
		keyPrefix: c.KeyPrefix,
	}

	return pfxCmdable.XGroupCreateMkStream(stream, group, start).Result()
}

// XGroupDelConsumer executes the XGroupDelConsumer command
func (c *PrefixedCommands) XGroupDelConsumer(ctx context.Context, stream string, group string, consumer string) (int64, error) {
	ctxCmdable := cmdableWithContext(ctx, c.Redis)

	pfxCmdable := prefixerCmdable{
		cmdable:   ctxCmdable,
		keyPrefix: c.KeyPrefix,
	}

	return pfxCmdable.XGroupDelConsumer(stream, group, consumer).Result()
}

// XGroupDestroy executes the XGroupDestroy command
func (c *PrefixedCommands) XGroupDestroy(ctx context.Context, stream string, group string) (int64, error) {
	ctxCmdable := cmdableWithContext(ctx, c.Redis)

	pfxCmdable := prefixerCmdable{
		cmdable:   ctxCmdable,
		keyPrefix: c.KeyPrefix,
	}

	return pfxCmdable.XGroupDestroy(stream, group).Result()
}

// XGroupSetID executes the XGroupSetID command
func (c *PrefixedCommands) XGroupSetID(ctx context.Context, stream string, group string, start string) (string, error) {
	ctxCmdable := cmdableWithContext(ctx, c.Redis)

	pfxCmdable := prefixerCmdable{
		cmdable:   ctxCmdable,
		keyPrefix: c.KeyPrefix,
	}

	return pfxCmdable.XGroupSetID(stream, group, start).Result()
}

// XLen executes the XLen command
func (c *PrefixedCommands) XLen(ctx context.Context, stream string) (int64, error) {
	ctxCmdable := cmdableWithContext(ctx, c.Redis)

	pfxCmdable := prefixerCmdable{
		cmdable:   ctxCmdable,
		keyPrefix: c.KeyPrefix,
	}

	return pfxCmdable.XLen(stream).Result()
}

// XPending executes the XPending command
func (c *PrefixedCommands) XPending(ctx context.Context, stream string, group string) (*redis.XPending, error) {
	ctxCmdable := cmdableWithContext(ctx, c.Redis)

	pfxCmdable := prefixerCmdable{
		cmdable:   ctxCmdable,
		keyPrefix: c.KeyPrefix,
	}

	return pfxCmdable.XPending(stream, group).Result()
}

// XPendingExt executes the XPendingExt command
func (c *PrefixedCommands) XPendingExt(ctx context.Context, a *redis.XPendingExtArgs) ([]redis.XPendingExt, error) {
	ctxCmdable := cmdableWithContext(ctx, c.Redis)

	pfxCmdable := prefixerCmdable{
		cmdable:   ctxCmdable,
		keyPrefix: c.KeyPrefix,
	}

	return pfxCmdable.XPendingExt(a).Result()
}

// XRange executes the XRange command
func (c *PrefixedCommands) XRange(ctx context.Context, stream string, start string, stop string) ([]redis.XMessage, error) {
	ctxCmdable := cmdableWithContext(ctx, c.Redis)

	pfxCmdable := prefixerCmdable{
		cmdable:   ctxCmdable,
		keyPrefix: c.KeyPrefix,
	}

	return pfxCmdable.XRange(stream, start, stop).Result()
}

// XRangeN executes the XRangeN command
func (c *PrefixedCommands) XRangeN(ctx context.Context, stream string, start string, stop string, count int64) ([]redis.XMessage, error) {
	ctxCmdable := cmdableWithContext(ctx, c.Redis)

	pfxCmdable := prefixerCmdable{
		cmdable:   ctxCmdable,
		keyPrefix: c.KeyPrefix,
	}

	return pfxCmdable.XRangeN(stream, start, stop, count).Result()
}

// XRead executes the XRead command
func (c *PrefixedCommands) XRead(ctx context.Context, a *redis.XReadArgs) ([]redis.XStream, error) {
	ctxCmdable := cmdableWithContext(ctx, c.Redis)

	pfxCmdable := prefixerCmdable{
		cmdable:   ctxCmdable,
		keyPrefix: c.KeyPrefix,
	}

	return pfxCmdable.XRead(a).Result()
}

// XReadGroup executes the XReadGroup command
func (c *PrefixedCommands) XReadGroup(ctx context.Context, a *redis.XReadGroupArgs) ([]redis.XStream, error) {
	ctxCmdable := cmdableWithContext(ctx, c.Redis)

	pfxCmdable := prefixerCmdable{
		cmdable:   ctxCmdable,
		keyPrefix: c.KeyPrefix,
	}

	return pfxCmdable.XReadGroup(a).Result()
}

// XReadStreams executes the XReadStreams command
func (c *PrefixedCommands) XReadStreams(ctx context.Context, streams ...string) ([]redis.XStream, error) {
	ctxCmdable := cmdableWithContext(ctx, c.Redis)

	pfxCmdable := prefixerCmdable{
		cmdable:   ctxCmdable,
		keyPrefix: c.KeyPrefix,
	}

	return pfxCmdable.XReadStreams(streams...).Result()
}

// XRevRange executes the XRevRange command
func (c *PrefixedCommands) XRevRange(ctx context.Context, stream string, start string, stop string) ([]redis.XMessage, error) {
	ctxCmdable := cmdableWithContext(ctx, c.Redis)

	pfxCmdable := prefixerCmdable{
		cmdable:   ctxCmdable,
		keyPrefix: c.KeyPrefix,
	}

	return pfxCmdable.XRevRange(stream, start, stop).Result()
}

// XRevRangeN executes the XRevRangeN command
func (c *PrefixedCommands) XRevRangeN(ctx context.Context, stream string, start string, stop string, count int64) ([]redis.XMessage, error) {
	ctxCmdable := cmdableWithContext(ctx, c.Redis)

	pfxCmdable := prefixerCmdable{
		cmdable:   ctxCmdable,
		keyPrefix: c.KeyPrefix,
	}

	return pfxCmdable.XRevRangeN(stream, start, stop, count).Result()
}

// XTrim executes the XTrim command
func (c *PrefixedCommands) XTrim(ctx context.Context, key string, maxLen int64) (int64, error) {
	ctxCmdable := cmdableWithContext(ctx, c.Redis)

	pfxCmdable := prefixerCmdable{
		cmdable:   ctxCmdable,
		keyPrefix: c.KeyPrefix,
	}

	return pfxCmdable.XTrim(key, maxLen).Result()
}

// XTrimApprox executes the XTrimApprox command
func (c *PrefixedCommands) XTrimApprox(ctx context.Context, key string, maxLen int64) (int64, error) {
	ctxCmdable := cmdableWithContext(ctx, c.Redis)

	pfxCmdable := prefixerCmdable{
		cmdable:   ctxCmdable,
		keyPrefix: c.KeyPrefix,
	}

	return pfxCmdable.XTrimApprox(key, maxLen).Result()
}

// ZAdd executes the ZAdd command
func (c *PrefixedCommands) ZAdd(ctx context.Context, key string, members ...*redis.Z) (int64, error) {
	ctxCmdable := cmdableWithContext(ctx, c.Redis)

	pfxCmdable := prefixerCmdable{
		cmdable:   ctxCmdable,
		keyPrefix: c.KeyPrefix,
	}

	return pfxCmdable.ZAdd(key, members...).Result()
}

// ZAddCh executes the ZAddCh command
func (c *PrefixedCommands) ZAddCh(ctx context.Context, key string, members ...*redis.Z) (int64, error) {
	ctxCmdable := cmdableWithContext(ctx, c.Redis)

	pfxCmdable := prefixerCmdable{
		cmdable:   ctxCmdable,
		keyPrefix: c.KeyPrefix,
	}

	return pfxCmdable.ZAddCh(key, members...).Result()
}

// ZAddNX executes the ZAddNX command
func (c *PrefixedCommands) ZAddNX(ctx context.Context, key string, members ...*redis.Z) (int64, error) {
	ctxCmdable := cmdableWithContext(ctx, c.Redis)

	pfxCmdable := prefixerCmdable{
		cmdable:   ctxCmdable,
		keyPrefix: c.KeyPrefix,
	}

	return pfxCmdable.ZAddNX(key, members...).Result()
}

// ZAddNXCh executes the ZAddNXCh command
func (c *PrefixedCommands) ZAddNXCh(ctx context.Context, key string, members ...*redis.Z) (int64, error) {
	ctxCmdable := cmdableWithContext(ctx, c.Redis)

	pfxCmdable := prefixerCmdable{
		cmdable:   ctxCmdable,
		keyPrefix: c.KeyPrefix,
	}

	return pfxCmdable.ZAddNXCh(key, members...).Result()
}

// ZAddXX executes the ZAddXX command
func (c *PrefixedCommands) ZAddXX(ctx context.Context, key string, members ...*redis.Z) (int64, error) {
	ctxCmdable := cmdableWithContext(ctx, c.Redis)

	pfxCmdable := prefixerCmdable{
		cmdable:   ctxCmdable,
		keyPrefix: c.KeyPrefix,
	}

	return pfxCmdable.ZAddXX(key, members...).Result()
}

// ZAddXXCh executes the ZAddXXCh command
func (c *PrefixedCommands) ZAddXXCh(ctx context.Context, key string, members ...*redis.Z) (int64, error) {
	ctxCmdable := cmdableWithContext(ctx, c.Redis)

	pfxCmdable := prefixerCmdable{
		cmdable:   ctxCmdable,
		keyPrefix: c.KeyPrefix,
	}

	return pfxCmdable.ZAddXXCh(key, members...).Result()
}

// ZCard executes the ZCard command
func (c *PrefixedCommands) ZCard(ctx context.Context, key string) (int64, error) {
	ctxCmdable := cmdableWithContext(ctx, c.Redis)

	pfxCmdable := prefixerCmdable{
		cmdable:   ctxCmdable,
		keyPrefix: c.KeyPrefix,
	}

	return pfxCmdable.ZCard(key).Result()
}

// ZCount executes the ZCount command
func (c *PrefixedCommands) ZCount(ctx context.Context, key string, min string, max string) (int64, error) {
	ctxCmdable := cmdableWithContext(ctx, c.Redis)

	pfxCmdable := prefixerCmdable{
		cmdable:   ctxCmdable,
		keyPrefix: c.KeyPrefix,
	}

	return pfxCmdable.ZCount(key, min, max).Result()
}

// ZIncr executes the ZIncr command
func (c *PrefixedCommands) ZIncr(ctx context.Context, key string, member *redis.Z) (float64, error) {
	ctxCmdable := cmdableWithContext(ctx, c.Redis)

	pfxCmdable := prefixerCmdable{
		cmdable:   ctxCmdable,
		keyPrefix: c.KeyPrefix,
	}

	return pfxCmdable.ZIncr(key, member).Result()
}

// ZIncrBy executes the ZIncrBy command
func (c *PrefixedCommands) ZIncrBy(ctx context.Context, key string, increment float64, member string) (float64, error) {
	ctxCmdable := cmdableWithContext(ctx, c.Redis)

	pfxCmdable := prefixerCmdable{
		cmdable:   ctxCmdable,
		keyPrefix: c.KeyPrefix,
	}

	return pfxCmdable.ZIncrBy(key, increment, member).Result()
}

// ZIncrNX executes the ZIncrNX command
func (c *PrefixedCommands) ZIncrNX(ctx context.Context, key string, member *redis.Z) (float64, error) {
	ctxCmdable := cmdableWithContext(ctx, c.Redis)

	pfxCmdable := prefixerCmdable{
		cmdable:   ctxCmdable,
		keyPrefix: c.KeyPrefix,
	}

	return pfxCmdable.ZIncrNX(key, member).Result()
}

// ZIncrXX executes the ZIncrXX command
func (c *PrefixedCommands) ZIncrXX(ctx context.Context, key string, member *redis.Z) (float64, error) {
	ctxCmdable := cmdableWithContext(ctx, c.Redis)

	pfxCmdable := prefixerCmdable{
		cmdable:   ctxCmdable,
		keyPrefix: c.KeyPrefix,
	}

	return pfxCmdable.ZIncrXX(key, member).Result()
}

// ZInterStore executes the ZInterStore command
func (c *PrefixedCommands) ZInterStore(ctx context.Context, destination string, store *redis.ZStore) (int64, error) {
	ctxCmdable := cmdableWithContext(ctx, c.Redis)

	pfxCmdable := prefixerCmdable{
		cmdable:   ctxCmdable,
		keyPrefix: c.KeyPrefix,
	}

	return pfxCmdable.ZInterStore(destination, store).Result()
}

// ZLexCount executes the ZLexCount command
func (c *PrefixedCommands) ZLexCount(ctx context.Context, key string, min string, max string) (int64, error) {
	ctxCmdable := cmdableWithContext(ctx, c.Redis)

	pfxCmdable := prefixerCmdable{
		cmdable:   ctxCmdable,
		keyPrefix: c.KeyPrefix,
	}

	return pfxCmdable.ZLexCount(key, min, max).Result()
}

// ZPopMax executes the ZPopMax command
func (c *PrefixedCommands) ZPopMax(ctx context.Context, key string, count ...int64) ([]redis.Z, error) {
	ctxCmdable := cmdableWithContext(ctx, c.Redis)

	pfxCmdable := prefixerCmdable{
		cmdable:   ctxCmdable,
		keyPrefix: c.KeyPrefix,
	}

	return pfxCmdable.ZPopMax(key, count...).Result()
}

// ZPopMin executes the ZPopMin command
func (c *PrefixedCommands) ZPopMin(ctx context.Context, key string, count ...int64) ([]redis.Z, error) {
	ctxCmdable := cmdableWithContext(ctx, c.Redis)

	pfxCmdable := prefixerCmdable{
		cmdable:   ctxCmdable,
		keyPrefix: c.KeyPrefix,
	}

	return pfxCmdable.ZPopMin(key, count...).Result()
}

// ZRange executes the ZRange command
func (c *PrefixedCommands) ZRange(ctx context.Context, key string, start int64, stop int64) ([]string, error) {
	ctxCmdable := cmdableWithContext(ctx, c.Redis)

	pfxCmdable := prefixerCmdable{
		cmdable:   ctxCmdable,
		keyPrefix: c.KeyPrefix,
	}

	return pfxCmdable.ZRange(key, start, stop).Result()
}

// ZRangeByLex executes the ZRangeByLex command
func (c *PrefixedCommands) ZRangeByLex(ctx context.Context, key string, opt *redis.ZRangeBy) ([]string, error) {
	ctxCmdable := cmdableWithContext(ctx, c.Redis)

	pfxCmdable := prefixerCmdable{
		cmdable:   ctxCmdable,
		keyPrefix: c.KeyPrefix,
	}

	return pfxCmdable.ZRangeByLex(key, opt).Result()
}

// ZRangeByScore executes the ZRangeByScore command
func (c *PrefixedCommands) ZRangeByScore(ctx context.Context, key string, opt *redis.ZRangeBy) ([]string, error) {
	ctxCmdable := cmdableWithContext(ctx, c.Redis)

	pfxCmdable := prefixerCmdable{
		cmdable:   ctxCmdable,
		keyPrefix: c.KeyPrefix,
	}

	return pfxCmdable.ZRangeByScore(key, opt).Result()
}

// ZRangeByScoreWithScores executes the ZRangeByScoreWithScores command
func (c *PrefixedCommands) ZRangeByScoreWithScores(ctx context.Context, key string, opt *redis.ZRangeBy) ([]redis.Z, error) {
	ctxCmdable := cmdableWithContext(ctx, c.Redis)

	pfxCmdable := prefixerCmdable{
		cmdable:   ctxCmdable,
		keyPrefix: c.KeyPrefix,
	}

	return pfxCmdable.ZRangeByScoreWithScores(key, opt).Result()
}

// ZRangeWithScores executes the ZRangeWithScores command
func (c *PrefixedCommands) ZRangeWithScores(ctx context.Context, key string, start int64, stop int64) ([]redis.Z, error) {
	ctxCmdable := cmdableWithContext(ctx, c.Redis)

	pfxCmdable := prefixerCmdable{
		cmdable:   ctxCmdable,
		keyPrefix: c.KeyPrefix,
	}

	return pfxCmdable.ZRangeWithScores(key, start, stop).Result()
}

// ZRank executes the ZRank command
func (c *PrefixedCommands) ZRank(ctx context.Context, key string, member string) (int64, error) {
	ctxCmdable := cmdableWithContext(ctx, c.Redis)

	pfxCmdable := prefixerCmdable{
		cmdable:   ctxCmdable,
		keyPrefix: c.KeyPrefix,
	}

	return pfxCmdable.ZRank(key, member).Result()
}

// ZRem executes the ZRem command
func (c *PrefixedCommands) ZRem(ctx context.Context, key string, members ...interface{}) (int64, error) {
	ctxCmdable := cmdableWithContext(ctx, c.Redis)

	pfxCmdable := prefixerCmdable{
		cmdable:   ctxCmdable,
		keyPrefix: c.KeyPrefix,
	}

	return pfxCmdable.ZRem(key, members...).Result()
}

// ZRemRangeByLex executes the ZRemRangeByLex command
func (c *PrefixedCommands) ZRemRangeByLex(ctx context.Context, key string, min string, max string) (int64, error) {
	ctxCmdable := cmdableWithContext(ctx, c.Redis)

	pfxCmdable := prefixerCmdable{
		cmdable:   ctxCmdable,
		keyPrefix: c.KeyPrefix,
	}

	return pfxCmdable.ZRemRangeByLex(key, min, max).Result()
}

// ZRemRangeByRank executes the ZRemRangeByRank command
func (c *PrefixedCommands) ZRemRangeByRank(ctx context.Context, key string, start int64, stop int64) (int64, error) {
	ctxCmdable := cmdableWithContext(ctx, c.Redis)

	pfxCmdable := prefixerCmdable{
		cmdable:   ctxCmdable,
		keyPrefix: c.KeyPrefix,
	}

	return pfxCmdable.ZRemRangeByRank(key, start, stop).Result()
}

// ZRemRangeByScore executes the ZRemRangeByScore command
func (c *PrefixedCommands) ZRemRangeByScore(ctx context.Context, key string, min string, max string) (int64, error) {
	ctxCmdable := cmdableWithContext(ctx, c.Redis)

	pfxCmdable := prefixerCmdable{
		cmdable:   ctxCmdable,
		keyPrefix: c.KeyPrefix,
	}

	return pfxCmdable.ZRemRangeByScore(key, min, max).Result()
}

// ZRevRange executes the ZRevRange command
func (c *PrefixedCommands) ZRevRange(ctx context.Context, key string, start int64, stop int64) ([]string, error) {
	ctxCmdable := cmdableWithContext(ctx, c.Redis)

	pfxCmdable := prefixerCmdable{
		cmdable:   ctxCmdable,
		keyPrefix: c.KeyPrefix,
	}

	return pfxCmdable.ZRevRange(key, start, stop).Result()
}

// ZRevRangeByLex executes the ZRevRangeByLex command
func (c *PrefixedCommands) ZRevRangeByLex(ctx context.Context, key string, opt *redis.ZRangeBy) ([]string, error) {
	ctxCmdable := cmdableWithContext(ctx, c.Redis)

	pfxCmdable := prefixerCmdable{
		cmdable:   ctxCmdable,
		keyPrefix: c.KeyPrefix,
	}

	return pfxCmdable.ZRevRangeByLex(key, opt).Result()
}

// ZRevRangeByScore executes the ZRevRangeByScore command
func (c *PrefixedCommands) ZRevRangeByScore(ctx context.Context, key string, opt *redis.ZRangeBy) ([]string, error) {
	ctxCmdable := cmdableWithContext(ctx, c.Redis)

	pfxCmdable := prefixerCmdable{
		cmdable:   ctxCmdable,
		keyPrefix: c.KeyPrefix,
	}

	return pfxCmdable.ZRevRangeByScore(key, opt).Result()
}

// ZRevRangeByScoreWithScores executes the ZRevRangeByScoreWithScores command
func (c *PrefixedCommands) ZRevRangeByScoreWithScores(ctx context.Context, key string, opt *redis.ZRangeBy) ([]redis.Z, error) {
	ctxCmdable := cmdableWithContext(ctx, c.Redis)

	pfxCmdable := prefixerCmdable{
		cmdable:   ctxCmdable,
		keyPrefix: c.KeyPrefix,
	}

	return pfxCmdable.ZRevRangeByScoreWithScores(key, opt).Result()
}

// ZRevRangeWithScores executes the ZRevRangeWithScores command
func (c *PrefixedCommands) ZRevRangeWithScores(ctx context.Context, key string, start int64, stop int64) ([]redis.Z, error) {
	ctxCmdable := cmdableWithContext(ctx, c.Redis)

	pfxCmdable := prefixerCmdable{
		cmdable:   ctxCmdable,
		keyPrefix: c.KeyPrefix,
	}

	return pfxCmdable.ZRevRangeWithScores(key, start, stop).Result()
}

// ZRevRank executes the ZRevRank command
func (c *PrefixedCommands) ZRevRank(ctx context.Context, key string, member string) (int64, error) {
	ctxCmdable := cmdableWithContext(ctx, c.Redis)

	pfxCmdable := prefixerCmdable{
		cmdable:   ctxCmdable,
		keyPrefix: c.KeyPrefix,
	}

	return pfxCmdable.ZRevRank(key, member).Result()
}

// ZScan executes the ZScan command
func (c *PrefixedCommands) ZScan(ctx context.Context, key string, cursor uint64, match string, count int64) ([]string, uint64, error) {
	ctxCmdable := cmdableWithContext(ctx, c.Redis)

	pfxCmdable := prefixerCmdable{
		cmdable:   ctxCmdable,
		keyPrefix: c.KeyPrefix,
	}

	return pfxCmdable.ZScan(key, cursor, match, count).Result()
}

// ZScore executes the ZScore command
func (c *PrefixedCommands) ZScore(ctx context.Context, key string, member string) (float64, error) {
	ctxCmdable := cmdableWithContext(ctx, c.Redis)

	pfxCmdable := prefixerCmdable{
		cmdable:   ctxCmdable,
		keyPrefix: c.KeyPrefix,
	}

	return pfxCmdable.ZScore(key, member).Result()
}

// ZUnionStore executes the ZUnionStore command
func (c *PrefixedCommands) ZUnionStore(ctx context.Context, dest string, store *redis.ZStore) (int64, error) {
	ctxCmdable := cmdableWithContext(ctx, c.Redis)

	pfxCmdable := prefixerCmdable{
		cmdable:   ctxCmdable,
		keyPrefix: c.KeyPrefix,
	}

	return pfxCmdable.ZUnionStore(dest, store).Result()
}

var _ Commands = (*PrefixedCommands)(nil)
