import * as Color from 'color';
import { Address, Listener, Position, Segment, Source } from 'extension-messaging-prototype';

// hack - use the segment number to determine rotation count due to lack of server
export class CycleListener implements Listener {
  private _color: Color = new Color('#6441A4');
  private pos?: Position;

  public get color() { return this._color.toString(); }
  public onCycle: () => void = () => { /**/ };

  public currentPosition(addr: Address): Position | undefined { return this.pos; }

  public onDataLost(addr: Address, src: Source, at: Segment): void {
    this.update(src, at.end);
  }

  public onDataReceived(addr: Address, src: Source, at: Segment, data: Uint8Array): void {
    this.update(src, at.end);
  }

  public onStreamClosed(addr: Address, err: Error): void { /* ... */ }

  public rotateColor(distance: number) {
    this._color = this._color.rotate(distance * 50);
    this.onCycle();
  }

  private update(src: Source, end: number) {
    const start = this.pos && this.pos.src.id === src.id ? this.pos.at : 0;
    const distance = end - start;
    if (distance > 0) {
      this.pos = { src, at: end };
      this.rotateColor(distance);
    }
  }
}
