import * as Color from 'color';
import { Address, Listener, Position, Segment, Source } from 'extension-messaging-prototype';

export class ColorListener implements Listener {
  private _color: Color = new Color('#6441A4');
  private pos?: Position;

  public get color() { return this._color.toString(); }
  public onSet: () => void = () => { /**/ };

  public currentPosition(addr: Address): Position | undefined { return this.pos; }
  public onDataLost(addr: Address, src: Source, at: Segment): void { /**/ }
  public onStreamClosed(addr: Address, err: Error): void { /**/ }

  public onDataReceived(addr: Address, src: Source, at: Segment, data: ArrayBuffer): void {
    const buffer = new Uint8Array(data);
    this.pos = {src, at:at.end};
    this._color = Color.rgb(buffer[0], buffer[1], buffer[2]);
    this.onSet();
  }
}
