import { AuthData, LogFunction, LogLevel } from 'extension-messaging-prototype';

// hack for local dev : extract query string into settings
export function debugInit(
  setLevel: (l: number) => void,
  setAuth: (auth: AuthData) => void,
  initialize: (channelId: string) => void,
  log: LogFunction,
) {
  const query = window.location.search.substring(1);
  let clientId = '';
  let channelId = '';
  let jwt = '';
  for (const segment of query.split('&')) {
    const parts = segment.split('=');
    if (parts.length === 2 && parts[0] === 'log') {
      switch (parseInt(parts[1], 10)) {
        case 0: setLevel(LogLevel.Debug); break;
        case 1: setLevel(LogLevel.Info); break;
        case 2: setLevel(LogLevel.Warning); break;
        case 3: setLevel(LogLevel.Error); break;
        default: break;
      }
    }
    if (parts.length === 2 && parts[0] === 'init') {
      channelId = parts[1];
    }
    if (parts.length === 2 && parts[0] === 'client-id') {
      clientId = parts[1];
    }
    if (parts.length === 2 && parts[0] === 'jwt') {
      jwt = parts[1];
    }
  }
  if (clientId !== '' || jwt !== '') {
    setAuth({ clientId, token: jwt });
  }
  if (channelId !== '') {
    initialize(channelId);
  }
}
