import os
from locust import HttpLocust, TaskSet, task

class GreeterTaskSet(TaskSet):
    @task
    def request_ticket(self):
        self.client.get('/v1/host?address=ext@1?e=*&c=*&a=*')

class MyLocust(HttpLocust):
    host = os.getenv('TARGET_URL', "http://localhost")
    task_set = GreeterTaskSet
    min_wait = 900
    max_wait = 1100
