# Metavision

Metavision is a computer vision service utilizing the [Stream Event Recognizer](https://git-aws.internal.justin.tv/devhub/strevr) (Strevr) library to provide metadata for supported categories by ingesting the top N streams for that category. It currently supports Apex Legends, with VALORANT support coming online shortly.

Metavision is built in Python and consists of two primary components: A scheduler, and a processor. Its infrastructure is defined in CDK using TypeScript, and deploys are also handled by CDK.

The scheduler is a Lambda function that runs on a minutely basis that gets the top N eligible streams from Liveline, and queues any streams not already being processed.

The processor is a Docker container running on ECS (EC2) that continuously processes eligible streams using the Strevr library and a category-specific strategy from a queue fed by the scheduler. It also periodically ensures a given stream is still eligible and ends processing if those checks fail.

Each strategy is deployed to its own infrastructure to make it easy to determine cost per strategy and to reduce blast radius. Currently, each strategy handles a single category, but that could change in the future.

## Prerequisites

### Tools

- [Python](https://www.python.org/) 3.7+
- [Node.js](https://nodejs.org) 10+
- [Docker](https://www.docker.com/products/docker-desktop)
- [GNU Make](https://www.gnu.org/software/make/)
- [Git LFS](https://git-lfs.github.com/)
- [AWS CLI](https://aws.amazon.com/cli/)
- [Visual Studio Code](https://code.visualstudio.com/) is recommended, but any Python & TypeScript friendly editor will do. Note that your editor should use the local virtual env for Python, and the locally installed version of TypeScript.

On Mac, most dependencies can be installed and managed using [Homebrew](https://brew.sh/).

### AWS Authentication

To be able to run the code, you need access to the Metavision AWS dev account. The tooling expects valid credentials to be available using the `metavision-dev` [AWS Profile](https://docs.aws.amazon.com/cli/latest/userguide/cli-configure-profiles.html).

Using [ADA](https://w.amazon.com/index.php/DevAccount/Docs) is an easy way to refresh credentials for an AWS account you have access to through [Isengard](https://isengard.amazon.com/).

### VPN

You need to be connected to the Twitch VPN for most things, including installing dependencies, deploying, and running the scheduler locally (due to the Liveline dependency).

## Preparing the environment

Before launching your editor, ensure that the environment is ready to go. This is as simple as running `make init`. If your environment ever gets into a weird state, you can rerun this command to reset it.

## Running Metavision locally

To run the processor, execute `make run-processor`.

To run the scheduler, execute `make run-scheduler`.

You don't normally need to run the scheduler to test the processor, the scheduler running in the dev account schedules 10 streams, while only one task runs, so there should always be an eligible stream to consume.

## Deploying Metavision

To deploy to the dev environment, run `make deploy-dev`. To deploy to production, `make deploy-prod`.

You can also deploy an individual strategy, for example: `make deploy-apex-dev` and `make deploy-apex-prod`.

## Monitoring

Each strategy has its own CloudWatch dashboards.

### Apex Legends

- [Production](https://tiny.amazon.com/15f14yoyc/IsenLink)
- [Development](https://tiny.amazon.com/13hfs9n3v/IsenLink)
