// tslint:disable-next-line: no-submodule-imports
import 'source-map-support/register';

import * as cdk from '@aws-cdk/core';
import { DEV_ENV, PROD_ENV, STRATEGIES, StrategyConfig } from './consts';
import { CommonStack } from './common-stack';
import { VpcStack } from './vpc-stack';
import { ProcessorStack } from './processor-stack';
import { SchedulerStack } from './scheduler-stack';
import { DataStack } from './data-stack';

enum CreateStacksTarget {
  Dev = 1,
  Prod,
  Disaster,
}

function createStacksForStrategy(
  scope: cdk.App,
  env: cdk.Environment,
  vpcStack: VpcStack,
  commonStack: CommonStack,
  prefix: string,
  strategy: StrategyConfig
) {
  const dataStack = new DataStack(scope, prefix + strategy.name + 'Data', {
    env,
    strategy,
  });

  new ProcessorStack(scope, prefix + strategy.name + 'Processor', {
    env,
    vpc: vpcStack.vpc,
    strategy,
    channelsTable: dataStack.channelsTable,
    channelsQueue: dataStack.channelsQueue,
    oauthTokenSecret: commonStack.oauthTokenSecret,
  });

  new SchedulerStack(scope, prefix + strategy.name + 'Scheduler', {
    env,
    vpc: vpcStack.vpc,
    strategy,
    channelsTable: dataStack.channelsTable,
    channelsQueue: dataStack.channelsQueue,
  });
}

function createStacks(scope: cdk.App, env: cdk.Environment, target: CreateStacksTarget) {
  const prefix = CreateStacksTarget[target];

  const vpcStack = new VpcStack(scope, prefix + 'Vpc', { env });
  const commonStack = new CommonStack(scope, prefix + 'Common', { env });

  for (const strategy of STRATEGIES) {
    createStacksForStrategy(scope, env, vpcStack, commonStack, prefix, strategy);
  }
}

const app = new cdk.App();
createStacks(app, DEV_ENV, CreateStacksTarget.Dev);
createStacks(app, PROD_ENV, CreateStacksTarget.Prod);
