import * as cdk from '@aws-cdk/core';
import * as secretsmanager from '@aws-cdk/aws-secretsmanager';

export class CommonStack extends cdk.Stack {
  public oauthTokenSecret: secretsmanager.Secret;

  constructor(scope: cdk.Construct, id: string, props: cdk.StackProps) {
    super(scope, id, props);

    // Secrets
    this.oauthTokenSecret = new secretsmanager.Secret(this, 'OAuthTokenSecret');
  }
}
