import { Environment } from '@aws-cdk/core';

export interface StrategyConfig {
  /**
   * Single word (title cased) name of the strategy. Used as stack prefix and Python package name.
   *
   * Cannot be changed once created without also recreating stacks and changing the Python package name.
   */
  name: string;
  /** Twitch Category ID to run the strategy on. */
  category_id: number;
  /** Minimum number of EC2 nodes to run. */
  minClusterCapacity: number;
  /** Maximum number of EC2 nodes to run */
  maxClusterCapacity: number;
  /** Number of tasks to run on the cluster. */
  taskCount: number;
  /** How much memory to allocate to each task. */
  taskMemory: number;
}

export const DEV_ACCOUNT_ID = '028744397248';
export const PROD_ACCOUNT_ID = '450103335622';
export const PRIMARY_REGION = 'us-west-2';
export const DISASTER_REGION = 'us-east-2';

export const DEV_ENV: Environment = {
  account: DEV_ACCOUNT_ID,
  region: PRIMARY_REGION,
};

export const PROD_ENV: Environment = {
  account: PROD_ACCOUNT_ID,
  region: PRIMARY_REGION,
};

export const DISASTER_ENV: Environment = {
  account: PROD_ACCOUNT_ID, // TODO: Replace with separate account
  region: DISASTER_REGION,
};

export const LIVELINE_HOST = 'https://main.production.liveline.twitch.a2z.com';

export const STRATEGIES: StrategyConfig[] = [
  {
    name: 'Apex',
    category_id: 511224,
    minClusterCapacity: 23,
    maxClusterCapacity: 30,
    taskCount: 1000,
    taskMemory: 160,
  },
];
