import * as cdk from '@aws-cdk/core';
import * as dynamodb from '@aws-cdk/aws-dynamodb';
import * as sqs from '@aws-cdk/aws-sqs';
import { StrategyConfig } from './consts';

interface DataStackProps extends cdk.StackProps {
  strategy: StrategyConfig;
}

export class DataStack extends cdk.Stack {
  public channelsQueue: sqs.Queue;
  public channelsTable: dynamodb.Table;

  constructor(scope: cdk.Construct, id: string, props: DataStackProps) {
    super(scope, id, props);

    // Channels queue
    // We queue eligible channels every minute, so we don't need to retain the messages beyond this window.
    this.channelsQueue = new sqs.Queue(this, 'ChannelsQueue', {
      retentionPeriod: cdk.Duration.seconds(60),
    });
    cdk.Tag.add(this.channelsQueue, 'sqs.Queue', props.strategy.name + 'Channels');

    // Channels table
    this.channelsTable = new dynamodb.Table(this, 'ChannelsTable', {
      partitionKey: { name: 'id', type: dynamodb.AttributeType.STRING },
      billingMode: dynamodb.BillingMode.PAY_PER_REQUEST,
    });
    cdk.Tag.add(this.channelsTable, 'dynamodb.Table', props.strategy.name + 'Channels');
  }
}
