import * as ec2 from '@aws-cdk/aws-ec2';
import * as cdk from '@aws-cdk/core';

export class VpcStack extends cdk.Stack {
  public readonly vpc: ec2.Vpc;

  constructor(scope: cdk.Construct, name: string, props: cdk.StackProps) {
    super(scope, name, props);

    this.vpc = new ec2.Vpc(this, 'Vpc', {
      maxAzs: 3,
    });

    // Twitch service VPC endpoints
    new ec2.InterfaceVpcEndpoint(this, 'LivelineVpcEndpoint', {
      vpc: this.vpc,
      service: {
        name: 'com.amazonaws.vpce.us-west-2.vpce-svc-09e5395f949c1bf56',
        port: 443,
      },
    });

    // AWS service VPC endpoints
    this.vpc.addDynamoDbEndpoint('DynamoDBEndpoint');
    this.vpc.addS3Endpoint('S3GatewayEndpoint');
    this.vpc.addInterfaceEndpoint('CloudWatchEndpoint', {
      service: ec2.InterfaceVpcEndpointAwsService.CLOUDWATCH,
    });
    this.vpc.addInterfaceEndpoint('SQSEndpoint', {
      service: ec2.InterfaceVpcEndpointAwsService.SQS,
    });
  }
}
