import json
import logging
import os

import requests

LIVELINE_HOST = os.environ["LIVELINE_HOST"]
LIVELINE_BASE = f"{LIVELINE_HOST}/twirp/liveline.Liveline"
LIVELINE_GET_STREAMS_BY_CHANNEL_IDS = f"{LIVELINE_BASE}/GetStreamsByChannelIDs"

logger = logging.getLogger(__name__)


def get_channel_info(channel: dict) -> dict:
    """ Get channel information from Liveline. """
    logger.debug(f"Getting information for channel \"{channel['name']}\".")

    for attempt in range(3):
        try:
            return requests.post(
                LIVELINE_GET_STREAMS_BY_CHANNEL_IDS,
                headers={"Content-Type": "application/json"},
                data=json.dumps({"channel_ids": [channel["id"]]}),
                timeout=10,
            ).json()
        except Exception:
            if attempt == 2:
                raise
