package dynamo

import (
	"context"
	"time"

	"github.com/aws/aws-sdk-go/service/dynamodb"
)

func (a *allowlist) IsAllowlisted(ctx context.Context, gameID, clientID string) (bool, error) {
	// A GetItem should not take more than a few milliseconds.
	// If the request is slow for whatever reason, timeout after 1 second to keep the caller's latency low.
	// For more information, see https://git.xarth.tv/devhub/twitch-e2-ingest/pull/26.
	ctx, cancel := context.WithTimeout(ctx, 1*time.Second)
	defer cancel()

	input := &dynamodb.GetItemInput{
		TableName: &a.tableName,
		Key: map[string]*dynamodb.AttributeValue{
			"GameID":   {S: &gameID},
			"ClientID": {S: &clientID},
		},
	}
	output, err := a.dynamo.GetItemWithContext(ctx, input)
	if err != nil {
		return false, err
	}

	return len(output.Item) > 0, nil
}
