package dynamo

import (
	"context"

	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/service/dynamodb"
	"github.com/aws/aws-sdk-go/service/dynamodb/dynamodbattribute"
)

const organizationIDIndex = "OrganizationIDIndex"

type ListEntriesByOrgRequest struct {
	OrganizationID string
}

func (a *allowlist) ListEntriesByOrg(ctx context.Context, r *ListEntriesByOrgRequest) ([]*AllowlistEntry, error) {
	const keyConditionExpression = "OrganizationID = :organizationID"
	input := &dynamodb.QueryInput{
		TableName:              aws.String(a.tableName),
		IndexName:              aws.String(organizationIDIndex),
		KeyConditionExpression: aws.String(keyConditionExpression),
		ExpressionAttributeValues: map[string]*dynamodb.AttributeValue{
			":organizationID": {S: aws.String(r.OrganizationID)},
		},
	}

	var (
		allEntries    []*AllowlistEntry
		paginationErr error
	)

	err := a.dynamo.QueryPagesWithContext(ctx, input, func(output *dynamodb.QueryOutput, lastPage bool) bool {
		var entries []*AllowlistEntry
		paginationErr = dynamodbattribute.UnmarshalListOfMaps(output.Items, &entries)
		if paginationErr != nil {
			return false
		}

		allEntries = append(allEntries, entries...)
		return true
	})
	if err != nil {
		return nil, err
	}

	if paginationErr != nil {
		return nil, paginationErr
	}

	return allEntries, nil
}
