package logger

import (
	"fmt"

	logging "code.justin.tv/amzn/TwitchLogging"
)

// LogLevel controls the verbosity of the logger
type LogLevel int

const (
	// Debug logs all messages
	Debug LogLevel = iota
	// Info logs all messages except debug messages
	Info
	// Warn logs only warnings and errors
	Warn
	// Error logs only error messages
	Error
)

//go:generate go run github.com/vektra/mockery/cmd/mockery -name Logger
type Logger interface {
	Debug(args ...interface{})
	Debugf(format string, args ...interface{})
	Debugln(args ...interface{})
	Error(args ...interface{})
	Errorf(format string, args ...interface{})
	Errorln(args ...interface{})
	Fatal(args ...interface{})
	Fatalf(format string, args ...interface{})
	Fatalln(args ...interface{})
	Info(args ...interface{})
	Infof(format string, args ...interface{})
	Infoln(args ...interface{})
	Panic(args ...interface{})
	Panicf(format string, args ...interface{})
	Panicln(args ...interface{})
	Print(args ...interface{})
	Printf(format string, args ...interface{})
	Println(args ...interface{})
	Warn(args ...interface{})
	Warnf(format string, args ...interface{})
	Warnln(args ...interface{})
}

// Logger wraps l into a S2S-compatible logger
func NewLogger(l logging.Logger, logLevel LogLevel) Logger {
	return logWrapper{
		Logger:   l,
		logLevel: logLevel,
	}
}

type logWrapper struct {
	logging.Logger
	logLevel LogLevel
}

func (lw logWrapper) log(level LogLevel, args ...interface{}) {
	if lw.logLevel > level {
		return
	}

	lw.Log("E2 Ingest message", args...)
}

func (lw logWrapper) logf(level LogLevel, f string, args ...interface{}) {
	if lw.logLevel > level {
		return
	}

	lw.Log("E2 Ingest message", "fmtted", fmt.Sprintf(f, args...))
}

func (lw logWrapper) Debug(args ...interface{})                 { lw.log(Debug, args...) }
func (lw logWrapper) Debugf(format string, args ...interface{}) { lw.logf(Debug, format, args...) }
func (lw logWrapper) Debugln(args ...interface{})               { lw.log(Debug, args...) }
func (lw logWrapper) Error(args ...interface{})                 { lw.log(Error, args...) }
func (lw logWrapper) Errorf(format string, args ...interface{}) { lw.logf(Error, format, args...) }
func (lw logWrapper) Errorln(args ...interface{})               { lw.log(Error, args...) }
func (lw logWrapper) Fatal(args ...interface{})                 { lw.log(Error, args...) }
func (lw logWrapper) Fatalf(format string, args ...interface{}) { lw.logf(Error, format, args...) }
func (lw logWrapper) Fatalln(args ...interface{})               { lw.log(Error, args...) }
func (lw logWrapper) Info(args ...interface{})                  { lw.log(Info, args...) }
func (lw logWrapper) Infof(format string, args ...interface{})  { lw.logf(Info, format, args...) }
func (lw logWrapper) Infoln(args ...interface{})                { lw.log(Info, args...) }
func (lw logWrapper) Panic(args ...interface{})                 { lw.log(Error, args...) }
func (lw logWrapper) Panicf(format string, args ...interface{}) { lw.logf(Error, format, args...) }
func (lw logWrapper) Panicln(args ...interface{})               { lw.log(Error, args...) }
func (lw logWrapper) Print(args ...interface{})                 { lw.log(Info, args...) }
func (lw logWrapper) Printf(format string, args ...interface{}) { lw.logf(Info, format, args...) }
func (lw logWrapper) Println(args ...interface{})               { lw.log(Info, args...) }
func (lw logWrapper) Warn(args ...interface{})                  { lw.log(Warn, args...) }
func (lw logWrapper) Warnf(format string, args ...interface{})  { lw.logf(Warn, format, args...) }
func (lw logWrapper) Warnln(args ...interface{})                { lw.log(Warn, args...) }
