@IF "%~1" == "" ECHO OFF
SETLOCAL

REM Ensure all SDKs are available to include.
FOR %%I IN ("base Base" "authorization Authorization" "enhanced-experiences EnhancedExperiences") DO (
	CALL :check %%~I
	IF ERRORLEVEL 1 EXIT /B
)

REM Validate the command line and set the environment variables.
IF NOT "%~2" == "" EXIT /B 2
SET ZIP=%SYSTEMDRIVE%\Program Files\7-Zip\7z.exe
IF NOT EXIST "%ZIP%" (
	ECHO "%ZIP%" not found
	EXIT /B 1
)
SET NAME=TwitchSDK
SET ROOT=%~dp0packages

REM Update the recorded versions of all SDKs.
SET T=%TEMP%\%RANDOM%
FOR %%I IN (base authorization enhanced-experiences) DO CALL :version %%I
FOR /F "tokens=2,3,4 delims=. " %%I IN ('TYPE "%~dp0version.txt" ^| find "twitch-sdk"') DO (
	SET RECORDED_MAJOR_VERSION=%%I
	SET RECORDED_MINOR_VERSION=%%J
	SET RECORDED_PATCH_VERSION=%%K
)
IF "%IS_MAJOR_VERSION_UPDATE%" == "TRUE" (
	SET /A RECORDED_MAJOR_VERSION=RECORDED_MAJOR_VERSION + 1
	SET RECORDED_MINOR_VERSION=0
	SET RECORDED_PATCH_VERSION=0
) ELSE IF "%IS_MINOR_VERSION_UPDATE%" == "TRUE" (
	SET /A RECORDED_MINOR_VERSION=RECORDED_MINOR_VERSION + 1
	SET RECORDED_PATCH_VERSION=0
) ELSE IF "%IS_PATCH_VERSION_UPDATE%" == "TRUE" (
	SET /A RECORDED_PATCH_VERSION=RECORDED_PATCH_VERSION + 1
)
ECHO twitch-sdk %RECORDED_MAJOR_VERSION%.%RECORDED_MINOR_VERSION%.%RECORDED_PATCH_VERSION%>> %T%.txt
MOVE /Y %T%.txt "%~dp0version.txt"
SET ZIP_FILE_PATH=%ROOT%\%NAME%-%RECORDED_MAJOR_VERSION%.%RECORDED_MINOR_VERSION%.%RECORDED_PATCH_VERSION%.zip

REM Copy the SDKs.
IF EXIST "%ROOT%" RD /Q /S "%ROOT%"
FOR %%I IN ("base Base" "authorization Authorization" "enhanced-experiences EnhancedExperiences") DO (
	CALL :copy %%~I
	IF ERRORLEVEL 1 EXIT /B
)

REM Copy the platform-agnostic files.
ECHO %RECORDED_MAJOR_VERSION%.%RECORDED_MINOR_VERSION%.%RECORDED_PATCH_VERSION%>> "%ROOT%\version.txt"
COPY "%ROOT%\BaseSDK\LICENSE" "%ROOT%"
IF ERRORLEVEL 1 EXIT /B
COPY "%~dp0release_notes.md" "%ROOT%"
IF ERRORLEVEL 1 EXIT /B
FOR %%I IN (Base Authorization EnhancedExperiences) DO DEL /F /Q "%ROOT%\%%ISDK\LICENSE"
IF ERRORLEVEL 1 EXIT /B

REM Create the Zip file.
IF EXIST "%ZIP_FILE_PATH%" DEL /F /Q "%ZIP_FILE_PATH%"
IF ERRORLEVEL 1 EXIT /B
FOR %%I IN (Base Authorization EnhancedExperiences) DO "%ZIP%" a -r "%ZIP_FILE_PATH%" "%ROOT%\%%ISDK"
"%ZIP%" a -r "%ZIP_FILE_PATH%" "%ROOT%\LICENSE" "%ROOT%\release_notes.md" "%ROOT%\version.txt"
IF ERRORLEVEL 1 EXIT /B

REM Create the version-independent Zip file.
COPY /Y "%ZIP_FILE_PATH%" "%ROOT%\%NAME%.zip"
IF ERRORLEVEL 1 EXIT /B

EXIT /B

:check
SET SDK=%~dp0..\%~1-sdk\packages\%~2SDK
IF NOT EXIST "%SDK%" (
	ECHO "%SDK%" not found
	EXIT /B 1
)
EXIT /B

:version
REM Get the version recorded for the SDK.
FOR /F "tokens=2,3,4 delims=. " %%I IN ('TYPE "%~dp0version.txt" ^| find "%~1-sdk"') DO (
	SET RECORDED_MAJOR_VERSION=%%I
	SET RECORDED_MINOR_VERSION=%%J
	SET RECORDED_PATCH_VERSION=%%K
)

REM Get the current version of the SDK.
FOR /F "delims=. tokens=1,2,3" %%I IN ('TYPE "%~dp0..\%~1-sdk\version.txt"') DO (
	SET CURRENT_MAJOR_VERSION=%%I
	SET CURRENT_MINOR_VERSION=%%J
	SET CURRENT_PATCH_VERSION=%%K
)

REM Determine which segment, if any, was updated.
IF %CURRENT_MAJOR_VERSION% GTR %RECORDED_MAJOR_VERSION% (
	SET IS_MAJOR_VERSION_UPDATE=TRUE
) ELSE IF %CURRENT_MINOR_VERSION% GTR %RECORDED_MINOR_VERSION% (
	SET IS_MINOR_VERSION_UPDATE=TRUE
) ELSE IF %CURRENT_PATCH_VERSION% GTR %RECORDED_PATCH_VERSION% (
	SET IS_PATCH_VERSION_UPDATE=TRUE
)

REM Add the version to the temporary version file.
ECHO %~1-sdk %CURRENT_MAJOR_VERSION%.%CURRENT_MINOR_VERSION%.%CURRENT_PATCH_VERSION%>> %T%.txt
EXIT /B

:copy
XCOPY /I /S /Y "%~dp0..\%~1-sdk\packages\%~2SDK" "%ROOT%\%~2SDK"
EXIT /B
