# Twitch SDK

This is the Twitch SDK in .NET, C++, Python, and TypeScript.  The .NET version
targets all .NET environments, including Unity.  The C++ version targets Windows
Desktop, PlayStation 4, and Xbox One.  The Python version targets all Python
environments.  The TypeScript version targets Electron and Node environments.
The Twitch SDK consists of the
[Authentication SDK](https://git.xarth.tv/devhub/authentication-sdk)
and the
[Enhanced Experiences SDK](https://git.xarth.tv/devhub/enhanced-experiences-sdk).
Both of those make use of the
[Base SDK](https://git.xarth.tv/devhub/base-sdk), also included in
this SDK.

In order to build and package the Twitch SDK, you must first clone, build, and
package the above three SDKs, starting with the Base SDK.  The other two may
follow in any order.  If you have already cloned them, run the
`BuildAndPackageAllModules.cmd` command script either in a command prompt or by
double-clicking it in Windows Explorer.  Then, run the `Package.cmd` command
script either in a command prompt or by double-clicking it in Windows Explorer.
There will be two Zip files in the `packages` directory, one versioned and the
other not.  Copy both files into the `gsdk.twitchcdn.net` S3 bucket using the
`twitch-gsdk-prod@amazon.com` account.

Running the `Package.cmd` command script will update the versions in the
`version.txt` file if any of the modules' versions were updated.
