default['jenkins']['master']['install_method'] = 'package'
default['jenkins']['executor']['protocol'] = 'http'

# default SSM Parameter names to use for value lookup
# allows Chef to authenticate against the Jenkins server
default['jenkins_master']['ssm_params']['username'] = '/chef/jenkins/username'
default['jenkins_master']['ssm_params']['password'] = '/chef/jenkins/password'

# default SSM Parameter names to use for value lookup
# provides Jenkins with OAuth App credentials for GHE
default['jenkins_master']['ssm_params']['github_client_id'] = '/chef/jenkins/github/clientId'
default['jenkins_master']['ssm_params']['github_client_secret'] = '/chef/jenkins/github/clientSecret'

default['jenkins_master']['domain_name'] = 'jenkins.xarth.tv'

# default awslogs configuration
default['awslogs']['logfiles']['/var/log/messages'] = {
  'log_stream_name' => '{instance_id}-{hostname}',
  'log_group_name' => '/var/log/messages',
  'file' => '/var/log/messages',
  'datetime_format' => '%b %d %H:%M:%S',
  'initial_position' => 'start_of_file'
}
default['awslogs']['logfiles']['/var/log/jenkins/jenkins.log'] = {
  'log_stream_name' => '{instance_id}-{hostname}',
  'log_group_name' => '/var/log/jenkins/jenkins.log',
  'file' => '/var/log/jenkins/jenkins.log',
  'datetime_format' => '%Y-%m-%d %H:%M:%S.%f%z',
  'initial_position' => 'start_of_file'
}
