yum_package 'awslogs'

template '/etc/awslogs/awslogs.conf' do
  source 'awslogs.conf.erb'
  owner 'root'
  group 'root'
  mode '0644'
  variables(
    logfiles: node['awslogs']['logfiles']
  )
  notifies :restart, 'service[awslogsd]'
end

service 'awslogsd' do
  supports [:start, :stop, :status, :restart]
  action [:enable, :start]
end
