dmg_package 'Sensu' do
  source "https://eol-repositories.sensuapp.org/osx/10.12/x86_64/sensu-#{node['sensu']['version']}.dmg"
  type 'pkg'
  notifies :create, 'ruby_block[sensu_service_trigger]', :immediately
end

# Disable API and Server processes (I love launchd ... )
['server', 'api'].each do |suffix|
  execute "stop_#{suffix}" do
    command "launchctl stop org.sensuapp.sensu-#{suffix}"
    only_if { ::File.exist?("/Library/LaunchDaemons/org.sensuapp.sensu-#{suffix}.plist") }
    ignore_failure true
  end

  execute "unload_#{suffix}" do
    command "launchctl unload /Library/LaunchDaemons/org.sensuapp.sensu-#{suffix}.plist"
    only_if { ::File.exist?("/Library/LaunchDaemons/org.sensuapp.sensu-#{suffix}.plist") }
    ignore_failure true
  end

  file "/Library/LaunchDaemons/org.sensuapp.sensu-#{suffix}.plist" do
    action :delete
    only_if { ::File.exist?("/Library/LaunchDaemons/org.sensuapp.sensu-#{suffix}.plist") }
  end
end
