
execute 'enable dnsmasq on boot' do
  command 'sudo /usr/local/bin/brew services start dnsmasq'
  user node['homebrew']['owner']
  environment(
    'HOME' => "/Users/#{node['homebrew']['owner']}",
    'USER' => node['homebrew']['owner']
  )
  action :nothing
end

homebrew_package 'dnsmasq' do
  notifies :run, 'execute[enable dnsmasq on boot]', :immediately
end

domain_list = [
  'gem.internal.justin.tv',
  'gems.internal.justin.tv',
  'packages.internal.justin.tv',
  'npm.internal.justin.tv',
  'docker.internal.justin.tv',
  'pypi.internal.justin.tv',
  'nuget.internal.justin.tv',
]

file '/usr/local/etc/dnsmasq.conf' do
  content <<-EOH
#{(domain_list.map { |d| "cname=#{d},macos-macos-1n5t4558dglcn-689323429.us-west-2.elb.amazonaws.com." }).join("\n")}
cname=git-aws.internal.justin.tv,Macos-Macos-ZWI2PYGM935W-c0206e03b04eb154.elb.us-west-2.amazonaws.com.
auth-server=internal.justin.tv,en0
interface-name=internal.justin.tv,en0
auth-zone=internal.justin.tv,127.0.0.0/24,en0
  EOH
  notifies :restart, 'launchd[homebrew.mxcl.dnsmasq]', :delayed
end

directory '/etc/resolver'

domain_list.each do |d|
  file "/etc/resolver/#{d}" do
    content "domain #{d}\nnameserver 127.0.0.1\n"
  end
end

file '/etc/resolver/git-aws.internal.justin.tv' do
  content "domain git-aws.internal.justin.tv\nnameserver 127.0.0.1\n"
end

launchd 'homebrew.mxcl.dnsmasq' do
  action :enable
end

directory '/etc/profile.d' do
  owner 'root'
  mode '0755'
end

file '/etc/profile.d/homebrew_path.sh' do
  content 'export PATH=/usr/local/bin:$PATH'
  mode '0755'
end
