-- find extensions minite watched that occured within the stream session
-- this means that extension minutes broadcast will not have data for channels with no extensions minutes watched
-- this means channels that had no extensions and channels that had no live viewers will not appear in this table
-- this table also assumes that streamers do not change extensions within streams
-- A stream is defined on a combination of broadcast_id and game
-- cleaning emw data by cross checking with active extensions


-- DROP TABLE IF EXISTS  dx_rollup.extension_stream_session;
--
-- CREATE TABLE dx_rollup.extension_stream_session (
--     date                    TIMESTAMP WITHOUT TIME ZONE sortkey
--     , broadcast_id            bigint
--     , game                     VARCHAR
--     , channel_id                BIGINT distkey
--     , channel                     VARCHAR
--     , broadcast_title             VARCHAR(500)
--     , broadcast_length_hrs        FLOAT
--     , broadcast_length_mins       BIGINT
--     , stream_start_time          TIMESTAMP
--     , stream_end_time            TIMESTAMP
--     , extension_id               VARCHAR
--     , extension_anchor           VARCHAR
--     , extension_slot              VARCHAR
--     , extension_name              VARCHAR
--     -- , country                     varchar
--
--
-- );

--THEN CREATE A the_temp_table BASED ON THAT SCHEMA
CREATE TEMP TABLE the_temp_table (LIKE dx_rollup.extension_stream_session);

PREPARE the_insert_function(int) AS
INSERT INTO the_temp_table (

with

dates as (
  SELECT DATEADD(day, $1, DATE_TRUNC('day', (SYSDATE - INTERVAL '7 hours'))) as the_date
),

-- get all data from extensions minute watched
mw as (
select distinct a.broadcast_id, a.the_time, a.channel_id, a.extension_id, a.day, a.game_flattened, a.extension_anchor, a.extension_slot
from cubes.extension_minute_watched as a
where a.day = (select the_date from dates)
-- where a.day = '2019-11-08'
-- and a.channel_id = 28029009
)

-- get the extension activations for channels over the last 90 days
, activations as (
select
date,
activation_time,
channel_id,
extension_id
from dx_sandbox.ninety_day_extension_activations
where date = (select the_date from dates)
-- where date = '2019-11-08'
-- and channel_id = 28029009
)

-- get only those emw with the active extensions

, clean_data as (
  select a.*
  from mw as a
  join activations as b
  on a.channel_id = b.channel_id
  and a.extension_id = b.extension_id
  and a.day = b.date
)

-- join clean emw data with creator stream session to get all the sessions with an active extension

, mb as (
select distinct
a.date,
a.broadcast_id,
a.game_flattened as game,
a.channel_id::bigint,
a.channel,
a.broadcast_title,
a.broadcast_length_hrs,
a.broadcast_length_mins,
a.stream_start_time,
a.stream_end_time,
b.extension_id,
b.extension_anchor,
b.extension_slot
from cubes.creator_stream_sessions as a
join clean_data as b
on a.broadcast_id = b.broadcast_id
and a.channel_id::bigint = b.channel_id
and a.game_flattened = b.game_flattened
and b.the_time >= a.stream_start_time
and b.the_time <= a.stream_end_time
where a.date = (select the_date from dates)
-- where a.date = '2019-11-08'
-- and a.channel_id = 28029009
)

-- Adding extension name

select a.*, b.extension_name
from mb as a
left join cubes.all_extensions_latest as b
on a.extension_id = b.extension_id
order by a.game, a.broadcast_length_mins
);

PREPARE the_delete_function(int) AS
DELETE FROM dx_rollup.extension_stream_session
WHERE date = DATEADD(day, $1, DATE_TRUNC('day', (SYSDATE - INTERVAL '7 hours')));

--

EXECUTE the_insert_function(-4);
EXECUTE the_delete_function(-4);
INSERT INTO dx_rollup.extension_stream_session  (SELECT * FROM the_temp_table);
DELETE FROM the_temp_table;

EXECUTE the_insert_function(-3);
EXECUTE the_delete_function(-3);
INSERT INTO dx_rollup.extension_stream_session  (SELECT * FROM the_temp_table);
DELETE FROM the_temp_table;

EXECUTE the_insert_function(-2);
EXECUTE the_delete_function(-2);
INSERT INTO dx_rollup.extension_stream_session  (SELECT * FROM the_temp_table);
DELETE FROM the_temp_table;

EXECUTE the_insert_function(-1);
EXECUTE the_delete_function(-1);
INSERT INTO dx_rollup.extension_stream_session  (SELECT * FROM the_temp_table);
DELETE FROM the_temp_table;


DEALLOCATE the_insert_function;
DEALLOCATE the_delete_function;
