
--DELETE THE DATA FOR THE DAY YOU ARE GOING TO BE ADDING IN
PREPARE the_delete_function (VARCHAR) AS
DELETE FROM dx_sandbox.channel_daily_status
WHERE dx_sandbox.channel_daily_status.the_date = DATEADD(day, -1, $1::TIMESTAMP)
;


CREATE TEMP TABLE the_temp_table (LIKE dx_sandbox.channel_daily_status);


PREPARE the_insert_function (VARCHAR) AS
INSERT INTO the_temp_table
(


  WITH
  the_parameter_input AS (
    SELECT $1::DATE AS the_day_we_run_script
    --SELECT DATE_TRUNC('day', (SYSDATE - INTERVAL '7 hours')) AS the_day_we_run_script
  )

  -- take channels that have streamed at least once from 2015-01-01 onward
  , eligible_channels AS (
    SELECT channel_id, MIN(date) AS min_ccu_date
    FROM tahoe.channel_concurrents
    WHERE "date" >= '2015-01-01'::DATE AND "date"<(SELECT the_day_we_run_script FROM the_parameter_input)
    GROUP BY 1
  )

  --returns a list of channel_id that we should run the data for
  --it will return the channel_id if they ever streamed since 2016-01-01
  , day_channel_matrix AS (
    SELECT *
      , DATEDIFF ( second, start_time_rolling_1, end_time_rolling_1 )::FLOAT/86400 AS num_days_rolling_1 --this is used just to verify that we are taking correct snapshot
      , DATEDIFF ( second, start_time_rolling_7, end_time_rolling_7 )::FLOAT/86400 AS num_days_rolling_7 --this is used just to verify that we are taking correct snapshot
      , DATEDIFF ( second, start_time_rolling_14, end_time_rolling_14 )::FLOAT/86400 AS num_days_rolling_14 --this is used just to verify that we are taking correct snapshot
      , DATEDIFF ( second, start_time_rolling_30, end_time_rolling_30 )::FLOAT/86400 AS num_days_rolling_30 --this is used just to verify that we are taking correct snapshot
      , DATEDIFF ( second, start_time_rolling_60, end_time_rolling_60 )::FLOAT/86400 AS num_days_rolling_60 --this is used just to verify that we are taking correct snapshot
      , DATEDIFF ( second, start_time_rolling_90, end_time_rolling_90 )::FLOAT/86400 AS num_days_rolling_90 --this is used just to verify that we are taking correct snapshot
      , DATEDIFF ( second, start_time_rolling_180, end_time_rolling_180 )::FLOAT/86400 AS num_days_rolling_180 --this is used just to verify that we are taking correct snapshot
      , DATEDIFF ( second, start_time_rolling_360, end_time_rolling_360 )::FLOAT/86400 AS num_days_rolling_360 --this is used just to verify that we are taking correct snapshot
    FROM (
      SELECT d."date" AS day
        , ec.channel_id
        , (d."date" - INTERVAL '0 days') AS start_time_rolling_1, (d."date" + INTERVAL '1 days' - INTERVAL '1 seconds') AS end_time_rolling_1
        , (d."date" - INTERVAL '6 days') AS start_time_rolling_7, (d."date" + INTERVAL '1 days' - INTERVAL '1 seconds') AS end_time_rolling_7
        , (d."date" - INTERVAL '13 days') AS start_time_rolling_14, (d."date" + INTERVAL '1 days' - INTERVAL '1 seconds') AS end_time_rolling_14
        , (d."date" - INTERVAL '29 days') AS start_time_rolling_30, (d."date" + INTERVAL '1 days' - INTERVAL '1 seconds') AS end_time_rolling_30
        , (d."date" - INTERVAL '59 days') AS start_time_rolling_60, (d."date" + INTERVAL '1 days' - INTERVAL '1 seconds') AS end_time_rolling_60
        , (d."date" - INTERVAL '89 days') AS start_time_rolling_90, (d."date" + INTERVAL '1 days' - INTERVAL '1 seconds') AS end_time_rolling_90
        , (d."date" - INTERVAL '179 days') AS start_time_rolling_180, (d."date" + INTERVAL '1 days' - INTERVAL '1 seconds') AS end_time_rolling_180
        , (d."date" - INTERVAL '359 days') AS start_time_rolling_360, (d."date" + INTERVAL '1 days' - INTERVAL '1 seconds') AS end_time_rolling_360
      FROM eligible_channels ec
      INNER JOIN metadata."date" d ON d."date" >= ec.min_ccu_date
      WHERE d."date" >= (SELECT the_day_we_run_script - INTERVAL '1 days' FROM the_parameter_input)
      AND   d."date" < (SELECT the_day_we_run_script FROM the_parameter_input)
    )
  )

  --get all the ccu logs for all eligible_channels during the rolling 360 time period and add flags for other time periods
  , ccu_log AS (
    SELECT *
      , CASE WHEN start_time_rolling_1<="time" AND "time"<=end_time_rolling_1 THEN TRUE ELSE FALSE END AS flag_is_rolling_1
      , CASE WHEN start_time_rolling_7<="time" AND "time"<=end_time_rolling_7 THEN TRUE ELSE FALSE END AS flag_is_rolling_7
      , CASE WHEN start_time_rolling_14<="time" AND "time"<=end_time_rolling_14 THEN TRUE ELSE FALSE END AS flag_is_rolling_14
      , CASE WHEN start_time_rolling_30<="time" AND "time"<=end_time_rolling_30 THEN TRUE ELSE FALSE END AS flag_is_rolling_30
      , CASE WHEN start_time_rolling_60<="time" AND "time"<=end_time_rolling_60 THEN TRUE ELSE FALSE END AS flag_is_rolling_60
      , CASE WHEN start_time_rolling_90<="time" AND "time"<=end_time_rolling_90 THEN TRUE ELSE FALSE END AS flag_is_rolling_90
      , CASE WHEN start_time_rolling_180<="time" AND "time"<=end_time_rolling_180 THEN TRUE ELSE FALSE END AS flag_is_rolling_180
      , CASE WHEN start_time_rolling_360<="time" AND "time"<=end_time_rolling_360 THEN TRUE ELSE FALSE END AS flag_is_rolling_360
    FROM (
      SELECT ccu."time", dcm.*, ccu.total
      FROM tahoe.channel_concurrents AS ccu
      RIGHT JOIN day_channel_matrix AS dcm
        ON ccu.channel_id = dcm.channel_id
        AND dcm.start_time_rolling_360 <= ccu.time AND ccu.time<=dcm.end_time_rolling_360
    )
  )

  , ccu_per_day_log AS (
    SELECT DATE_TRUNC('day', "time") AS ccu_log_date, day AS the_date, channel_id
    , flag_is_rolling_1, flag_is_rolling_7, flag_is_rolling_14, flag_is_rolling_30, flag_is_rolling_60, flag_is_rolling_90, flag_is_rolling_180, flag_is_rolling_360
    , MAX(CASE WHEN flag_is_rolling_1 THEN 1 ELSE 0 END) AS indicator_is_rolling_1, MAX(CASE WHEN flag_is_rolling_7 THEN 1 ELSE 0 END) AS indicator_is_rolling_7
    , MAX(CASE WHEN flag_is_rolling_14 THEN 1 ELSE 0 END) AS indicator_is_rolling_14, MAX(CASE WHEN flag_is_rolling_30 THEN 1 ELSE 0 END) AS indicator_is_rolling_30
    , MAX(CASE WHEN flag_is_rolling_60 THEN 1 ELSE 0 END) AS indicator_is_rolling_60, MAX(CASE WHEN flag_is_rolling_90 THEN 1 ELSE 0 END) AS indicator_is_rolling_90
    , MAX(CASE WHEN flag_is_rolling_180 THEN 1 ELSE 0 END) AS indicator_is_rolling_180, MAX(CASE WHEN flag_is_rolling_360 THEN 1 ELSE 0 END) AS indicator_is_rolling_360
    -- , MAX(1) AS indicator_stream_this_day, sum(1) as mb
    FROM ccu_log
    GROUP BY 1,2,3,4,5,6,7,8,9,10,11
  )
  --get the per the_date per channel_id aggregated metrics on how many days streamed the past X days
  , ccu_aggregated_1 AS (
    SELECT the_date, channel_id
      , SUM(indicator_is_rolling_1) AS total_days_streamed_rolling_1, SUM(indicator_is_rolling_1::FLOAT)/1 AS pct_days_streamed_rolling_1
      , SUM(indicator_is_rolling_7) AS total_days_streamed_rolling_7, SUM(indicator_is_rolling_7::FLOAT)/7 AS pct_days_streamed_rolling_7
      , SUM(indicator_is_rolling_14) AS total_days_streamed_rolling_14, SUM(indicator_is_rolling_14::FLOAT)/14 AS pct_days_streamed_rolling_14
      , SUM(indicator_is_rolling_30) AS total_days_streamed_rolling_30, SUM(indicator_is_rolling_30::FLOAT)/30 AS pct_days_streamed_rolling_30
      , SUM(indicator_is_rolling_60) AS total_days_streamed_rolling_60, SUM(indicator_is_rolling_60::FLOAT)/60 AS pct_days_streamed_rolling_60
      , SUM(indicator_is_rolling_90) AS total_days_streamed_rolling_90, SUM(indicator_is_rolling_90::FLOAT)/90 AS pct_days_streamed_rolling_90
      , SUM(indicator_is_rolling_180) AS total_days_streamed_rolling_180, SUM(indicator_is_rolling_180::FLOAT)/180 AS pct_days_streamed_rolling_180
      , SUM(indicator_is_rolling_360) AS total_days_streamed_rolling_360, SUM(indicator_is_rolling_360::FLOAT)/360 AS pct_days_streamed_rolling_360
    FROM ccu_per_day_log
    GROUP BY 1,2
  )



  --get the per the_date per channel_id aggregated ccu and mb stats
  , ccu_aggregated_2 AS (
    SELECT the_date, channel_id
      , avg_ccu_rolling_1, NVL(mins_broadcast_rolling_1,0) AS mins_broadcast_rolling_1, NVL(avg_mb_per_day_rolling_1,0) AS avg_mb_per_day_rolling_1
      , avg_ccu_rolling_7, NVL(mins_broadcast_rolling_7,0) AS mins_broadcast_rolling_7, NVL(avg_mb_per_day_rolling_7,0) AS avg_mb_per_day_rolling_7
      , avg_ccu_rolling_14, NVL(mins_broadcast_rolling_14,0) AS mins_broadcast_rolling_14, NVL(avg_mb_per_day_rolling_14,0) AS avg_mb_per_day_rolling_14
      , avg_ccu_rolling_30, NVL(mins_broadcast_rolling_30,0) AS mins_broadcast_rolling_30, NVL(avg_mb_per_day_rolling_30,0) AS avg_mb_per_day_rolling_30
      , avg_ccu_rolling_60, NVL(mins_broadcast_rolling_60,0) AS mins_broadcast_rolling_60, NVL(avg_mb_per_day_rolling_60,0) AS avg_mb_per_day_rolling_60
      , avg_ccu_rolling_90, NVL(mins_broadcast_rolling_90,0) AS mins_broadcast_rolling_90, NVL(avg_mb_per_day_rolling_90,0) AS avg_mb_per_day_rolling_90
      , avg_ccu_rolling_180, NVL(mins_broadcast_rolling_180,0) AS mins_broadcast_rolling_180, NVL(avg_mb_per_day_rolling_180,0) AS avg_mb_per_day_rolling_180
      , avg_ccu_rolling_360, NVL(mins_broadcast_rolling_360,0) AS mins_broadcast_rolling_360, NVL(avg_mb_per_day_rolling_360,0) AS avg_mb_per_day_rolling_360
    FROM (
      SELECT day AS the_date, channel_id

      , AVG(CASE WHEN flag_is_rolling_1 THEN total::FLOAT ELSE NULL END) AS avg_ccu_rolling_1
      , COUNT(CASE WHEN flag_is_rolling_1 THEN 1 ELSE NULL END) AS mins_broadcast_rolling_1
      , COUNT(CASE WHEN flag_is_rolling_1 THEN 1 ELSE NULL END)::FLOAT/7 AS avg_mb_per_day_rolling_1

      , AVG(CASE WHEN flag_is_rolling_7 THEN total::FLOAT ELSE NULL END) AS avg_ccu_rolling_7
      , COUNT(CASE WHEN flag_is_rolling_7 THEN 1 ELSE NULL END) AS mins_broadcast_rolling_7
      , COUNT(CASE WHEN flag_is_rolling_7 THEN 1 ELSE NULL END)::FLOAT/7 AS avg_mb_per_day_rolling_7

      , AVG(CASE WHEN flag_is_rolling_14 THEN total::FLOAT ELSE NULL END) AS avg_ccu_rolling_14
      , COUNT(CASE WHEN flag_is_rolling_14 THEN 1 ELSE NULL END) AS mins_broadcast_rolling_14
      , COUNT(CASE WHEN flag_is_rolling_14 THEN 1 ELSE NULL END)::FLOAT/14 AS avg_mb_per_day_rolling_14

      , AVG(CASE WHEN flag_is_rolling_30 THEN total::FLOAT ELSE NULL END) AS avg_ccu_rolling_30
      , COUNT(CASE WHEN flag_is_rolling_30 THEN 1 ELSE NULL END) AS mins_broadcast_rolling_30
      , COUNT(CASE WHEN flag_is_rolling_30 THEN 1 ELSE NULL END)::FLOAT/30 AS avg_mb_per_day_rolling_30

      , AVG(CASE WHEN flag_is_rolling_60 THEN total::FLOAT ELSE NULL END) AS avg_ccu_rolling_60
      , COUNT(CASE WHEN flag_is_rolling_60 THEN 1 ELSE NULL END) AS mins_broadcast_rolling_60
      , COUNT(CASE WHEN flag_is_rolling_60 THEN 1 ELSE NULL END)::FLOAT/60 AS avg_mb_per_day_rolling_60

      , AVG(CASE WHEN flag_is_rolling_90 THEN total::FLOAT ELSE NULL END) AS avg_ccu_rolling_90
      , COUNT(CASE WHEN flag_is_rolling_90 THEN 1 ELSE NULL END) AS mins_broadcast_rolling_90
      , COUNT(CASE WHEN flag_is_rolling_90 THEN 1 ELSE NULL END)::FLOAT/90 AS avg_mb_per_day_rolling_90

      , AVG(CASE WHEN flag_is_rolling_180 THEN total::FLOAT ELSE NULL END) AS avg_ccu_rolling_180
      , COUNT(CASE WHEN flag_is_rolling_180 THEN 1 ELSE NULL END) AS mins_broadcast_rolling_180
      , COUNT(CASE WHEN flag_is_rolling_180 THEN 1 ELSE NULL END)::FLOAT/180 AS avg_mb_per_day_rolling_180

      , AVG(CASE WHEN flag_is_rolling_360 THEN total::FLOAT ELSE NULL END) AS avg_ccu_rolling_360
      , COUNT(CASE WHEN flag_is_rolling_360 THEN 1 ELSE NULL END) AS mins_broadcast_rolling_360
      , COUNT(CASE WHEN flag_is_rolling_360 THEN 1 ELSE NULL END)::FLOAT/360 AS avg_mb_per_day_rolling_360

      FROM ccu_log
      GROUP BY 1,2
    )
  )



  --Use the rollup table cubes.affiliate_partner_channel_status_timeline (https://sheik.di.xarth.tv/tables/428)
  --The columns are : channel_id, affiliate_or_partner_status_type, effective_from_time, effective_until_time
  --The possible values for affiliate_or_partner_status_type are 'affiliate' 'partner' '0cpm_partner'
  --"$0 CPM” partners are “important” channels where we give them the same partner status treatment, but we don’t have any monetary exchange with them via subs/bits/ads etc.
  --From Brandon: they are "business partners" that need partner benefits like guaranteed transcodes, visibility that the channel is "official," etc.
  , meta_partner_affiliate AS (
    SELECT
      (SELECT the_day_we_run_script - INTERVAL '1 days' FROM the_parameter_input) AS the_date
      , channel_id
      , CASE
          WHEN affiliate_or_partner_status_type IN ('partner', '0cpm_partner') THEN 'partner'
          WHEN affiliate_or_partner_status_type IN ('affiliate') THEN 'affiliate'
          ELSE NULL
        END AS channel_type
    FROM cubes.affiliate_partner_channel_status_timeline
    WHERE
      effective_from_time <= (SELECT the_day_we_run_script - INTERVAL '1 days' FROM the_parameter_input)
      AND (SELECT the_day_we_run_script - INTERVAL '1 days' FROM the_parameter_input) < effective_until_time
  )



  -- NEW LOGIC FOR Tier 5 Channels, see email from sharon titled --->      Premium Tables - Sheik Migration Update
  , meta_esports AS (
    SELECT
      channel
      , '2000-01-01'::DATE AS date_added
      , '9999-12-31'::DATE AS date_removed
    FROM metadata.atlas_f_organizer_channel
    WHERE is_ugc=FALSE
    GROUP BY 1
  )

  , meta_png_content AS (
    select
      channel
      , to_date(case when date_added::text > '' then date_added else '2000-01-01 00:00:00' end, 'YYYY-MM-DD HH24:MI:SS') as date_added
      , to_date(case when date_removed::text > '' then date_removed else '9999-12-31 00:00:00' end, 'YYYY-MM-DD HH24:MI:SS') as date_removed
    from metadata.png_whitelist
    group by 1,2,3
  )

  , premium_channel_name AS (
    SELECT * FROM meta_esports
    UNION ALL SELECT * FROM meta_png_content
  )

  , meta_premium_channel AS (
    SELECT MIN(channel) AS channel, channel_id, MIN(date_added) AS date_added, MAX(date_removed) AS date_removed
    FROM (
      SELECT base.channel, map.user_id AS channel_id, base.date_added, base.date_removed
      FROM premium_channel_name AS base
      LEFT JOIN dx_metadata.user_id_to_login_mapping AS map ON base.channel = map.login
    )
    WHERE channel_id IS NOT NULL
    GROUP BY channel_id
  )

  , the_data_1 AS (
    SELECT the_date, channel_id
      , total_days_streamed_rolling_1, pct_days_streamed_rolling_1
      , total_days_streamed_rolling_7, pct_days_streamed_rolling_7
      , total_days_streamed_rolling_14, pct_days_streamed_rolling_14
      , total_days_streamed_rolling_30, pct_days_streamed_rolling_30
      , total_days_streamed_rolling_60, pct_days_streamed_rolling_60
      , total_days_streamed_rolling_90, pct_days_streamed_rolling_90
      , total_days_streamed_rolling_180, pct_days_streamed_rolling_180
      , total_days_streamed_rolling_360, pct_days_streamed_rolling_360
    FROM ccu_aggregated_1
  )

  --take the_data_rolling_30 as the "default" metric for "tier" and "active streamer status"
  --this is the opinion from DX team on the standard to use
  , the_data_2 AS (
    SELECT base.the_date, base.channel_id, su.login AS channel
      , NVL(mpa.channel_type,'not_partner_affiliate') AS channel_type
      , base.avg_ccu_rolling_1, base.mins_broadcast_rolling_1, base.avg_mb_per_day_rolling_1
      , CASE
          WHEN mpc.channel IS NOT NULL THEN 'T5: Premium'
          WHEN base.avg_ccu_rolling_1 <= 2 THEN 'T0: 0-2 ccv'
          WHEN base.avg_ccu_rolling_1 <= 10 THEN 'T1: 3-10 ccv'
          WHEN base.avg_ccu_rolling_1 <= 100 THEN  'T2: 11-100 ccv'
          WHEN base.avg_ccu_rolling_1 <= 4000 THEN  'T3: 101-4000 ccv'
          WHEN base.avg_ccu_rolling_1 > 4000 THEN  'T4: 4001+ ccv'
          ELSE 'NULL: NOT STREAM LAST 1 DAYS'
        END AS tier_rolling_1 --new 2019 tiers see https://docs.google.com/document/d/1t4WLzTKEsEq1VEsOdA9POCupRtV6fefZfzgMpk9PyJA/edit#heading=h.l25drnd1o9q5
      , CASE
          WHEN avg_mb_per_day_rolling_1>=10 THEN 'active_streamer'
          ELSE 'not_active_streamer'
        END AS active_streamer_status_rolling_1
      , base.avg_ccu_rolling_7, base.mins_broadcast_rolling_7, base.avg_mb_per_day_rolling_7
      , CASE
          WHEN mpc.channel IS NOT NULL THEN 'T5: Premium'
          WHEN base.avg_ccu_rolling_7 <= 2 THEN 'T0: 0-2 ccv'
          WHEN base.avg_ccu_rolling_7 <= 10 THEN 'T1: 3-10 ccv'
          WHEN base.avg_ccu_rolling_7 <= 100 THEN  'T2: 11-100 ccv'
          WHEN base.avg_ccu_rolling_7 <= 4000 THEN  'T3: 101-4000 ccv'
          WHEN base.avg_ccu_rolling_7 > 4000 THEN  'T4: 4001+ ccv'
          ELSE 'NULL: NOT STREAM LAST 7 DAYS'
        END AS tier_rolling_7 --new 2019 tiers see https://docs.google.com/document/d/1t4WLzTKEsEq1VEsOdA9POCupRtV6fefZfzgMpk9PyJA/edit#heading=h.l25drnd1o9q5
      , CASE
          WHEN avg_mb_per_day_rolling_7>=10 THEN 'active_streamer'
          ELSE 'not_active_streamer'
        END AS active_streamer_status_rolling_7
      , base.avg_ccu_rolling_14, base.mins_broadcast_rolling_14, base.avg_mb_per_day_rolling_14
      , CASE
          WHEN mpc.channel IS NOT NULL THEN 'T5: Premium'
          WHEN base.avg_ccu_rolling_14 <= 2 THEN 'T0: 0-2 ccv'
          WHEN base.avg_ccu_rolling_14 <= 10 THEN 'T1: 3-10 ccv'
          WHEN base.avg_ccu_rolling_14 <= 100 THEN  'T2: 11-100 ccv'
          WHEN base.avg_ccu_rolling_14 <= 4000 THEN  'T3: 101-4000 ccv'
          WHEN base.avg_ccu_rolling_14 > 4000 THEN  'T4: 4001+ ccv'
          ELSE 'NULL: NOT STREAM LAST 14 DAYS'
        END AS tier_rolling_14 --new 2019 tiers see https://docs.google.com/document/d/1t4WLzTKEsEq1VEsOdA9POCupRtV6fefZfzgMpk9PyJA/edit#heading=h.l25drnd1o9q5
      , CASE
          WHEN avg_mb_per_day_rolling_14>=10 THEN 'active_streamer'
          ELSE 'not_active_streamer'
        END AS active_streamer_status_rolling_14
      , base.avg_ccu_rolling_30, base.mins_broadcast_rolling_30, base.avg_mb_per_day_rolling_30
      , CASE
          WHEN mpc.channel IS NOT NULL THEN 'T5: Premium'
          WHEN base.avg_ccu_rolling_30 <= 2 THEN 'T0: 0-2 ccv'
          WHEN base.avg_ccu_rolling_30 <= 10 THEN 'T1: 3-10 ccv'
          WHEN base.avg_ccu_rolling_30 <= 100 THEN  'T2: 11-100 ccv'
          WHEN base.avg_ccu_rolling_30 <= 4000 THEN  'T3: 101-4000 ccv'
          WHEN base.avg_ccu_rolling_30 > 4000 THEN  'T4: 4001+ ccv'
          ELSE 'NULL: NOT STREAM LAST 30 DAYS'
        END AS tier_rolling_30 --new 2019 tiers see https://docs.google.com/document/d/1t4WLzTKEsEq1VEsOdA9POCupRtV6fefZfzgMpk9PyJA/edit#heading=h.l25drnd1o9q5
      , CASE
          WHEN avg_mb_per_day_rolling_30>=10 THEN 'active_streamer'
          ELSE 'not_active_streamer'
        END AS active_streamer_status_rolling_30
      , base.avg_ccu_rolling_60, base.mins_broadcast_rolling_60, base.avg_mb_per_day_rolling_60
      , CASE
          WHEN mpc.channel IS NOT NULL THEN 'T5: Premium'
          WHEN base.avg_ccu_rolling_60 <= 2 THEN 'T0: 0-2 ccv'
          WHEN base.avg_ccu_rolling_60 <= 10 THEN 'T1: 3-10 ccv'
          WHEN base.avg_ccu_rolling_60 <= 100 THEN  'T2: 11-100 ccv'
          WHEN base.avg_ccu_rolling_60 <= 4000 THEN  'T3: 101-4000 ccv'
          WHEN base.avg_ccu_rolling_60 > 4000 THEN  'T4: 4001+ ccv'
          ELSE 'NULL: NOT STREAM LAST 60 DAYS'
        END AS tier_rolling_60 --new 2019 tiers see https://docs.google.com/document/d/1t4WLzTKEsEq1VEsOdA9POCupRtV6fefZfzgMpk9PyJA/edit#heading=h.l25drnd1o9q5
      , CASE
          WHEN avg_mb_per_day_rolling_60>=10 THEN 'active_streamer'
          ELSE 'not_active_streamer'
        END AS active_streamer_status_rolling_60
      , base.avg_ccu_rolling_90, base.mins_broadcast_rolling_90, base.avg_mb_per_day_rolling_90
      , CASE
          WHEN mpc.channel IS NOT NULL THEN 'T5: Premium'
          WHEN base.avg_ccu_rolling_90 <= 2 THEN 'T0: 0-2 ccv'
          WHEN base.avg_ccu_rolling_90 <= 10 THEN 'T1: 3-10 ccv'
          WHEN base.avg_ccu_rolling_90 <= 100 THEN  'T2: 11-100 ccv'
          WHEN base.avg_ccu_rolling_90 <= 4000 THEN  'T3: 101-4000 ccv'
          WHEN base.avg_ccu_rolling_90 > 4000 THEN  'T4: 4001+ ccv'
          ELSE 'NULL: NOT STREAM LAST 90 DAYS'
        END AS tier_rolling_90 --new 2019 tiers see https://docs.google.com/document/d/1t4WLzTKEsEq1VEsOdA9POCupRtV6fefZfzgMpk9PyJA/edit#heading=h.l25drnd1o9q5
      , CASE
          WHEN avg_mb_per_day_rolling_90>=10 THEN 'active_streamer'
          ELSE 'not_active_streamer'
        END AS active_streamer_status_rolling_90
      , base.avg_ccu_rolling_180, base.mins_broadcast_rolling_180, base.avg_mb_per_day_rolling_180
      , CASE
          WHEN mpc.channel IS NOT NULL THEN 'T5: Premium'
          WHEN base.avg_ccu_rolling_180 <= 2 THEN 'T0: 0-2 ccv'
          WHEN base.avg_ccu_rolling_180 <= 10 THEN 'T1: 3-10 ccv'
          WHEN base.avg_ccu_rolling_180 <= 100 THEN  'T2: 11-100 ccv'
          WHEN base.avg_ccu_rolling_180 <= 4000 THEN  'T3: 101-4000 ccv'
          WHEN base.avg_ccu_rolling_180 > 4000 THEN  'T4: 4001+ ccv'
          ELSE 'NULL: NOT STREAM LAST 180 DAYS'
        END AS tier_rolling_180 --new 2019 tiers see https://docs.google.com/document/d/1t4WLzTKEsEq1VEsOdA9POCupRtV6fefZfzgMpk9PyJA/edit#heading=h.l25drnd1o9q5
      , CASE
          WHEN avg_mb_per_day_rolling_180>=10 THEN 'active_streamer'
          ELSE 'not_active_streamer'
        END AS active_streamer_status_rolling_180
      , base.avg_ccu_rolling_360, base.mins_broadcast_rolling_360, base.avg_mb_per_day_rolling_360
      , CASE
          WHEN mpc.channel IS NOT NULL THEN 'T5: Premium'
          WHEN base.avg_ccu_rolling_360 <= 2 THEN 'T0: 0-2 ccv'
          WHEN base.avg_ccu_rolling_360 <= 10 THEN 'T1: 3-10 ccv'
          WHEN base.avg_ccu_rolling_360 <= 100 THEN  'T2: 11-100 ccv'
          WHEN base.avg_ccu_rolling_360 <= 4000 THEN  'T3: 101-4000 ccv'
          WHEN base.avg_ccu_rolling_360 > 4000 THEN  'T4: 4001+ ccv'
          ELSE 'NULL: NOT STREAM LAST 360 DAYS'
        END AS tier_rolling_360 --new 2019 tiers see https://docs.google.com/document/d/1t4WLzTKEsEq1VEsOdA9POCupRtV6fefZfzgMpk9PyJA/edit#heading=h.l25drnd1o9q5
      , CASE
          WHEN avg_mb_per_day_rolling_360>=10 THEN 'active_streamer'
          ELSE 'not_active_streamer'
        END AS active_streamer_status_rolling_360
    FROM ccu_aggregated_2 AS base
    LEFT JOIN meta_premium_channel AS mpc ON
      base.channel_id = mpc.channel_id
      AND mpc.date_added <= base.the_date
      AND base.the_date < mpc.date_removed
    LEFT JOIN meta_partner_affiliate AS mpa ON
      base.the_date = mpa.the_date
      AND base.channel_id = mpa.channel_id
    LEFT JOIN dbsnapshots.users AS su ON base.channel_id = su.id
  )



  , final_data AS (
    SELECT base.the_date, base.channel_id, base.channel, channel_type, tier_rolling_30 AS tier, active_streamer_status_rolling_30 AS active_streamer_status
      , avg_ccu_rolling_1, mins_broadcast_rolling_1, avg_mb_per_day_rolling_1, tier_rolling_1, active_streamer_status_rolling_1, total_days_streamed_rolling_1, pct_days_streamed_rolling_1
      , avg_ccu_rolling_7, mins_broadcast_rolling_7, avg_mb_per_day_rolling_7, tier_rolling_7, active_streamer_status_rolling_7, total_days_streamed_rolling_7, pct_days_streamed_rolling_7
      , avg_ccu_rolling_14, mins_broadcast_rolling_14, avg_mb_per_day_rolling_14, tier_rolling_14, active_streamer_status_rolling_14, total_days_streamed_rolling_14, pct_days_streamed_rolling_14
      , avg_ccu_rolling_30, mins_broadcast_rolling_30, avg_mb_per_day_rolling_30, tier_rolling_30, active_streamer_status_rolling_30, total_days_streamed_rolling_30, pct_days_streamed_rolling_30
      , avg_ccu_rolling_60, mins_broadcast_rolling_60, avg_mb_per_day_rolling_60, tier_rolling_60, active_streamer_status_rolling_60, total_days_streamed_rolling_60, pct_days_streamed_rolling_60
      , avg_ccu_rolling_90, mins_broadcast_rolling_90, avg_mb_per_day_rolling_90, tier_rolling_90, active_streamer_status_rolling_90, total_days_streamed_rolling_90, pct_days_streamed_rolling_90
      , avg_ccu_rolling_180, mins_broadcast_rolling_180, avg_mb_per_day_rolling_180, tier_rolling_180, active_streamer_status_rolling_180, total_days_streamed_rolling_180, pct_days_streamed_rolling_180
      , avg_ccu_rolling_360, mins_broadcast_rolling_360, avg_mb_per_day_rolling_360, tier_rolling_360, active_streamer_status_rolling_360, total_days_streamed_rolling_360, pct_days_streamed_rolling_360
    FROM the_data_2 AS base
    LEFT JOIN the_data_1 AS other ON base.the_date = other.the_date AND base.channel_id = other.channel_id
  )

  SELECT * FROM final_data




);



--
-- EXECUTE the_insert_function ('2018-07-01');		EXECUTE the_delete_function ('2018-07-01');
-- INSERT INTO dx_sandbox.channel_daily_status
-- (SELECT * FROM the_temp_table);
-- DELETE FROM the_temp_table;
--
-- EXECUTE the_insert_function ('2018-07-02');		EXECUTE the_delete_function ('2018-07-02');
-- INSERT INTO dx_sandbox.channel_daily_status
-- (SELECT * FROM the_temp_table);
-- DELETE FROM the_temp_table;
--
-- EXECUTE the_insert_function ('2018-07-03');		EXECUTE the_delete_function ('2018-07-03');
-- INSERT INTO dx_sandbox.channel_daily_status
-- (SELECT * FROM the_temp_table);
-- DELETE FROM the_temp_table;
--
-- EXECUTE the_insert_function ('2018-07-04');		EXECUTE the_delete_function ('2018-07-04');
-- INSERT INTO dx_sandbox.channel_daily_status
-- (SELECT * FROM the_temp_table);
-- DELETE FROM the_temp_table;
--
-- EXECUTE the_insert_function ('2018-07-05');		EXECUTE the_delete_function ('2018-07-05');
-- INSERT INTO dx_sandbox.channel_daily_status
-- (SELECT * FROM the_temp_table);
-- DELETE FROM the_temp_table;
--
-- EXECUTE the_insert_function ('2018-07-06');		EXECUTE the_delete_function ('2018-07-06');
-- INSERT INTO dx_sandbox.channel_daily_status
-- (SELECT * FROM the_temp_table);
-- DELETE FROM the_temp_table;
--
-- EXECUTE the_insert_function ('2018-07-07');		EXECUTE the_delete_function ('2018-07-07');
-- INSERT INTO dx_sandbox.channel_daily_status
-- (SELECT * FROM the_temp_table);
-- DELETE FROM the_temp_table;
--
-- EXECUTE the_insert_function ('2018-07-08');		EXECUTE the_delete_function ('2018-07-08');
-- INSERT INTO dx_sandbox.channel_daily_status
-- (SELECT * FROM the_temp_table);
-- DELETE FROM the_temp_table;
--
-- EXECUTE the_insert_function ('2018-07-09');		EXECUTE the_delete_function ('2018-07-09');
-- INSERT INTO dx_sandbox.channel_daily_status
-- (SELECT * FROM the_temp_table);
-- DELETE FROM the_temp_table;
--
-- EXECUTE the_insert_function ('2018-07-10');		EXECUTE the_delete_function ('2018-07-10');
-- INSERT INTO dx_sandbox.channel_daily_status
-- (SELECT * FROM the_temp_table);
-- DELETE FROM the_temp_table;
--
-- EXECUTE the_insert_function ('2018-07-11');		EXECUTE the_delete_function ('2018-07-11');
-- INSERT INTO dx_sandbox.channel_daily_status
-- (SELECT * FROM the_temp_table);
-- DELETE FROM the_temp_table;
--
-- EXECUTE the_insert_function ('2018-07-12');		EXECUTE the_delete_function ('2018-07-12');
-- INSERT INTO dx_sandbox.channel_daily_status
-- (SELECT * FROM the_temp_table);
-- DELETE FROM the_temp_table;
--
-- EXECUTE the_insert_function ('2018-07-13');		EXECUTE the_delete_function ('2018-07-13');
-- INSERT INTO dx_sandbox.channel_daily_status
-- (SELECT * FROM the_temp_table);
-- DELETE FROM the_temp_table;
--
-- EXECUTE the_insert_function ('2018-07-14');		EXECUTE the_delete_function ('2018-07-14');
-- INSERT INTO dx_sandbox.channel_daily_status
-- (SELECT * FROM the_temp_table);
-- DELETE FROM the_temp_table;
--
-- EXECUTE the_insert_function ('2018-07-15');		EXECUTE the_delete_function ('2018-07-15');
-- INSERT INTO dx_sandbox.channel_daily_status
-- (SELECT * FROM the_temp_table);
-- DELETE FROM the_temp_table;
--
-- EXECUTE the_insert_function ('2018-07-16');		EXECUTE the_delete_function ('2018-07-16');
-- INSERT INTO dx_sandbox.channel_daily_status
-- (SELECT * FROM the_temp_table);
-- DELETE FROM the_temp_table;
--
-- EXECUTE the_insert_function ('2018-07-17');		EXECUTE the_delete_function ('2018-07-17');
-- INSERT INTO dx_sandbox.channel_daily_status
-- (SELECT * FROM the_temp_table);
-- DELETE FROM the_temp_table;
--
-- EXECUTE the_insert_function ('2018-07-18');		EXECUTE the_delete_function ('2018-07-18');
-- INSERT INTO dx_sandbox.channel_daily_status
-- (SELECT * FROM the_temp_table);
-- DELETE FROM the_temp_table;
--
-- EXECUTE the_insert_function ('2018-07-19');		EXECUTE the_delete_function ('2018-07-19');
-- INSERT INTO dx_sandbox.channel_daily_status
-- (SELECT * FROM the_temp_table);
-- DELETE FROM the_temp_table;
--
-- EXECUTE the_insert_function ('2018-07-20');		EXECUTE the_delete_function ('2018-07-20');
-- INSERT INTO dx_sandbox.channel_daily_status
-- (SELECT * FROM the_temp_table);
-- DELETE FROM the_temp_table;
--
-- EXECUTE the_insert_function ('2018-07-21');		EXECUTE the_delete_function ('2018-07-21');
-- INSERT INTO dx_sandbox.channel_daily_status
-- (SELECT * FROM the_temp_table);
-- DELETE FROM the_temp_table;
--
-- EXECUTE the_insert_function ('2018-07-22');		EXECUTE the_delete_function ('2018-07-22');
-- INSERT INTO dx_sandbox.channel_daily_status
-- (SELECT * FROM the_temp_table);
-- DELETE FROM the_temp_table;
--
-- EXECUTE the_insert_function ('2018-07-23');		EXECUTE the_delete_function ('2018-07-23');
-- INSERT INTO dx_sandbox.channel_daily_status
-- (SELECT * FROM the_temp_table);
-- DELETE FROM the_temp_table;
--
-- EXECUTE the_insert_function ('2018-07-24');		EXECUTE the_delete_function ('2018-07-24');
-- INSERT INTO dx_sandbox.channel_daily_status
-- (SELECT * FROM the_temp_table);
-- DELETE FROM the_temp_table;
--
-- EXECUTE the_insert_function ('2018-07-25');		EXECUTE the_delete_function ('2018-07-25');
-- INSERT INTO dx_sandbox.channel_daily_status
-- (SELECT * FROM the_temp_table);
-- DELETE FROM the_temp_table;
--
-- EXECUTE the_insert_function ('2018-07-26');		EXECUTE the_delete_function ('2018-07-26');
-- INSERT INTO dx_sandbox.channel_daily_status
-- (SELECT * FROM the_temp_table);
-- DELETE FROM the_temp_table;
--
-- EXECUTE the_insert_function ('2018-07-27');		EXECUTE the_delete_function ('2018-07-27');
-- INSERT INTO dx_sandbox.channel_daily_status
-- (SELECT * FROM the_temp_table);
-- DELETE FROM the_temp_table;
--
-- EXECUTE the_insert_function ('2018-07-28');		EXECUTE the_delete_function ('2018-07-28');
-- INSERT INTO dx_sandbox.channel_daily_status
-- (SELECT * FROM the_temp_table);
-- DELETE FROM the_temp_table;
--
-- EXECUTE the_insert_function ('2018-07-29');		EXECUTE the_delete_function ('2018-07-29');
-- INSERT INTO dx_sandbox.channel_daily_status
-- (SELECT * FROM the_temp_table);
-- DELETE FROM the_temp_table;
--
-- EXECUTE the_insert_function ('2018-07-30');		EXECUTE the_delete_function ('2018-07-30');
-- INSERT INTO dx_sandbox.channel_daily_status
-- (SELECT * FROM the_temp_table);
-- DELETE FROM the_temp_table;
--
-- EXECUTE the_insert_function ('2018-07-31');		EXECUTE the_delete_function ('2018-07-31');
-- INSERT INTO dx_sandbox.channel_daily_status
-- (SELECT * FROM the_temp_table);
-- DELETE FROM the_temp_table;

EXECUTE the_insert_function ('2019-05-15');		EXECUTE the_delete_function ('2019-05-15');
INSERT INTO dx_sandbox.channel_daily_status
(SELECT * FROM the_temp_table);
DELETE FROM the_temp_table;

EXECUTE the_insert_function ('2019-05-16');		EXECUTE the_delete_function ('2019-05-16');
INSERT INTO dx_sandbox.channel_daily_status
(SELECT * FROM the_temp_table);
DELETE FROM the_temp_table;

EXECUTE the_insert_function ('2019-05-17');		EXECUTE the_delete_function ('2019-05-17');
INSERT INTO dx_sandbox.channel_daily_status
(SELECT * FROM the_temp_table);
DELETE FROM the_temp_table;

EXECUTE the_insert_function ('2019-05-18');		EXECUTE the_delete_function ('2019-05-18');
INSERT INTO dx_sandbox.channel_daily_status
(SELECT * FROM the_temp_table);
DELETE FROM the_temp_table;

EXECUTE the_insert_function ('2019-05-19');		EXECUTE the_delete_function ('2019-05-19');
INSERT INTO dx_sandbox.channel_daily_status
(SELECT * FROM the_temp_table);
DELETE FROM the_temp_table;

EXECUTE the_insert_function ('2019-05-20');		EXECUTE the_delete_function ('2019-05-20');
INSERT INTO dx_sandbox.channel_daily_status
(SELECT * FROM the_temp_table);
DELETE FROM the_temp_table;

EXECUTE the_insert_function ('2019-05-21');		EXECUTE the_delete_function ('2019-05-21');
INSERT INTO dx_sandbox.channel_daily_status
(SELECT * FROM the_temp_table);
DELETE FROM the_temp_table;

EXECUTE the_insert_function ('2019-05-22');		EXECUTE the_delete_function ('2019-05-22');
INSERT INTO dx_sandbox.channel_daily_status
(SELECT * FROM the_temp_table);
DELETE FROM the_temp_table;








--
--
--
-- -- Load TEMP_TABLE into ROLLUP_TABLE
-- INSERT INTO dx_sandbox.channel_daily_status
-- (SELECT * FROM the_temp_table);



DEALLOCATE the_insert_function;
DEALLOCATE the_delete_function;
