WITH
the_constants AS (
  SELECT '2016-01-01'::DATE AS start_date
  , '2019-06-01'::DATE AS end_date
)
, the_dates AS (
  SELECT date AS the_date
  FROM metadata.date
  WHERE date>=(SELECT start_date FROM the_constants)
    AND date<(SELECT end_date FROM the_constants)
)

, the_data AS (
  SELECT the_date
    , COUNT(1) AS rows
    , COUNT(DISTINCT channel_id) AS channels
    , COUNT(DISTINCT channel_type) AS distinct_channel_type
    , COUNT(DISTINCT tier) AS distinct_tiers
  FROM dx_sandbox.channel_daily_status
  GROUP BY 1
)

, final_data AS (
  SELECT base.the_date, td.channels, td.distinct_channel_type, td.distinct_tiers
  FROM the_dates AS base
  LEFT JOIN the_data AS td ON base.the_date = td.the_date
)

SELECT * FROM final_data
