#!/bin/bash

# Assuming that you have your .sql files debugged and ready to be automated
# You can use this example file as a starter bash script

# Change your constants
CONSTANT_SQL_FILES=(
"cron_job_extension_daily_channel_presence.sql"
# add "test1.sql" etc. as new line if needed
) # learn about arrays here: https://unix.stackexchange.com/questions/459692/loop-through-variables

CONSTANT_USERNAME="yanghung" #This is your LDAP username

#To get the name of the current bash file ->  https://stackoverflow.com/questions/192319/how-do-i-know-the-script-file-name-in-a-bash-script
CONSTANT_THIS_FILENAME=${0##*/}
#To get the full path of the current directory ->  https://stackoverflow.com/questions/59895/getting-the-source-directory-of-a-bash-script-from-within
CONSTANT_THIS_DIR="$( cd "$( dirname "${BASH_SOURCE[0]}" )" >/dev/null && pwd )"

#Constants for psql function
LOGIN=${CONSTANT_USERNAME}
PSQL_SERVER=tahoe-tap.community-data.twitch.a2z.com
DB=product
PORT=5439

#custom setup of slack incoming webhooks app, see https://twitch.slack.com/services/B840341QD
CONSTANT_SLACK_WEBHOOK_URL="https://hooks.slack.com/services/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"




# For each sql file in the array $CONSTANT_SQL_FILES, run it, then ping the slack channel that it's done
for THE_SQL_FILE in "${CONSTANT_SQL_FILES[@]}" ; do

  # Run .sql file
  psql -h ${PSQL_SERVER} -U ${LOGIN} -d ${DB} -p ${PORT} -a -f $CONSTANT_THIS_DIR/$THE_SQL_FILE

  # Ping the slack channel that it's done
  curl --silent -X POST --data-urlencode "payload={
  \"text\": \"
      Hi @channel the query \`$THE_SQL_FILE\` finished.
      (Note: This was part of the bash script *$CONSTANT_THIS_FILENAME* from the *coconut_box* server)
    \"
  , \"link_names\": 1, \"mrkdwn\": true
  }" $CONSTANT_SLACK_WEBHOOK_URL

done
