WITH
the_constants_time AS (
  SELECT '2019-09-01'::DATE AS start_date --update the month each time
    --, '2019-02-26'::DATE AS end_date
    , DATE_TRUNC('day', (SYSDATE - INTERVAL '7 hours')) AS end_date
)


, daily_channel_presence AS (
  SELECT base.the_day, base.channel_id, cds.tier, base.extension_id, ael.extension_name, ael.extension_url
  FROM dx_rollup.extension_daily_channel_presence AS base
  LEFT JOIN dx_rollup.channel_daily_status AS cds ON base.channel_id = cds.channel_id AND base.the_day = cds.the_date
  LEFT JOIN dx_metadata.all_extensions_latest AS ael ON base.extension_id = ael.extension_id
  WHERE
    (SELECT start_date FROM the_constants_time)<=the_day AND the_day<(SELECT end_date FROM the_constants_time)
    AND bool_extension_activated = TRUE
    AND tier IN ('T5: Premium')
)

SELECT extension_id, extension_name, extension_url
FROM daily_channel_presence
WHERE extension_id NOT IN (SELECT extension_id FROM dx_sandbox.premium_channel_extensions GROUP BY 1)
GROUP BY 1,2,3
;
