-- DROP TABLE dx_sandbox.extension_content_matched_metric;
-- CREATE TABLE dx_sandbox.extension_content_matched_metric (LIKE dx_sandbox.extension_content_matched_metric_partial_ugc);

--DELETE THE DATA FOR THE DAY YOU ARE GOING TO BE ADDING IN
PREPARE the_delete_function (VARCHAR) AS
DELETE FROM dx_sandbox.extension_content_matched_metric
WHERE the_day = $1::DATE
;





--THEN CREATE A the_temp_table BASED ON THAT SCHEMA
CREATE TEMP TABLE the_temp_table (LIKE dx_sandbox.extension_content_matched_metric);

--THEN WRITE YOUR SQL CODE FOR THE INSERT FUNCTION
PREPARE the_insert_function (VARCHAR) AS
INSERT INTO the_temp_table (



  WITH

  the_constants_time AS (
    SELECT start_date, DATEADD(day, 1, start_date) AS end_date
    FROM (SELECT $1::DATE AS start_date)
  )
  , final_data AS (
    SELECT * FROM dx_sandbox.extension_content_matched_metric_partial_ugc WHERE (SELECT start_date FROM the_constants_time)<=the_day AND the_day<(SELECT end_date FROM the_constants_time)
    UNION
    SELECT * FROM dx_sandbox.extension_content_matched_metric_partial_premium WHERE (SELECT start_date FROM the_constants_time)<=the_day AND the_day<(SELECT end_date FROM the_constants_time)

  )


  SELECT * FROM final_data

);


EXECUTE the_insert_function ('2019-06-01');		EXECUTE the_delete_function ('2019-06-01');
INSERT INTO dx_sandbox.extension_content_matched_metric
(SELECT * FROM the_temp_table);
DELETE FROM the_temp_table;

EXECUTE the_insert_function ('2019-06-02');		EXECUTE the_delete_function ('2019-06-02');
INSERT INTO dx_sandbox.extension_content_matched_metric
(SELECT * FROM the_temp_table);
DELETE FROM the_temp_table;


EXECUTE the_insert_function ('2019-06-03');		EXECUTE the_delete_function ('2019-06-03');
INSERT INTO dx_sandbox.extension_content_matched_metric
(SELECT * FROM the_temp_table);
DELETE FROM the_temp_table;


EXECUTE the_insert_function ('2019-06-04');		EXECUTE the_delete_function ('2019-06-04');
INSERT INTO dx_sandbox.extension_content_matched_metric
(SELECT * FROM the_temp_table);
DELETE FROM the_temp_table;




DROP TABLE the_temp_table;
DEALLOCATE the_insert_function;
DEALLOCATE the_delete_function;




-- QA

SELECT the_day::DATE, COUNT(1) AS rows, COUNT(DISTINCT channel_id) AS channels, COUNT(DISTINCT game_flattened) game_flattened, SUM(hw_with_blessed_extension) hw_with_blessed_extension, SUM(total_hw) total_hw, COUNT(DISTINCT the_extension_id_array)
FROM dx_sandbox.extension_content_matched_metric
WHERE the_day>='2019-07-01'
  AND the_day<='2019-07-04'
  --AND flag_ugc_oo_channel='UGC Channel'
  AND flag_ugc_oo_channel='O&O Channel'
GROUP BY 1 ORDER BY 1;

SELECT the_day::DATE, COUNT(1) AS rows, COUNT(DISTINCT channel_id) AS channels
, COUNT(DISTINCT the_game) game_flattened
, SUM(hw_with_blessed_extension) hw_with_blessed_extension, SUM(total_hw) total_hw
FROM dx_rollup.extension_content_matched_metric
WHERE the_day>='2019-07-01'
  AND the_day<='2019-07-04'
  --AND flag_ugc_oo_channel='UGC Channel'
  AND flag_ugc_oo_channel='O&O Channel'
GROUP BY 1 ORDER BY 1;


SELECT the_extension_id_array, the_extension_name_array
FROM dx_sandbox.extension_content_matched_metric
WHERE the_day>='2019-07-01'
  AND the_day<='2019-07-04'
  --AND flag_ugc_oo_channel='UGC Channel'
  --AND flag_ugc_oo_channel='O&O Channel'
  AND the_extension_id_array IS NOT NULL
GROUP BY 1,2;
