#!/bin/bash

# Misc Variable Names

FOLDER_EXTENSIONS_METADATA="/home/rollups/extensions_metadata/" #CHANGE
S3_FOLDER_NAME="s3://twitch-dx-data/extensions_metadata" #CHANGE
IAM_ROLE="arn:aws:iam::838590096234:role/dx-data-s3-access" #CHANGE
EXTENSIONS_API="https://extensions-manager.prod.us-west2.justin.tv/admni/extensions" #CHANGE

JS_GET_EXTENSION_COUNT=${FOLDER_EXTENSIONS_METADATA}"get_extension_count.js"
JS_PARSE_EXTENSIONS_JSON=${FOLDER_EXTENSIONS_METADATA}"parse_extensions_json.js"
JS_GET_CURRENT_DATE=${FOLDER_EXTENSIONS_METADATA}"fn_get_current_date.js"
JSON_GET_EXTENSION_COUNT=${FOLDER_EXTENSIONS_METADATA}"get_extension_count.json"
DATE="$(node $JS_GET_CURRENT_DATE)"

CSV_NAME_ALL_EXTENSIONS="0a_all_extensions_$DATE.csv"
CSV_NAME_RELEASED_EXTENSIONS="0a_released_extensions_$DATE.csv"
CSV_ALL_EXTENSIONS=${FOLDER_EXTENSIONS_METADATA}"all_extensions/"${CSV_NAME_ALL_EXTENSIONS}
CSV_RELEASED_EXTENSIONS=${FOLDER_EXTENSIONS_METADATA}"released_extensions/"${CSV_NAME_RELEASED_EXTENSIONS}

SQL_TABLE_EXTENSIONS_METADATA_EVERYTHING="dx_metadata.extensions_metadata_everything"
SQL_TABLE_RELEASED_EXTENSIONS_LATEST="dx_metadata.released_extensions_latest"
SQL_CREATE_TABLE_ALL_EXTENSIONS_LATEST=${FOLDER_EXTENSIONS_METADATA}"create_table_all_extensions_latest.sql"
SQL_COPY_ALL_EXTENSIONS="copy_all_extensions.sql"
SQL_COPY_RELEASED_EXTENSIONS="copy_released_extensions.sql"
THIS_FILENAME=${0##*/}


# This is the column headers for each csv file
column_names_all_extensions=$'the_date, extension_id, extension_version, extension_state, extension_category_id, extension_category_name, extension_name, extension_anchor, extension_author_email, extension_author_name, extension_support_email, extension_url, is_bits_enabled, is_component_enabled, is_overlay_enabled, is_panel_enabled, is_mobile_enabled, is_chat_enabled, is_whitelisted_extension, whitelist_channels'
column_names_released_extensions=$'extension_id, extension_version, extension_category_id, extension_category_name, extension_name, extension_anchor, extension_author_email, extension_author_name, extension_support_email, extension_url, is_bits_enabled, is_component_enabled, is_overlay_enabled, is_panel_enabled, is_mobile_enabled, is_chat_enabled, is_whitelisted_extension, whitelist_channels'



# Put headers in each csv file
cat <<EOF > $CSV_RELEASED_EXTENSIONS
$column_names_released_extensions
EOF

cat <<EOF > $CSV_ALL_EXTENSIONS
$column_names_all_extensions
EOF



# Get current number of extensions in the API
echo "---determining how many times to ping the extensions API"
curl --silent -X POST ${EXTENSIONS_API} \
  -H 'content-type: application/json' \
  -d '{"limit": 1, "offset": 0}' \
> $JSON_GET_EXTENSION_COUNT
NUM_EXTENSIONS="$(node $JS_GET_EXTENSION_COUNT $JSON_GET_EXTENSION_COUNT)" #https://stackoverflow.com/questions/4651437/how-to-set-a-variable-to-the-output-from-a-command-in-bash
let NUM_API_REQUEST=NUM_EXTENSIONS/100+2 #https://stackoverflow.com/questions/2552130/bash-evaluate-a-mathematical-term
rm -rf $JSON_GET_EXTENSION_COUNT



# Get the results of API into separate json files since there's limit of 100 results per API call
echo "---pinging the extensions endpoint to get json blobs"
for (( i=1; i<=$NUM_API_REQUEST; i++ ))
do
  OFFSET=$((0+100*(i-1)))
  LIMIT=$((100))
  D_PARAM="{\"limit\": ${LIMIT}, \"offset\": ${OFFSET}, \"sorts\": [{\"direction\":\"asc\",\"field\":\"name\"}]}"
  curl --silent -X POST ${EXTENSIONS_API} \
    -H "content-type: application/json" \
    -d "${D_PARAM}" \
  > ${FOLDER_EXTENSIONS_METADATA}json/extension_logs_${i}.json
done



# Loop through json and write data to the csvs
for (( i=1; i<=$NUM_API_REQUEST; i++ ))
do
  echo "---------processing the file: extension_logs_${i}.json"
  node $JS_PARSE_EXTENSIONS_JSON ${FOLDER_EXTENSIONS_METADATA}json/extension_logs_${i}.json 'all'>>$CSV_ALL_EXTENSIONS
  node $JS_PARSE_EXTENSIONS_JSON ${FOLDER_EXTENSIONS_METADATA}json/extension_logs_${i}.json 'released'>>$CSV_RELEASED_EXTENSIONS
done



#remove duplicates records in csv file
awk '!a[$0]++' $CSV_ALL_EXTENSIONS > placeholder.csv
cat placeholder.csv > $CSV_ALL_EXTENSIONS
rm -rf placeholder.csv

awk '!a[$0]++' $CSV_RELEASED_EXTENSIONS > placeholder.csv
cat placeholder.csv > $CSV_RELEASED_EXTENSIONS
rm -rf placeholder.csv



# Copy the csvs to s3
echo "---copying the csvs to S3"
aws s3 cp --profile s3_full_access ${FOLDER_EXTENSIONS_METADATA}all_extensions/${CSV_NAME_ALL_EXTENSIONS} ${S3_FOLDER_NAME}/
aws s3 cp --profile s3_full_access ${FOLDER_EXTENSIONS_METADATA}released_extensions/${CSV_NAME_RELEASED_EXTENSIONS} ${S3_FOLDER_NAME}/



# Generate SQL code to copy from S3
sql_code_copy_all_extensions=$(cat <<EOF
DELETE FROM ${SQL_TABLE_EXTENSIONS_METADATA_EVERYTHING} WHERE the_date=DATE_TRUNC('day', (SYSDATE - INTERVAL '7 hours'));
COPY ${SQL_TABLE_EXTENSIONS_METADATA_EVERYTHING}
FROM '${S3_FOLDER_NAME}/${CSV_NAME_ALL_EXTENSIONS}'
DELIMITER ','
CSV QUOTE '\%'
IGNOREHEADER 1
iam_role '${IAM_ROLE}';
EOF
)
cat <<EOF > $SQL_COPY_ALL_EXTENSIONS
$sql_code_copy_all_extensions
EOF

# Generate SQL code to copy from S3
sql_code_copy_released_extensions=$(cat <<EOF
DELETE FROM    ${SQL_TABLE_RELEASED_EXTENSIONS_LATEST};
COPY ${SQL_TABLE_RELEASED_EXTENSIONS_LATEST}
FROM '${S3_FOLDER_NAME}/${CSV_NAME_RELEASED_EXTENSIONS}'
DELIMITER ','
CSV QUOTE '\%'
IGNOREHEADER 1
iam_role '${IAM_ROLE}';
EOF
)
cat <<EOF > $SQL_COPY_RELEASED_EXTENSIONS
$sql_code_copy_released_extensions
EOF



# Run .sql file to add the extensions metadata
echo "---copying the s3 files into redshift"
psql -h tahoe-tap.community-data.twitch.a2z.com -U twitcher -d product -p 5439 -a -f $SQL_COPY_RELEASED_EXTENSIONS
psql -h tahoe-tap.community-data.twitch.a2z.com -U twitcher -d product -p 5439 -a -f $SQL_COPY_ALL_EXTENSIONS
psql -h tahoe-tap.community-data.twitch.a2z.com -U twitcher -d product -p 5439 -a -f $SQL_CREATE_TABLE_ALL_EXTENSIONS_LATEST



# Ping slack channel when done
LOGIN="yanghung" #CHANGE YOUR LOGIN
slack_channel_query_status="https://hooks.slack.com/services/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" #PINGS query-status channel in slack

curl --silent -X POST --data-urlencode "payload={
\"text\": \"
   Hi @${LOGIN} the script \`${THIS_FILENAME}\` finished. \n (NOTE: This is a message from the *rstudio* server)
 \"
, \"link_names\": 1, \"mrkdwn\": true
}" $slack_channel_query_status
