#!/bin/bash

# Misc Variable Names
DATE=`date +%Y_%m_%d` #The date in YYYY_MM_DD format
SQL_TABLE_NAME_EXTENSION_LOG="dx_metadata.released_extensions_latest"
FOLDER_EXTENSIONS_METADATA="/home/rollups/extensions_metadata/"
CSV_FILENAME_RELEASED_EXTENSIONS=${FOLDER_EXTENSIONS_METADATA}"released_extensions/0a_released_extensions_$DATE.csv"
SQL_FILENAME_EXTENSION_LOG=${FOLDER_EXTENSIONS_METADATA}"released_extensions/0a_get_extension_log_$DATE.sql"
JS_FILENAME_GET_EXTENSION_COUNT=${FOLDER_EXTENSIONS_METADATA}"get_extension_count.js"
JS_FILENAME_GET_RELEASED_EXTENSIONS_LATEST=${FOLDER_EXTENSIONS_METADATA}"get_released_extensions_latest.js"
JSON_FILENAME_GET_EXTENSION_COUNT=${FOLDER_EXTENSIONS_METADATA}"get_extension_count.json"


# Get current number of extensions in the API
curl --silent -X POST \
  https://extensions-manager.prod.us-west2.justin.tv/admni/extensions \
  -H 'content-type: application/json' \
  -d '{"limit": 1, "offset": 0}' \
> $JSON_FILENAME_GET_EXTENSION_COUNT
NUM_EXTENSIONS="$(node $JS_FILENAME_GET_EXTENSION_COUNT $JSON_FILENAME_GET_EXTENSION_COUNT)" #https://stackoverflow.com/questions/4651437/how-to-set-a-variable-to-the-output-from-a-command-in-bash
let NUM_API_REQUEST=NUM_EXTENSIONS/100+2 #https://stackoverflow.com/questions/2552130/bash-evaluate-a-mathematical-term
rm -rf $JSON_FILENAME_GET_EXTENSION_COUNT



# Output the SQL header code to drop table then create table
echo "GENERATING SQL FILE FROM JSON BLOBS"

paren_start=$'('
paren_end=$')'
new_line=$'\n' #https://stackoverflow.com/questions/28090477/n-in-variable-in-heredoc
column_names=$'extension_id, extension_version, extension_category_id, extension_category_name, extension_name, extension_anchor, extension_author_email, extension_author_name, extension_support_email, extension_url, is_bits_enabled, is_component_enabled, is_overlay_enabled, is_panel_enabled, is_mobile_enabled, is_chat_enabled, is_whitelisted_extension, whitelist_channels'

sql_header_extension_log=$(cat <<EOF
DELETE FROM    $SQL_TABLE_NAME_EXTENSION_LOG;
INSERT INTO    $SQL_TABLE_NAME_EXTENSION_LOG $paren_start



SELECT DISTINCT $column_names FROM $paren_start
EOF
)


cat <<EOF > $SQL_FILENAME_EXTENSION_LOG
$sql_header_extension_log
$new_line
EOF



csv_header_released_extensions=$(cat <<EOF
$column_names
EOF
)


cat <<EOF > $CSV_FILENAME_RELEASED_EXTENSIONS
$csv_header_released_extensions
EOF



# Run curl command to get the results of API into separate json files since there's limit of 100 results per API call
# Then take the released extensions from the json files and generate SQL code to upload to a table
for (( i=1; i<=$NUM_API_REQUEST; i++ ))
do
  OFFSET=$((0+100*(i-1)))
  LIMIT=$((100))
  # D_PARAM="{\"limit\": 100, \"offset\": ${OFFSET}}"
  D_PARAM="{\"limit\": 100, \"offset\": ${OFFSET}, \"sorts\": [{\"direction\":\"asc\",\"field\":\"name\"}]}"
  curl --silent -X POST \
    https://extensions-manager.prod.us-west2.justin.tv/admni/extensions \
    -H "content-type: application/json" \
    -d "${D_PARAM}" \
  > ${FOLDER_EXTENSIONS_METADATA}json/extension_logs_${i}.json
done

for (( i=1; i<=$NUM_API_REQUEST; i++ ))
do
  echo "processing the file: extension_logs_${i}.json"
  node $JS_FILENAME_GET_RELEASED_EXTENSIONS_LATEST ${FOLDER_EXTENSIONS_METADATA}json/extension_logs_${i}.json 'sql'>>$SQL_FILENAME_EXTENSION_LOG
  node $JS_FILENAME_GET_RELEASED_EXTENSIONS_LATEST ${FOLDER_EXTENSIONS_METADATA}json/extension_logs_${i}.json 'csv'>>$CSV_FILENAME_RELEASED_EXTENSIONS
done


# Do some last step formatting of the .sql file
# Remove last line of file using bash  https://stackoverflow.com/questions/4881930/remove-the-last-line-from-a-file-in-bash
cp $SQL_FILENAME_EXTENSION_LOG temp.sql
sed '$ d' temp.sql > $SQL_FILENAME_EXTENSION_LOG
rm -f temp.sql
# Add parentheses and semi colons as needed to close the query
echo "$paren_end$new_line$paren_end;">>$SQL_FILENAME_EXTENSION_LOG



#remove duplicates records in csv file
awk '!a[$0]++' $CSV_FILENAME_RELEASED_EXTENSIONS > placeholder.csv
cat placeholder.csv > $CSV_FILENAME_RELEASED_EXTENSIONS
rm -rf placeholder.csv



# Run .sql file to add the released extensions to the table
echo "RUNNING SQL CODE AND UPLOADING RELEASED EXTENSIONS DATA"
psql -h tahoe-tap.community-data.twitch.a2z.com -U twitcher -d product -p 5439 -a -f $SQL_FILENAME_EXTENSION_LOG


# Ping slack channel when done
LOGIN="yanghung" #CHANGE YOUR LOGIN
slack_channel_query_status="https://hooks.slack.com/services/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" #PINGS query-status channel in slack

curl --silent -X POST --data-urlencode "payload={
\"text\": \"
   Hi @$LOGIN the script \`00_cron_job_released_extensions.sh\` finished. \n (NOTE: This is a message from the *rstudio* server)
 \"
, \"link_names\": 1, \"mrkdwn\": true
}" $slack_channel_query_status
