DELETE FROM dx_metadata.all_extensions_latest;

INSERT INTO dx_metadata.all_extensions_latest

WITH


--note: this would potentially return multiple rows for the same extension_id
--since you can have multiple extension_version for a given extension_id
all_ext_metadata AS (
  SELECT *
  FROM dx_metadata.extensions_metadata_everything
  WHERE the_date = DATE_TRUNC('day', (SYSDATE - INTERVAL '7 hours')) --take the latest day
)

--pull the latest extension version for released extensions, this becomes a match key pair
, released_extensions AS (
  SELECT extension_id, MAX(extension_version) AS extension_version
  FROM all_ext_metadata
  WHERE extension_state = 'Released'
  GROUP BY 1
)

--pull the latest extension version for non released extensions, this becomes a different match key pair
, non_released_extensions AS (
  SELECT extension_id, MAX(extension_version) AS extension_version
  FROM all_ext_metadata
  WHERE extension_state != 'Released'
  GROUP BY 1
)

-- if an extension_id has a `Released` record, use that match key pair from "released_extensions" CTE as the metadata first
--, otherwise use the match key pair from "non_released_extensions" CTE as the metadata
, max_extension_version AS (
  SELECT NVL(re.extension_id, nre.extension_id) AS extension_id, NVL(re.extension_version, nre.extension_version) AS latest_extension_version
  FROM released_extensions AS re
  FULL OUTER JOIN non_released_extensions AS nre ON re.extension_id = nre.extension_id
)

--get all the relevant metadata for the latest record
, latest_extension_data AS (
  SELECT base.extension_id, base.latest_extension_version AS extension_version, all_meta.extension_state
    , all_meta.extension_name, all_meta.extension_category_id, all_meta.extension_category_name
    , all_meta.extension_support_email, all_meta.extension_url
    , all_meta.is_bits_enabled, all_meta.is_overlay_enabled, all_meta.is_panel_enabled
    , all_meta.is_component_enabled, all_meta.is_mobile_enabled, all_meta.is_chat_enabled
    , all_meta.is_whitelisted_extension, all_meta.whitelist_channels
  FROM max_extension_version AS base
  LEFT JOIN all_ext_metadata AS all_meta ON
    base.extension_id = all_meta.extension_id
    AND base.latest_extension_version = all_meta.extension_version
)

, final_data AS (
  SELECT * FROM latest_extension_data
)


SELECT * FROM final_data
;
