import gspread
import boto3
import json
import sys
from oauth2client.service_account import ServiceAccountCredentials
import requests
import time
import s

def send_slack_message(message):
    """ Builds the json object to POST into a slack webhook. """
    slack_url='https://hooks.slack.com/services/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'
    payload = {"text":"","link_names":1,"mrkdwn":True}
    payload['text'] = message
    requests.post(slack_url,data=json.dumps(payload),headers={'Content_Type': 'application/json'})

def write(json_blob,gc,s3,counter):
    data = json.loads(json_blob)
    link = data['link']
    sheet_name = data['write_sheet']
    queries = data['queries']
    sheet = gc.open_by_url(link).worksheet(sheet_name)

    print('Writing into {}'.format(sheet_name))

    #Build out the files that are in the s3 bucket.
    query_files = s3.list_objects(Bucket='query-to-googlesheet')
    if 'Contents' not in query_files.keys():
        query_csv = []
    else:
        query_csv = [i['Key'] for i in query_files['Contents']]


    # These counters are used when the worksheet is updated at certain cells.
    row_counter = 1
    column_counter = 1

    # This is used so that you won't need to download a file in order to read it.
    s3 = boto3.resource('s3')

    # Problem: Hitting resource limit really quickly --> 100 writes in 100 seconds

    for query in queries:

        # If the filename is not in the list of files in the s3 bucket, print out an error.
        filename = '{}.csv'.format(query).strip()
        if filename not in query_csv:
            print('Error with {}'.format(filename))
            continue

        # Lines will contain all of the info that was stored in the s3 file without needing to download it.
        lines = s3.Object('query-to-googlesheet' , filename).get()['Body'].read().decode('utf-8').split('\n')
        for line in lines:

            # Each line, change column_counter back to the 1st entry.
            column_counter = 1
            """line = line.split(',')
            for cell in line:
                sheet.update_cell(row_counter,column_counter,cell)
                column_counter += 1"""
            if counter >= 90:
                print('Waiting')
                time.sleep(100)
                counter = 0
            sheet.update_cell(row_counter,column_counter,line)
            row_counter += 1
            counter += 1
        row_counter += 1
    return counter



if __name__ == '__main__':
    gc = s.getGC()

    s3 = boto3.client('s3')

    # Retrieving JSON Blob as command line argument and parsing it to get the information needed.
    json_blob = sys.argv[-1]
    data = json.loads(json_blob)
    link = data['link']
    sheet_name = data['write_sheet']
    queries = data['queries']
    sheet = gc.open_by_url(link).worksheet(sheet_name)

    # Build out the files that are in the s3 bucket.
    query_files = s3.list_objects(Bucket='query-to-googlesheet')
    if 'Contents' not in query_files.keys():
        query_csv = []
    else:
        query_csv = [i['Key'] for i in query_files['Contents']]


    # These counters are used when the worksheet is updated at certain cells.
    row_counter = 1
    column_counter = 1

    # This is used so that you won't need to download a file in order to read it.
    s3 = boto3.resource('s3')

    # Problem: Hitting resource limit really quickly --> 100 writes in 100 seconds

    for query in queries:

        # If the filename is not in the list of files in the s3 bucket, print out an error.
        filename = '{}.csv'.format(query).strip()
        if filename not in query_csv:
            print('Error with {}'.format(filename))
            continue

        # Lines will contain all of the info that was stored in the s3 file without needing to download it.
        lines = s3.Object('query-to-googlesheet' , filename).get()['Body'].read().decode('utf-8').split('\n')
        for line in lines:

            # Each line, change column_counter back to the 1st entry.
            column_counter = 1
            """line = line.split(',')
            for cell in line:
                sheet.update_cell(row_counter,column_counter,cell)
                column_counter += 1"""
            sheet.update_cell(row_counter,column_counter,line)
            row_counter += 1
        row_counter += 1

    send_slack_message('Hi @{} {} finished uploading.'.format(data['user'],data['write_sheet']))
    print('{} Finished running'.format(data['write_sheet']))

