DROP FUNCTION f_get_content_mode(varchar, varchar, varchar, boolean) CASCADE;

-- Input: Broadcaster software as text, vod_type as text, content_mode as text, live as boolean.
-- Output: primary and secondary content modes eg 'vodcast upload' or 'live stream'
-- Note: this is intended to be used for reporting purposes when summing raw MW.
-- This does not enforce consistency with backend data from Jax.
create function public.f_get_content_mode(
    broadcaster_software varchar(max),
    vod_type varchar(max),
    content_mode varchar(max),
    live boolean
)
returns varchar(max)
stable
as $$
  select
  case -- the order matters!
    -- vodcast: broadcaster_software like 'watch_party' or 'vodcast'
    when f_is_vodcast_bcsw($1)
      then 'vodcast ' + f_get_vod_type($2)
    -- playlist: non-vodcast and content_mode=playlist, deprecated in 2017
    when nvl($3,'') = 'playlist'
      then 'playlist ' + f_get_vod_type($2)
    -- live: non-vodcast and non-playlist and live is true
    when $4 = true
      then 'live stream'
    -- vod: non-vodcast and non-playlist and live false
    when $4 = false
      then 'vod ' + f_get_vod_type($2)
    -- vod: non-vodcast and non-playlist and live null and correct vod_type
    when f_is_correct_vod_type($2)
      then 'vod ' + $2
    -- live: non-vodcast and non-playlist and live null and bad/missing vod type
    when not f_is_correct_vod_type($2)
      then 'live stream'
    -- fallback
    else 'unknown unknown'
    end
$$ language sql;
