-- Input: pass url column in text
-- Output: the page from the url

-- Notes: This will only work for extension install and activate button click events since they can happen on one of these pages.



create function public.f_sql_get_extension_page (url varchar(max))
  returns varchar(max)
stable
as $$
   select
  case
  when lower($1) like 'https://www.twitch.tv/ext/search%' then 'Extensions Search'
  when lower($1) like 'https://www.twitch.tv/ext/categories/%' then 'Category Page'
  when lower($1) like 'https://www.twitch.tv/%/dashboard/extensions' then 'Discovery Page'
  when lower($1) like 'https://www.twitch.tv/%/dashboard/settings/revenue' then 'Revenue Dashboard Page'
  when lower($1) like 'https://www.twitch.tv/%/dashboard/live%' then 'Live Dashboard Page'
  when lower($1) like 'https://www.twitch.tv/%/dashboard/extensions/manage' then 'Extension Manager Page'
  when lower($1) like 'https://www.twitch.tv/ext/%' then 'Extension Details Page'
  when lower($1) like 'https://www.twitch.tv/%' then 'Channel Page'
  else 'other'
   end
$$ language sql;
