
DROP FUNCTION f_get_video_product_type(varchar, varchar, varchar, boolean) CASCADE;

-- Input: Broadcaster software as text, vod_type as text, content_mode as text, live as boolean.
-- Output: This dimension indicates how user watched the content i.e. through live stream, vodcast or actually on demand (vod)
-- Possible values: ‘live’, ‘vod’, ‘vodcast’
-- Note: this is intended to be used for reporting purposes when summing raw MW.
-- This does not enforce consistency with backend data from Jax.
create function public.f_get_video_product_type(
    broadcaster_software varchar(max),
    vod_type varchar(max),
    content_mode varchar(max),
    live boolean
)
returns varchar(max)
stable
as $$
 select
  case -- the order matters!
    -- vodcast: broadcaster_software like 'watch_party' or 'vodcast'
    when f_is_vodcast_bcsw($1)
      then 'vodcast'
    -- playlist: non-vodcast and content_mode=playlist, deprecated in 2017
    when nvl($3,'') = 'playlist'
      then 'vod'
    -- live: non-vodcast and non-playlist and live is true
    when $4 = true
      then 'live'
    -- vod: non-vodcast and non-playlist and live false
    when $4 = false
      then 'vod'
    -- vod: non-vodcast and non-playlist and live null and correct vod_type
    when f_is_correct_vod_type($2)
      then 'vod'
    -- live: non-vodcast and non-playlist and live null and bad/missing vod type
    when not f_is_correct_vod_type($2)
      then 'live'
    -- fallback
    else 'unknown'
    end
$$ language sql;
