
# List all buckets in s3 for dx-data aws account
aws s3 ls --profile s3_full_access

# List stuff in a specific s3 folder
THE_FOLDER_NAME=s3://twitch-dx-data
aws s3 ls --profile s3_full_access ${THE_FOLDER_NAME} --recursive
aws s3 ls --profile s3_full_access ${THE_FOLDER_NAME} --recursive --human-readable --summarize


function s3_ll {
  THE_FOLDER_NAME=$1
  if [[ ! -z "$1" ]]; then
    printf "Showing the files in the \"bucket\" ${BYellow}s3://${THE_FOLDER_NAME}${COLOR_RESET}:"$'\n'
    aws s3 ls --profile s3_full_access s3://${THE_FOLDER_NAME} --recursive --human-readable --summarize
  elif [[ -z "$1" ]]; then
    printf "You did not specify a S3 \"bucket\", so showing all the \"buckets\" you have below:"$'\n'
    aws s3 ls --profile s3_full_access --recursive --human-readable
  else
    printf "This should not happen"
  fi
}

# s3://twitch-dx-data/extensions_metadata/0a_all_extensions_2019_04_24.csv
function s3_head_tail {
  THE_FULL_PATH=$1
  printf $'\n'$'\n'"Showing the top rows of your file ${BYellow}${THE_FULL_PATH}${COLOR_RESET}:"$'\n'
  aws s3 cp --quiet --profile s3_full_access ${THE_FULL_PATH} - | head
  printf $'\n'$'\n'"Showing the bottom rows of your file ${BYellow}${THE_FULL_PATH}${COLOR_RESET}:"$'\n'
  aws s3 cp --quiet --profile s3_full_access ${THE_FULL_PATH} - | tail
}

# Copy one file from local to specific s3 folder
S3_FOLDER_NAME=s3://twitch-dx-data/extensions_metadata/
LOCAL_FOLDER_NAME=/home/rollups/extensions_metadata/all_extensions/
LOCAL_FILE_NAME=0a_all_extensions_2019_04_24.csv
aws s3 cp --profile s3_full_access ${LOCAL_FOLDER_NAME}/${LOCAL_FILE_NAME} ${S3_FOLDER_NAME}

find . -name "*.json" | xargs grep -E 'jk6sz43il0oyzfl8xipehqacw8bchv'




# Create Folder (ie mkdir) in S3 console command
# https://stackoverflow.com/questions/36837975/how-to-create-folder-on-s3-from-ec2-instance
aws s3api put-object --profile s3_full_access --bucket twitch-dx-data --key test_folder/


date
#echo current time
echo $(date +'%Y-%m-%d %H:%M:%S')
