-- DEPRECATED DEFINITION
-- [from dallas tester]
-- pull current input metric -  Our main input metric is % of applications with more than 5 oAuthed users.
-- N% = X/Y of applications are currently in this state.

-- X = # of `client_id` where we have >=5 user_id that completed oauth
-- Y = # of `client_id` that have >=1 user_id that completed oauth

WITH
the_timeframe AS (
  SELECT '2017-01-01 00:00:00' AS start_time
)

, app_user_oauth AS (
SELECT client_id, COUNT(DISTINCT user_id) AS num_users_request_oauth
FROM logs.oauth_authorize
WHERE
"time" >= (SELECT start_time FROM the_timeframe)
GROUP BY 1
)


SELECT x::FLOAT/y::FLOAT AS percent_apps, x::FLOAT, y::FLOAT
FROM
(
SELECT SUM(CASE WHEN num_users_request_oauth>=5 THEN 1 ELSE 0 END) AS x
, SUM(CASE WHEN num_users_request_oauth>=1 THEN 1 ELSE 0 END) AS y
FROM app_user_oauth
) AS final
