-- 1a. user creates game dev’s id
-- 1b. user creates twitch id
-- 2. user links their twitch id to the game dev id (drops campaign)
-- 3. user watches the channel
-- 4. data is sent from twitch to game dev saying “these users watched”
-- 5. game dev has own process to reward the user

-- get the users where the time difference between 1b and 2 is within 24 hrs

WITH

apps_list AS (
SELECT 'saactj7j6kcf5ogqcv4n6zsgx32sy41' AS client_id
UNION ALL SELECT 'pdw11y2y3bdtadcyknd791u6mqrqry' AS client_id
UNION ALL SELECT 'nmt37qblda36pvonovdkbopzfzw3wlq' AS client_id
UNION ALL SELECT 'mlpjzuoqffzsj3obfbtwhlxeuepuvh' AS client_id
UNION ALL SELECT 'fnkzwj509yyr3u76ltk57nzhkhdd8g' AS client_id
UNION ALL SELECT 't11hnc4bu1xj2yljd1t4dbruut4srkf' AS client_id
UNION ALL SELECT 'mfieqnayt3vog4ucp023xjmdcoh35nu' AS client_id
UNION ALL SELECT 'dw1segz99n0yo3y4lngcph092b232v1' AS client_id
)

, the_timeframe AS (
SELECT '2017-01-01' AS range_start, '2017-09-01' AS range_end
)

, twitch_create_date AS (
SELECT user_id, MIN(created_on) AS time_create_twitch_account
FROM analysis.sitedb_users
--WHERE user_id = 155528531
GROUP BY 1
)

, twitch_link_date AS (
SELECT user_id, client_id, MIN(time) AS time_link_twitch_account
FROM logs.oauth_authorize
WHERE client_id IN (SELECT client_id FROM apps_list)
AND time>=(SELECT range_start FROM the_timeframe) AND time<(SELECT range_end FROM the_timeframe)
--AND user_id = 155528531
GROUP BY 1,2
)

, user_segment AS (
SELECT *
FROM (
SELECT tld.user_id, tld.client_id, tld.time_link_twitch_account, tcd.time_create_twitch_account
, DATEDIFF(hours, tcd.time_create_twitch_account, tld.time_link_twitch_account) AS hours_between_link_create
FROM twitch_link_date AS tld
LEFT JOIN twitch_create_date AS tcd ON tld.user_id = tcd.user_id
)
WHERE hours_between_link_create <= 24 --6 hrs or 24 hrs?
)

SELECT DATE_TRUNC('month', time_link_twitch_account) AS the_month, client_id, COUNT(DISTINCT user_id) AS num_users
FROM user_segment
GROUP BY 1,2
ORDER BY 2,1
