-- get for each extension, the unique device count that got exposed (extension_render) to each released extension_id
-- then calculate the overall average of those numbers


WITH
the_timeframe AS (
SELECT '2017-10-01 00:00:00' AS start_time
, '2017-11-01 00:00:00' AS end_time
)

, extension_render_log AS (
SELECT extension_id, COUNT(DISTINCT device_id) AS num_devices
FROM logs.extension_render AS base
WHERE base.time>=(SELECT start_time FROM the_timeframe)
AND base.time<(SELECT end_time FROM the_timeframe)
GROUP BY 1
)

SELECT REPLACE(rel.extension_name, ',','') AS extension_name, REPLACE(rel.extension_author_name, ',','') AS extension_author_name, rel.extension_url, rel.extension_id, erl.num_devices
FROM extension_render_log AS erl
RIGHT JOIN analysis.released_extensions_latest AS rel ON erl.extension_id = rel.extension_id
