
-- Get a lookup table of campaign_id, notification_id, and target_url

WITH
notification_sent_log AS (
SELECT MIN(time) AS min_time, MAX(time) AS max_time, campaign_id, notification_id
FROM logs.notification_sent_server
WHERE notification_type='dropsavailable'
GROUP BY 3,4
)
, notification_interaction_log AS (
SELECT notification_id, target_url
FROM logs.notification_interaction
WHERE notification_type='dropsavailable'
AND target_url IS NOT NULL
GROUP BY 1,2
)

SELECT min_time, max_time, campaign_id, target_url
FROM (
SELECT sent.min_time, sent.max_time, sent.campaign_id, sent.notification_id, interact.target_url
FROM notification_sent_log AS sent
LEFT JOIN notification_interaction_log AS interact ON sent.notification_id=interact.notification_id
)
GROUP BY 1,2,3,4
