WITH
the_constants AS (
SELECT '2017-05-24 13:00:00'::timestamp AS start_time
--SELECT '2017-09-06 16:00:00'::timestamp AS start_time_ga
--, '2017-10-03 13:39:00'::timestamp AS end_time
--, '2017-09-22 15:00:00'::timestamp AS end_time
--, DATE_TRUNC('month', SYSDATE)::TIMESTAMP - INTERVAL '1 seconds' AS end_time_last_month
, '2017-11-06 15:19:00'::TIMESTAMP AS end_time_this_month
--, '2017-11-16 15:24:00'::TIMESTAMP  AS end_time_this_month
--, DATE_TRUNC('month', SYSDATE)::TIMESTAMP + INTERVAL '1 month' - INTERVAL '1 seconds' AS end_time_this_month
)


-- activation_by_channel
, activate_logs AS (
SELECT * FROM (
SELECT *, MAX(last_time_activate) OVER (PARTITION BY user_id, extension_id) AS max_last_time_activate
FROM (
SELECT extension_id, extension_version, user_id, MAX(time) AS last_time_activate
FROM logs.extension_activate
WHERE time>=(SELECT start_time FROM the_constants) AND time<=(SELECT end_time_this_month FROM the_constants)
GROUP BY 1,2,3
))
WHERE last_time_activate = max_last_time_activate
)
-- deactivation by channel
, deactivate_logs AS (
SELECT extension_id, user_id, MAX(time) AS last_time_deactivate
FROM logs.extension_deactivate
WHERE time>=(SELECT start_time FROM the_constants) AND time<=(SELECT end_time_this_month FROM the_constants)
GROUP BY 1,2
)
--uninstall by channel is an implicit deactivate
, uninstall_logs AS (
SELECT extension_id, user_id, MAX(time) AS last_time_uninstall
FROM logs.extension_uninstall
WHERE time>=(SELECT start_time FROM the_constants) AND time<=(SELECT end_time_this_month FROM the_constants)
GROUP BY 1,2
)
--deletion by developer is an implicit deactivate across all channels
, delete_logs AS (
SELECT extension_id, extension_version, MAX(time) AS last_time_delete
FROM logs.extension_delete
--WHERE extension_id!='zfh2irvx2jb4s60f02jq0ajm8vwgka' OR extension_version!='1.0.7' --exclude Steamlabs 1.0.7 uninstall record since it was removing a much older version
GROUP BY 1,2
)
--join the logs
, the_logs AS (
SELECT base.extension_id, base.extension_version, base.user_id, base.last_time_activate
, deact.last_time_deactivate, unin.last_time_uninstall, del.last_time_delete
FROM activate_logs AS base
LEFT JOIN deactivate_logs AS deact ON base.extension_id = deact.extension_id AND base.user_id = deact.user_id
LEFT JOIN uninstall_logs AS unin ON base.extension_id = unin.extension_id AND base.user_id = unin.user_id
LEFT JOIN delete_logs AS del ON base.extension_id = del.extension_id AND base.extension_version=del.extension_version
)

, the_logs_final AS (
SELECT *
, CASE
WHEN last_time_deactivate >= last_time_activate AND last_time_deactivate IS NOT NULL THEN 0
WHEN last_time_uninstall >= last_time_activate AND last_time_uninstall IS NOT NULL THEN 0
WHEN last_time_delete >= last_time_activate AND last_time_delete IS NOT NULL THEN 0
ELSE 1 END AS flag_is_activated
FROM the_logs
)

SELECT COUNT(DISTINCT base.user_id) AS channels, COUNT(1) AS active_extensions, COUNT(1)::FLOAT / COUNT(DISTINCT base.user_id)::FLOAT AS extensions_per_channel
FROM the_logs_final AS base
WHERE flag_is_activated=1
