--get list of twitch prime subs, their user_id and the date they signed up
-- only for those that sign up for twitch within 24 hrs of account creation


WITH
nov_tp AS (
SELECT purchaser_id AS user_id, received_on::TIMESTAMP AS prime_signup_date
FROM analysis.sitedb_subscription_payments_raw
WHERE ticket_type = 'turbo' AND payment_provider = 'samus'
AND received_on >='2017-11-01 00:00:00'
)


early_tp_users AS (
SELECT *
FROM
(
SELECT base.*, su.created_on::TIMESTAMP
FROM nov_tp AS base
LEFT JOIN analysis.sitedb_users AS su ON base.user_id = su.user_id
)
WHERE prime_signup_date - INTERVAL '24 hours' <= created_on
)

SELECT * FROM early_tp_users
