-- Create log table when anyone views extension mgr page, views extensions detail page, installs extension, or activates extension

DROP TABLE IF EXISTS    analysis.dsds145_0;
CREATE TABLE    analysis.dsds145_0    AS

WITH
the_constants AS (
SELECT
'2017-09-06 00:00:00'::TIMESTAMP AS start_time
, '2017-11-29 00:00:00'::TIMESTAMP AS end_time
, 'https://www.twitch.tv/%/dashboard/extensions' AS url_mgr_wildcard
, 'https://www.twitch.tv/ext/%-%' AS url_ext_wildcard
)

, funnel1 AS (
SELECT "time", user_id, url
, CASE WHEN url LIKE (SELECT url_mgr_wildcard FROM the_constants) THEN ''
WHEN url LIKE (SELECT url_ext_wildcard FROM the_constants) THEN SPLIT_PART(SUBSTRING(url,27,999),'-',1)
ELSE '-1 ERROR' END AS extension_id
, CASE WHEN url LIKE (SELECT url_mgr_wildcard FROM the_constants) THEN '0. view_extension_manager'
WHEN url LIKE (SELECT url_ext_wildcard FROM the_constants) THEN '1. view_extension_detail'
ELSE '-1 ERROR' END AS action
FROM logs.pageview AS base
WHERE base.time>=(SELECT start_time FROM the_constants) AND base.time<(SELECT end_time FROM the_constants)
AND (base.url LIKE (SELECT url_mgr_wildcard FROM the_constants) OR base.url LIKE (SELECT url_ext_wildcard FROM the_constants))
)

, funnel2 AS (
SELECT "time", user_id, '' AS url, extension_id, '2. install_extension' AS action
FROM logs.extension_install AS base
WHERE base.time>=(SELECT start_time FROM the_constants) AND base.time<(SELECT end_time FROM the_constants)
)

, funnel3 AS (
SELECT "time", user_id, '' AS url, extension_id, '3. activate_extension' AS action
FROM logs.extension_activate AS base
WHERE base.time>=(SELECT start_time FROM the_constants) AND base.time<(SELECT end_time FROM the_constants)
)

, final_funnel AS (
SELECT * FROM funnel1
UNION ALL SELECT * FROM funnel2
UNION ALL SELECT * FROM funnel3
)

, final_data AS (
SELECT base.*
, dl.extension_type, rel.extension_anchor
, rel.extension_name, rel.extension_author_name
, CASE WHEN spc.user_id IS NULL THEN 0 ELSE 1 END AS flag_is_partner
, CASE WHEN ca.channel_id IS NULL THEN 0 ELSE 1 END AS flag_is_affiliate
FROM final_funnel AS base
LEFT JOIN analysis.released_extensions_latest AS rel ON base.extension_id = rel.extension_id
LEFT JOIN analysis.sitedb_partner_channels AS spc ON base.user_id = spc.user_id
LEFT JOIN analysis.current_affiliates AS ca ON base.user_id = ca.channel_id
LEFT JOIN analysis.dsds145_lookup AS dl ON base.extension_id = dl.extension_id
)

SELECT *
, CASE WHEN flag_is_partner=1 AND flag_is_affiliate=1 THEN 'ERROR - BOTH PARTNER AND AFFILIATE'
WHEN flag_is_partner=1 AND flag_is_affiliate=0 THEN 'partner'
WHEN flag_is_partner=0 AND flag_is_affiliate=1 THEN 'affiliate'
WHEN flag_is_partner=0 AND flag_is_affiliate=0 THEN 'regular'
ELSE 'ERROR - SHOULD NOT HAPPEN' END AS channel_status
FROM final_data
WHERE action='0. view_extension_manager' OR extension_name IS NOT NULL
;
