
WITH
the_constants AS (
SELECT
'2017-10-01 00:00:00'::TIMESTAMP AS start_date
, '24u62kim5mn0slhwigdt7v4ybkwef5' AS the_extension_id
)


SELECT DATE(time) AS the_day, COUNT(1) AS num_render, SUM(1) AS num_render2
FROM logs.extension_click AS base
WHERE time>=(SELECT start_date FROM the_constants)
AND extension_id = (SELECT the_extension_id FROM the_constants)
AND base.extension_mode NOT IN ('dashboard', 'config')                                        --make sure this is extensions from channel page
AND base.extension_anchor IN ('video_overlay', 'panel')                                       --either video or panel
--AND base.pct_view_visible >= 75
GROUP BY 1
ORDER BY 1
