WITH
latest_time AS (
SELECT COALESCE(DATE_TRUNC('day', MAX(the_day)), '2017-09-06') as latest_day
FROM rollups.extension_daily_stats_non_version
WHERE the_day < SYSDATE
)
, the_timeframe AS (
SELECT latest_day - INTERVAL '2 days' AS range_start
, DATE_TRUNC('day', SYSDATE) AS range_end
FROM latest_time
)
, the_constants_extension_type AS (
SELECT 'video_overlay' AS extension_type
UNION ALL SELECT 'panel' AS extension_type
)
, the_constants_extension_mode_exclude AS (
SELECT 'dashboard' AS extension_mode
UNION ALL SELECT 'config' AS extension_mode
)

, extension_render_log AS (
SELECT
DATE_TRUNC('day', render.time) AS the_day, render.extension_id, render.extension_anchor AS extension_type
, COUNT(1) AS num_events_render
, COUNT(DISTINCT render.device_id) AS unique_devices_render, COUNT(DISTINCT render.login_id) AS unique_logins_render, COUNT(DISTINCT render.channel_id) AS unique_channels_render
FROM logs.extension_render AS render
WHERE
render.time>=(SELECT range_start FROM the_timeframe) AND render.time<(SELECT range_end FROM the_timeframe)    --within the time range
AND render.extension_mode NOT IN (SELECT extension_mode FROM the_constants_extension_mode_exclude)            --make sure this is extensions from channel page
AND render.extension_anchor IN (SELECT extension_type FROM the_constants_extension_type)                      --either video or panel extension
GROUP BY 1,2,3
)

, extension_view_log AS (
SELECT
DATE_TRUNC('day', view.time) AS the_day, view.extension_id, view.extension_anchor AS extension_type
, COUNT(1) AS num_events_view
, COUNT(DISTINCT view.device_id) AS unique_devices_view, COUNT(DISTINCT view.login_id) AS unique_logins_view, COUNT(DISTINCT view.channel_id) AS unique_channels_view
FROM logs.extension_view AS view
WHERE
view.time>=(SELECT range_start FROM the_timeframe) AND view.time<(SELECT range_end FROM the_timeframe)      --within the time range
AND view.extension_mode NOT IN (SELECT extension_mode FROM the_constants_extension_mode_exclude)            --make sure this is extensions from channel page
AND view.extension_anchor = 'panel'                                                                         --only panel extensions since video extensions are viewed by default
AND view.pct_view_visible >= 75                                                                             --must be 75% visible to count as view
GROUP BY 1,2,3
)

, extension_mouse_log AS (
SELECT
DATE_TRUNC('day', mouse.time) AS the_day, mouse.extension_id, mouse.extension_anchor AS extension_type
, COUNT(1) AS num_events_mouse
, COUNT(DISTINCT mouse.device_id) AS unique_devices_mouse, COUNT(DISTINCT mouse.login_id) AS unique_logins_mouse, COUNT(DISTINCT mouse.channel_id) AS unique_channels_mouse
FROM logs.extension_mouseenter AS mouse
WHERE
mouse.time>=(SELECT range_start FROM the_timeframe) AND mouse.time<(SELECT range_end FROM the_timeframe)   --within the time range
AND mouse.extension_mode NOT IN (SELECT extension_mode FROM the_constants_extension_mode_exclude)           --make sure this is extensions from channel page
AND mouse.extension_anchor IN (SELECT extension_type FROM the_constants_extension_type)                     --either video or panel extension
GROUP BY 1,2,3
)

, extension_click_log AS (
SELECT
DATE_TRUNC('day', click.time) AS the_day, click.extension_id, click.extension_anchor AS extension_type
, COUNT(1) AS num_events_click
, COUNT(DISTINCT click.device_id) AS unique_devices_click, COUNT(DISTINCT click.login_id) AS unique_logins_click, COUNT(DISTINCT click.channel_id) AS unique_channels_click
FROM logs.extension_click AS click
WHERE
click.time>=(SELECT range_start FROM the_timeframe) AND click.time<(SELECT range_end FROM the_timeframe)   --within the time range
AND click.extension_mode NOT IN (SELECT extension_mode FROM the_constants_extension_mode_exclude)           --make sure this is extensions from channel page
AND click.extension_anchor IN (SELECT extension_type FROM the_constants_extension_type)                     --either video or panel extension
GROUP BY 1,2,3
)

, extension_final_log AS (
SELECT erl.the_day, erl.extension_id, erl.extension_type
, erl.num_events_render
, CASE WHEN erl.extension_type='panel' THEN evl.num_events_view WHEN erl.extension_type='video_overlay' THEN erl.num_events_render ELSE 0 END AS num_events_view
, eml.num_events_mouse, ecl.num_events_click
, erl.unique_devices_render
, CASE WHEN erl.extension_type='panel' THEN evl.unique_devices_view WHEN erl.extension_type='video_overlay' THEN erl.unique_devices_render ELSE 0 END AS unique_devices_view
, eml.unique_devices_mouse, ecl.unique_devices_click
, erl.unique_logins_render
, CASE WHEN erl.extension_type='panel' THEN evl.unique_logins_view WHEN erl.extension_type='video_overlay' THEN erl.unique_logins_render ELSE 0 END AS unique_logins_view
, eml.unique_logins_mouse, ecl.unique_logins_click
, erl.unique_channels_render
, CASE WHEN erl.extension_type='panel' THEN evl.unique_channels_view WHEN erl.extension_type='video_overlay' THEN erl.unique_channels_render ELSE 0 END AS unique_channels_view
, eml.unique_channels_mouse, ecl.unique_channels_click
FROM extension_render_log AS erl
LEFT JOIN extension_view_log AS evl ON erl.the_day = evl.the_day AND erl.extension_id = evl.extension_id
LEFT JOIN extension_mouse_log AS eml ON erl.the_day = eml.the_day AND erl.extension_id = eml.extension_id
LEFT JOIN extension_click_log AS ecl ON erl.the_day = ecl.the_day AND erl.extension_id = ecl.extension_id
)

SELECT efl.the_day, efl.extension_id, efl.extension_type
, NVL(efl.num_events_render,0) AS num_events_render, NVL(efl.num_events_view,0) AS num_events_view, NVL(efl.num_events_mouse,0) AS num_events_mouse, NVL(efl.num_events_click,0) AS num_events_click
, NVL(efl.unique_devices_render,0) AS unique_devices_render, NVL(efl.unique_devices_view,0) AS unique_devices_view, NVL(efl.unique_devices_mouse,0) AS unique_devices_mouse, NVL(efl.unique_devices_click,0) AS unique_devices_click
, NVL(efl.unique_logins_render,0) AS unique_logins_render, NVL(efl.unique_logins_view,0) AS unique_logins_view, NVL(efl.unique_logins_mouse,0) AS unique_logins_mouse, NVL(efl.unique_logins_click,0) AS unique_logins_click
, NVL(efl.unique_channels_render,0) AS unique_channels_render, NVL(efl.unique_channels_view,0) AS unique_channels_view, NVL(efl.unique_channels_mouse,0) AS unique_channels_mouse, NVL(efl.unique_channels_click,0) AS unique_channels_click
FROM extension_final_log efl
