--https://docs.google.com/presentation/d/1lsvPXXCAdUhJ1Z21Rjk3SHHxfNjAqdmWsO3fJSEMux0/edit?ts=5a286d66#slide=id.g22f05d5296_0_6

WITH
the_constants AS (
SELECT '2017-11-29 00:00:00'::timestamp AS start_date_m10n--week 48 sunday start, we launched extensions 2017-11-29
, DATE_TRUNC('week', (SYSDATE - INTERVAL '7 hours'))::timestamp + INTERVAL '6 days' - INTERVAL '1 seconds' AS this_week_end_date --this week's end date
, DATE_TRUNC('day', (SYSDATE - INTERVAL '7 hours'))::timestamp - INTERVAL '1 seconds' AS yesterday_end_date
)
, the_lookup AS (
SELECT 'StreamPet' AS extension_name, '3v9falpvk6qw6n5i4okm3xo3bazg8t' AS extension_id, 'B077783CQC' AS asin, 'PET-MEGATREAT-1_2' AS sku, 'P4P7X' AS vendor_code, 'General Workings Inc dba Streamlabs' AS developer_name, 'MegaTreat - Food' AS item_name, 1 AS item_price, 'USD' AS item_currency, '100x more powerful than regular treats.' AS description, 'Consumable' AS item_type, '07339fec-932c-41f7-94da-62aa75b19075' AS adg_product_id
UNION ALL SELECT 'StreamPet' AS extension_name, '3v9falpvk6qw6n5i4okm3xo3bazg8t' AS extension_id, 'B07773KFZD' AS asin, 'PET-MEGATREAT-2' AS sku, 'P4P7X' AS vendor_code, 'General Workings Inc dba Streamlabs' AS developer_name, 'MegaTreat - Toy' AS item_name, 1 AS item_price, 'USD' AS item_currency, '100x more powerful than regular treats.' AS description, 'Consumable' AS item_type, '4c616517-f44e-49d5-a8c7-794e16a6963f' AS adg_product_id
UNION ALL SELECT 'StreamPet' AS extension_name, '3v9falpvk6qw6n5i4okm3xo3bazg8t' AS extension_id, 'B0777LRJRQ' AS asin, 'PET-MEGATREAT-3' AS sku, 'P4P7X' AS vendor_code, 'General Workings Inc dba Streamlabs' AS developer_name, 'MegaTreat - Bed' AS item_name, 1 AS item_price, 'USD' AS item_currency, '100x more powerful than regular treats.' AS description, 'Consumable' AS item_type, '5aeaec98-b459-49b9-b3c1-61a348bfc99d' AS adg_product_id
UNION ALL SELECT 'StreamPet' AS extension_name, '3v9falpvk6qw6n5i4okm3xo3bazg8t' AS extension_id, 'B0777C1MN4' AS asin, 'PET-REVIVE' AS sku, 'P4P7X' AS vendor_code, 'General Workings Inc dba Streamlabs' AS developer_name, 'Revive' AS item_name, 5 AS item_price, 'USD' AS item_currency, 'Revive the channel pet.' AS description, 'Consumable' AS item_type, '3f71bbdb-b354-4045-a825-e6bc0bb76451' AS adg_product_id
UNION ALL SELECT 'Death\'s Door Game' AS extension_name, 'a23mttohd32cjppls8v1p9vr0sb0on' AS extension_id, 'B0777S21FR' AS asin, 'deathsdoor.spirit_one' AS sku, '51GXW' AS vendor_code, 'Shiny Shoe' AS developer_name, '1 Spirit Bomb' AS item_name, 0.99 AS item_price, 'USD' AS item_currency, 'Spirit Bombs, on use, will cause an explosion on screen, add 5 Spirit Energy, and adds to the hype bar.' AS description, 'Consumable' AS item_type, '4bdf66f1-9e32-4412-a553-8b7727f830fd' AS adg_product_id
UNION ALL SELECT 'Death\'s Door Game' AS extension_name, 'a23mttohd32cjppls8v1p9vr0sb0on' AS extension_id, 'B07789XNGC' AS asin, 'deathsdoor.spirit_small' AS sku, '51GXW' AS vendor_code, 'Shiny Shoe' AS developer_name, '11 Spirit Bombs' AS item_name, 10 AS item_price, 'USD' AS item_currency, 'Spirit Bombs, on use, will cause an explosion on screen, add 5 Spirit Energy, and adds to the hype bar.' AS description, 'Consumable' AS item_type, '49e60ceb-01e1-4777-a198-e868acf822cb' AS adg_product_id
UNION ALL SELECT 'Death\'s Door Game' AS extension_name, 'a23mttohd32cjppls8v1p9vr0sb0on' AS extension_id, 'B0777V15QD' AS asin, 'deathsdoor.spirit_big' AS sku, '51GXW' AS vendor_code, 'Shiny Shoe' AS developer_name, '35 Spirit Bombs' AS item_name, 30 AS item_price, 'USD' AS item_currency, 'Spirit Bombs, on use, will cause an explosion on screen, add 5 Spirit Energy, and adds to the hype bar.' AS description, 'Consumable' AS item_type, '27719ef2-ad1f-4b6a-97fe-8d95faf79727' AS adg_product_id
-- UNION ALL SELECT 'Bitfighter' AS extension_name, 'q7b0aysz74xjpuotkreymn6totqc17' AS extension_id, 'B077DXMR3L' AS asin, 'Gold1' AS sku, '' AS vendor_code, 'Opera Event' AS developer_name, 'Gold Package' AS item_name, 100 AS item_price, 'USD' AS item_currency, 'Play Bitfighter with this enhanced Bitfighter package. Includes a permanent buff, and the best selection of equipable and consumable items.' AS description, 'Consumable' AS item_type, '6d68442c-d20a-4ffa-bdb1-d1a5a16aa0ec' AS adg_product_id
-- UNION ALL SELECT 'Bitfighter' AS extension_name, 'q7b0aysz74xjpuotkreymn6totqc17' AS extension_id, 'B077GGHDRH' AS asin, 'Silver1' AS sku, '' AS vendor_code, 'Opera Event' AS developer_name, 'Silver Package' AS item_name, 20 AS item_price, 'USD' AS item_currency, 'Play Bitfighter and increases your odds of getting a Legendary champion, and gives you equippable and consumable items.' AS description, 'Consumable' AS item_type, '7ff77d59-2266-4e8a-8de8-01d3baabf779' AS adg_product_id
-- UNION ALL SELECT 'Bitfighter' AS extension_name, 'q7b0aysz74xjpuotkreymn6totqc17' AS extension_id, 'B077GDY3LM' AS asin, 'Bronze1' AS sku, '' AS vendor_code, 'Opera Event' AS developer_name, 'Bronze Package' AS item_name, 5 AS item_price, 'USD' AS item_currency, 'Play Bitfighter and get increased choices of character and a small buff.' AS description, 'Consumable' AS item_type, '7c3d9ea9-753b-4445-b70d-09c7054fb474' AS adg_product_id
-- UNION ALL SELECT 'Bitfighter' AS extension_name, 'q7b0aysz74xjpuotkreymn6totqc17' AS extension_id, 'B077GFHHR3' AS asin, 'Basic1' AS sku, '' AS vendor_code, 'Opera Event' AS developer_name, 'Basic Bitfighter' AS item_name, 2 AS item_price, 'USD' AS item_currency, 'Play Bitfighter and get increased choices of character and a small buff.' AS description, 'Consumable' AS item_type, '5ee045c7-e605-4f03-9cfa-dd808b4549eb' AS adg_product_id
-- UNION ALL SELECT 'Bitfighter' AS extension_name, 'q7b0aysz74xjpuotkreymn6totqc17' AS extension_id, 'B077GGYMCH' AS asin, 'Consumable1' AS sku, '' AS vendor_code, 'Opera Event' AS developer_name, 'Consumables' AS item_name, 5 AS item_price, 'USD' AS item_currency, 'Consumables for use in Bitfighter' AS description, 'Consumable' AS item_type, '5ff8c16a-2751-4d02-9eb7-b536637b0dbf' AS adg_product_id
-- UNION ALL SELECT 'Bitfighter' AS extension_name, 'q7b0aysz74xjpuotkreymn6totqc17' AS extension_id, 'B077GGN952' AS asin, 'Armor1' AS sku, '' AS vendor_code, 'Opera Event' AS developer_name, 'Armor Package' AS item_name, 10 AS item_price, 'USD' AS item_currency, 'Equipable Armor for use in Bitfighter' AS description, 'Consumable' AS item_type, 'f46f1f0b-05e5-42b3-be21-c59ca79bffd3' AS adg_product_id
-- UNION ALL SELECT 'Bitfighter' AS extension_name, 'q7b0aysz74xjpuotkreymn6totqc17' AS extension_id, 'B077GHHHPD' AS asin, 'Weapon1' AS sku, '' AS vendor_code, 'Opera Event' AS developer_name, 'Weapon Package' AS item_name, 25 AS item_price, 'USD' AS item_currency, 'Equipable Weapon for use in Bitfighter' AS description, 'Consumable' AS item_type, '0693d3cc-0636-4361-8489-9abff68f2af4' AS adg_product_id
UNION ALL SELECT 'Kappa Pet' AS extension_name, 'thc81rw29g1gsukw0f4mfeczxltio3' AS extension_id, 'B077H6VFHQ' AS asin, 'kp_powerup_boost_solo_small' AS sku, '1RH6T' AS vendor_code, 'Porcupine TV' AS developer_name, 'Love Boost' AS item_name, 0.99 AS item_price, 'USD' AS item_currency, 'Get a love boost for a short period of time!' AS description, 'Consumable' AS item_type, '646cfd47-e78d-4f58-aaca-062513c646de' AS adg_product_id
UNION ALL SELECT 'Kappa Pet' AS extension_name, 'thc81rw29g1gsukw0f4mfeczxltio3' AS extension_id, 'B077H89RZG' AS asin, 'kp_powerup_powerup_autoclicker1' AS sku, '1RH6T' AS vendor_code, 'Porcupine TV' AS developer_name, 'Auto Love' AS item_name, 5 AS item_price, 'USD' AS item_currency, 'Acquire a love machine to help you support the pet automatically' AS description, 'Consumable' AS item_type, '9aa19a49-e620-4792-899c-2d39864f3179' AS adg_product_id
UNION ALL SELECT 'Kappa Pet' AS extension_name, 'thc81rw29g1gsukw0f4mfeczxltio3' AS extension_id, 'B077H7VLLP' AS asin, 'kp_powerup_boost_community_small' AS sku, '1RH6T' AS vendor_code, 'Porcupine TV' AS developer_name, 'Community Boost!' AS item_name, 4.99 AS item_price, 'USD' AS item_currency, 'Everybody gets a boost for a short period of time!' AS description, 'Consumable' AS item_type, 'f48e4c11-59ca-49da-8bca-aedada527da5' AS adg_product_id
UNION ALL SELECT 'Kappa Pet' AS extension_name, 'thc81rw29g1gsukw0f4mfeczxltio3' AS extension_id, 'B077H7N22Q' AS asin, 'kp_powerup_boost_solo_ultimate' AS sku, '1RH6T' AS vendor_code, 'Porcupine TV' AS developer_name, 'Ultimate Love' AS item_name, 9.99 AS item_price, 'USD' AS item_currency, 'Get an XP boost forever!' AS description, 'Durable' AS item_type, 'c80d21ea-4110-496e-9df2-74b1a418f31c' AS adg_product_id
-- UNION ALL SELECT 'Rita Test Extension 1' AS extension_name, 'u4xkb2t4a2v6ex9f465sghrpk458a2' AS extension_id, 'B075NSWZ3V' AS asin, 'rita_test_durable_sku' AS sku, 'W5U1V' AS vendor_code, 'Test Extension Developer' AS developer_name, 'Test Durable Title' AS item_name, 4 AS item_price, 'USD' AS item_currency, '' AS description, '' AS item_type, '' AS adg_product_id
-- UNION ALL SELECT 'Rita Test Extension 1' AS extension_name, 'u4xkb2t4a2v6ex9f465sghrpk458a2' AS extension_id, 'B075NW9MMK' AS asin, 'rita_test_consumable_sku_2' AS sku, 'W5U1V' AS vendor_code, 'Test Extension Developer' AS developer_name, 'Extension Consumable' AS item_name, 5 AS item_price, 'USD' AS item_currency, '' AS description, '' AS item_type, '' AS adg_product_id
-- UNION ALL SELECT 'Rita Test Extension 2' AS extension_name, 'r4rnhwch6kvonrnd4exf0y64napgzk' AS extension_id, 'B075MSHXGK' AS asin, 'rita_test_currency_sku' AS sku, 'W5U1V' AS vendor_code, 'Test extension developer' AS developer_name, '500 Twitchlings' AS item_name, 2 AS item_price, 'USD' AS item_currency, '' AS description, '' AS item_type, '' AS adg_product_id
)
, the_valid_extensions AS (
SELECT DISTINCT extension_id FROM the_lookup
)
, the_valid_asins AS (
SELECT DISTINCT asin FROM the_lookup
)
-- used to left join the different logs against
, the_basetable_date AS (
  SELECT year, week_of_year, start_date, end_date + INTERVAL '1 day' - INTERVAL '1 second' AS end_date
  FROM (
    SELECT year, week_of_year, MIN(date)::timestamp AS start_date, MAX(date)::timestamp AS end_date
    FROM metadata.date
    WHERE date>=(SELECT start_date_m10n FROM the_constants)
    AND date<=(SELECT this_week_end_date FROM the_constants)
    GROUP BY 1,2
  )
  ORDER BY 1,2
)

-- a log of user_id where they were previous twitch purchaser for a given week range
, previous_twitch_purchaser_log AS (
  SELECT *, 1 AS flag_prev_commerce_purchaser
  FROM (
    SELECT base.*, rdu.user_id, SUM(rdu.gross_revenue) AS gross
    FROM the_basetable_date AS base
    LEFT JOIN rollups.revenue_daily_user AS rdu ON rdu.day<base.start_date
    WHERE product IN ('fuel','bits','paid_channelsub')
    GROUP BY 1,2,3,4,5
  )
  WHERE gross>0
)
-- a log of user_id where they were previous extension purchaser for a given week range
, previous_extension_purchaser_log AS (
  SELECT *, 1 AS flag_prev_extension_purchaser
  FROM (
    SELECT base.*, ecb.user_id, SUM(el.item_price) AS gross
    FROM the_basetable_date AS base
    LEFT JOIN logs.extension_complete_buy AS ecb ON ecb.time<base.start_date
    LEFT JOIN the_lookup AS el ON ecb.asin=el.asin
    WHERE ecb.asin IN (SELECT asin FROM the_valid_asins)
    GROUP BY 1,2,3,4,5
  )
  WHERE gross>0
)

-- # of new purchasers to extensions  (but bought via subs/fuel/bits before?)
-- # of new purchasers to twitch (never bought via subs/fuel/bits before, i.e. first financial transaction on twitch)
, weekly_new_purchasers AS (
  SELECT year, week_of_year, start_date, end_date, SUM(CASE WHEN flag_prev_commerce_purchaser=0 AND flag_prev_extension_purchaser=0 THEN 1 ELSE 0 END) AS num_new_purchaser_to_twitch
  , SUM(CASE WHEN flag_prev_extension_purchaser=0 THEN 1 ELSE 0 END) AS num_new_purchaser_to_extensions
  FROM (
    SELECT base.*
    , NVL(ptpl.flag_prev_commerce_purchaser,0) AS flag_prev_commerce_purchaser
    , NVL(pepl.flag_prev_extension_purchaser,0) AS flag_prev_extension_purchaser
    FROM (
      SELECT base.*, ecb.user_id
      FROM the_basetable_date AS base
      LEFT JOIN logs.extension_complete_buy AS ecb ON ecb.time>=base.start_date AND ecb.time<=base.end_date
      WHERE ecb.asin IN (SELECT asin FROM the_valid_asins)
      GROUP BY 1,2,3,4,5
    ) AS base
    LEFT JOIN previous_twitch_purchaser_log AS ptpl ON base.user_id = ptpl.user_id AND base.start_date = ptpl.start_date
    LEFT JOIN previous_extension_purchaser_log AS pepl ON base.user_id = pepl.user_id AND base.start_date = ptpl.start_date
  )
  GROUP BY 1,2,3,4
)


--get weekly transactions, num_purchasers, total rev, ARPPU, rev per transaction
, weekly_finance_transactions AS (
  SELECT year, week_of_year, start_date, end_date
    , SUM(el.item_price) AS total_rev, COUNT(1) AS num_transactions, COUNT(DISTINCT user_id) AS num_purchasers
    , SUM(el.item_price)::float/COUNT(DISTINCT user_id)::float AS ARPPU
    , SUM(el.item_price)::float/COUNT(1)::float AS rev_per_transaction
  FROM (
    SELECT base.*, ecb.asin, ecb.user_id, ecb.time
    FROM the_basetable_date AS base
    LEFT JOIN logs.extension_complete_buy AS ecb ON ecb.time>=base.start_date AND ecb.time<=base.end_date
    WHERE ecb.asin IN (SELECT asin FROM the_valid_asins)
  ) AS base
  LEFT JOIN the_lookup AS el ON base.asin=el.asin
  GROUP BY 1,2,3,4
)



--get weekly count of viewers (unique user_id) that saw one of the extensions
, weekly_device_exposed AS (
  SELECT base.*, COUNT(DISTINCT el.login_id) AS num_viewer_exposed
  FROM the_basetable_date AS base
  LEFT JOIN (
    SELECT "time", extension_id, login_id
    FROM logs.extension_render
    WHERE extension_id IN (SELECT extension_id FROM the_valid_extensions) AND time>=(SELECT start_date_m10n FROM the_constants)
    UNION ALL
    SELECT "time", extension_id, login_id
    FROM logs.extension_view
    WHERE extension_id IN (SELECT extension_id FROM the_valid_extensions) AND time>=(SELECT start_date_m10n FROM the_constants)
    AND pct_view_visible>=75
  ) AS el ON el.time>=base.start_date AND el.time<=base.end_date
  GROUP BY 1,2,3,4
)

SELECT wft.*, wnp.num_new_purchaser_to_extensions, wnp.num_new_purchaser_to_twitch, wde.num_viewer_exposed, wft.num_purchasers::float/wde.num_viewer_exposed::float AS conversion_rate_unique_viewers
FROM weekly_finance_transactions AS wft
LEFT JOIN weekly_new_purchasers AS wnp ON wft.start_date = wnp.start_date
LEFT JOIN weekly_device_exposed AS wde ON wft.start_date = wde.start_date
ORDER BY 1,2
