-- SPECIAL README FOR SCIENG: THIS QUERY SHOULD BE RUN FROM THE FOLLOWING DB INSTEAD OF ACE (r.sci.twitch.tv)
-- DB: revenue-dw-instance.cabf1yyi4hc5.us-west-2.redshift.amazonaws.com:5439

-- NOT_STARTED
-- PE_COVERSHEET
-- PE_TIMS_ROYALTY
-- PE_PENDING_TIMS_ROYALTY
-- PE_MISMATCH_TIMS_ROYALTY
-- PE_FAIL_TIMS_ROYALTY
-- PE_TIMS_SERVICE
-- PE_PAYOUT_INFO
-- PE_PENDING_PAYOUT_INFO
-- PE_COMPLETE


WITH
the_stages AS (
  SELECT 'NOT_STARTED' AS stage
  UNION ALL SELECT 'PE_COVERSHEET' AS stage
  UNION ALL SELECT 'PE_TIMS_ROYALTY' AS stage
  UNION ALL SELECT 'PE_PENDING_TIMS_ROYALTY' AS stage
  UNION ALL SELECT 'PE_MISMATCH_TIMS_ROYALTY' AS stage
  UNION ALL SELECT 'PE_FAIL_TIMS_ROYALTY' AS stage
  UNION ALL SELECT 'PE_TIMS_SERVICE' AS stage
  UNION ALL SELECT 'PE_PAYOUT_INFO' AS stage
  UNION ALL SELECT 'PE_PENDING_PAYOUT_INFO' AS stage
  UNION ALL SELECT 'PE_COMPLETE' AS stage
)

, the_stage_logs AS (
	SELECT developers.channelid AS user_id, developers.invitationID, events.state AS the_stage, MAX(events.timestamp) AS "time"
	FROM payout.developer_onboarding_applications as developers
	INNER JOIN payout.payout_events as events
	ON developers.invitationid = events.invitationid
  GROUP BY 1,2,3
)

, final_data AS (
  SELECT user_id, the_stage AS latest_stage, "time"
  FROM (
    SELECT *, MAX("time") OVER (PARTITION BY user_id) AS latest_stage_time
    FROM the_stage_logs
  )
  WHERE latest_stage_time = "time"
)

SELECT * FROM final_data
ORDER BY user_id, "time"
