-- calculate for each client_id the % dedicated streamer that have oauthed the app


WITH
the_constants AS (
  SELECT *
  FROM (
    SELECT '2018-01-24 23:59:59'::TIMESTAMP AS end_time
  )
  LEFT JOIN (
    SELECT COUNT(DISTINCT user_id) AS total_dedicated_streamer
    FROM analysis.dsds155_dedicated_streamer_list
  ) ON 1=1
)



, logs_oauth AS (
  SELECT base.user_id, base.client_id, dtl.name AS app_name, dtl.the_tier, dtl.app_owner_user_id, dtl.redirect_uri, MAX(base.time) AS latest_oauth_time
  FROM logs.oauth_authorize AS base
  RIGHT JOIN analysis.dsds155_dedicated_streamer_list AS dsl ON base.user_id = dsl.user_id --only pull the records of dedicated streamers
  RIGHT JOIN analysis.dsds155_developer_tier_list AS dtl ON base.client_id = dtl.client_id --only pull the records of client apps from tiered list before
  WHERE base.time<=(SELECT end_time FROM the_constants)
  --AND client_id IN (SELECT client_id FROM analysis.dsds155_developer_tier_list)
  --AND user_id IN (SELECT user_id FROM analysis.dsds155_dedicated_streamer_list) --THIS HAS ERROR where user_id in oauth_authorize is not always a number
  GROUP BY 1,2,3,4,5,6
)

, logs_deauth AS (
  SELECT base.user_id, base.client_id, dtl.name AS app_name, dtl.the_tier, dtl.app_owner_user_id, dtl.redirect_uri, MAX(base.time) AS latest_deauth_time
  FROM logs.oauth_deauthorize AS base
  RIGHT JOIN analysis.dsds155_dedicated_streamer_list AS dsl ON base.user_id = dsl.user_id --only pull the records of dedicated streamers
  RIGHT JOIN analysis.dsds155_developer_tier_list AS dtl ON base.client_id = dtl.client_id --only pull the records of client apps from tiered list before
  WHERE base.time<=(SELECT end_time FROM the_constants)
  -- AND client_id IN (SELECT client_id FROM analysis.dsds155_developer_tier_list)
  -- AND user_id IN (SELECT user_id FROM analysis.dsds155_dedicated_streamer_list)
  GROUP BY 1,2,3,4,5,6
)

, logs_net_auth AS (
  SELECT *, 1 AS flag_is_oauth
  FROM (
    SELECT oauth.user_id, oauth.client_id, oauth.app_name, oauth.the_tier
    , oauth.app_owner_user_id, oauth.redirect_uri
    , oauth.latest_oauth_time, deauth.latest_deauth_time
    FROM logs_oauth AS oauth
    LEFT JOIN logs_deauth AS deauth ON oauth.user_id = deauth.user_id AND oauth.client_id = deauth.client_id
  )
  WHERE latest_deauth_time IS NULL OR latest_oauth_time>latest_deauth_time
)

, final_data AS (
  SELECT client_id, app_name, the_tier, COUNT(DISTINCT user_id) AS oauth_dedicated_streamers, MAX(tc.total_dedicated_streamer) AS total_dedicated_streamer
  , COUNT(DISTINCT user_id)::FLOAT / MAX(tc.total_dedicated_streamer)::FLOAT AS pct_dedicated_streamer
  FROM logs_net_auth AS base
  LEFT JOIN the_constants AS tc ON 1=1
  WHERE (base.the_tier = 'Tier 1' OR base.the_tier = 'Tier 2')
  GROUP BY 1,2,3
)

SELECT *
FROM final_data
ORDER BY the_tier, pct_dedicated_streamer DESC
