-- weekly = 12:00 am Mon - 11:59 pm Sun
-- monthly = 12:00 am 1st of the month - 11:59 pm last day of the month

--Extensions Active on Channels
--Note: this will be looking at saturday day end instead of sunday day end since the rollup it depends on runs monday morning and not enough time to get the data
WITH
the_metadata_date_mbr AS (
  SELECT *
  FROM metadata.date AS base
  WHERE base.date>='2017-11-01'::TIMESTAMP --AND base.date<'2018-12-31'::TIMESTAMP
  AND base.date<DATE_TRUNC('month', (SYSDATE - INTERVAL '7 hours'))
)
, the_constants_mbr AS (
  SELECT year, month, MIN(date)::TIMESTAMP AS start_time, MAX(date)::TIMESTAMP + INTERVAL '1 day' - INTERVAL '1 second' AS end_time
  FROM the_metadata_date_mbr
  GROUP BY 1,2
)

, extension_active_on_channels_log AS (
  SELECT base.*, edcp.the_day, edcp.channel_id, edcp.extension_id
  FROM the_constants_mbr AS base
  LEFT JOIN rollups.extension_daily_channel_presence AS edcp ON edcp.the_day::TIMESTAMP= DATE_TRUNC('day', base.end_time)::TIMESTAMP -- - INTERVAL '1 day'
  WHERE edcp.bool_extension_activated
)

, mbr_extension_active_on_channels AS (
  SELECT year, month, start_time, end_time, COUNT(1) AS extensions_active_on_channels
  FROM extension_active_on_channels_log
  GROUP BY 1,2,3,4
)

SELECT * FROM mbr_extension_active_on_channels ORDER BY 1,2
